/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hertzbeat.collector.collect.redfish;

import java.nio.charset.StandardCharsets;
import org.apache.hertzbeat.collector.collect.common.http.CommonHttpClient;
import org.apache.hertzbeat.collector.collect.redfish.ConnectSession;
import org.apache.hertzbeat.collector.collect.redfish.RedfishConnectSession;
import org.apache.hertzbeat.collector.collect.redfish.Session;
import org.apache.hertzbeat.common.entity.job.protocol.RedfishProtocol;
import org.apache.hertzbeat.common.util.IpDomainUtil;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.methods.RequestBuilder;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.entity.StringEntity;
import org.apache.http.protocol.HttpContext;

public class RedfishClient {
    private final String host;
    private final Integer port;
    private final String username;
    private final String password;
    private final Integer timeout;
    public static final String REDFISH_SESSION_SERVICE = "/redfish/v1/SessionService/Sessions";

    protected RedfishClient(String host, int port, String username, String password, Integer timeout) {
        this.host = host;
        this.port = port;
        this.username = username;
        this.password = password;
        this.timeout = timeout;
    }

    public static RedfishClient create(RedfishProtocol redfishProtocol) {
        return new RedfishClient(redfishProtocol.getHost(), Integer.parseInt(redfishProtocol.getPort()), redfishProtocol.getUsername(), redfishProtocol.getPassword(), Integer.parseInt(redfishProtocol.getTimeout()));
    }

    public ConnectSession connect() throws Exception {
        Session session;
        HttpHost host = new HttpHost(this.host, this.port.intValue());
        HttpClientContext httpClientContext = new HttpClientContext();
        httpClientContext.setTargetHost(host);
        RequestBuilder requestBuilder = RequestBuilder.post();
        String uri = REDFISH_SESSION_SERVICE;
        if (IpDomainUtil.isHasSchema((String)this.host)) {
            requestBuilder.setUri(this.host + ":" + this.port + uri);
        } else {
            String ipAddressType = IpDomainUtil.checkIpAddressType((String)this.host);
            String baseUri = "ipv6".equals(ipAddressType) ? String.format("[%s]:%s", this.host, this.port + uri) : String.format("%s:%s", this.host, this.port + uri);
            requestBuilder.setUri("https://" + baseUri);
        }
        requestBuilder.addHeader("Connection", "Keep-Alive");
        requestBuilder.addHeader("Content-Type", "application/json");
        requestBuilder.addHeader("User-Agent", "Mozilla/5.0 (Windows NT 6.1; WOW64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/41.0.2272.76 Safari/537.36");
        requestBuilder.addHeader("Content-Encoding", "" + StandardCharsets.UTF_8);
        String json = "{\"UserName\": \"" + this.username + "\", \"Password\": \"" + this.password + "\"}";
        StringEntity entity = new StringEntity(json, StandardCharsets.UTF_8);
        requestBuilder.setEntity((HttpEntity)entity);
        if (this.timeout > 0) {
            RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout(this.timeout.intValue()).setSocketTimeout(this.timeout.intValue()).setRedirectsEnabled(true).build();
            requestBuilder.setConfig(requestConfig);
        }
        HttpUriRequest request = requestBuilder.build();
        try (CloseableHttpResponse response = CommonHttpClient.getHttpClient().execute(request, (HttpContext)httpClientContext);){
            int statusCode = response.getStatusLine().getStatusCode();
            if (statusCode != 201) {
                throw new Exception("StatusCode " + statusCode);
            }
            String location = response.getFirstHeader("Location").getValue();
            String auth = response.getFirstHeader("X-Auth-Token").getValue();
            session = new Session(auth, location, this.host, this.port);
        }
        catch (Exception e) {
            throw new Exception("Redfish session create error: " + e.getMessage());
        }
        finally {
            request.abort();
        }
        return new RedfishConnectSession(session);
    }
}

