/*
 * Decompiled with CFR 0.152.
 */
package io.lettuce.core.cluster;

import io.lettuce.core.protocol.CommandType;
import io.lettuce.core.protocol.ProtocolKeyword;
import io.lettuce.core.protocol.ReadOnlyCommands;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Set;

public class ClusterReadOnlyCommands {
    private static final Set<CommandType> READ_ONLY_COMMANDS = EnumSet.noneOf(CommandType.class);
    private static final ReadOnlyCommands.ReadOnlyPredicate PREDICATE = command -> ClusterReadOnlyCommands.isReadOnlyCommand(command.getType());

    public static boolean isReadOnlyCommand(ProtocolKeyword protocolKeyword) {
        return READ_ONLY_COMMANDS.contains(protocolKeyword);
    }

    public static Set<CommandType> getReadOnlyCommands() {
        return Collections.unmodifiableSet(READ_ONLY_COMMANDS);
    }

    public static ReadOnlyCommands.ReadOnlyPredicate asPredicate() {
        return PREDICATE;
    }

    static {
        READ_ONLY_COMMANDS.addAll(ReadOnlyCommands.getReadOnlyCommands());
        for (CommandName commandNames : CommandName.values()) {
            READ_ONLY_COMMANDS.add(CommandType.valueOf(commandNames.name()));
        }
    }

    static enum CommandName {
        PUBLISH,
        PUBSUB,
        PSUBSCRIBE,
        PUNSUBSCRIBE,
        SUBSCRIBE,
        UNSUBSCRIBE,
        SSUBSCRIBE;

    }
}

