/*
 * Decompiled with CFR 0.152.
 */
package dm.jdbc.driver;

import dm.jdbc.desc.ExecuteRetInfo;
import dm.jdbc.driver.DmdbConnection;
import dm.jdbc.driver.DmdbResultSetCache;
import dm.jdbc.driver.DmdbResultSetKey;
import dm.jdbc.driver.DmdbStatement;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class DmdbResultSetCachePool {
    static Map rsHashMap = null;
    static List keyList = null;
    static long totalDataLen;

    static {
        rsHashMap = Collections.synchronizedMap(new HashMap(100));
        keyList = Collections.synchronizedList(new LinkedList());
        totalDataLen = 0L;
    }

    private static long removeLast() {
        int n2 = keyList.size();
        if (n2 == 0) {
            return 0L;
        }
        DmdbResultSetKey dmdbResultSetKey = (DmdbResultSetKey)keyList.remove(n2 - 1);
        if (dmdbResultSetKey == null) {
            return 0L;
        }
        DmdbResultSetCache dmdbResultSetCache = (DmdbResultSetCache)rsHashMap.remove(dmdbResultSetKey);
        if (dmdbResultSetCache == null) {
            return 0L;
        }
        return dmdbResultSetCache.getDataLen();
    }

    private static void refreshKeyList(DmdbResultSetKey dmdbResultSetKey) {
        keyList.remove(dmdbResultSetKey);
        keyList.add(0, dmdbResultSetKey);
    }

    public static void addResultSet(DmdbStatement dmdbStatement, String string, ExecuteRetInfo executeRetInfo) {
        DmdbConnection dmdbConnection = dmdbStatement.connection;
        long l2 = executeRetInfo == null ? 0L : executeRetInfo.rsSizeof;
        long l3 = dmdbConnection.rsCacheSize * 1024 * 1024;
        while (totalDataLen + l2 > l3) {
            if (totalDataLen == 0L) {
                return;
            }
            totalDataLen -= DmdbResultSetCachePool.removeLast();
        }
        DmdbResultSetKey dmdbResultSetKey = new DmdbResultSetKey(dmdbConnection.guid, dmdbConnection.schema, string, dmdbStatement);
        DmdbResultSetCachePool.refreshKeyList(dmdbResultSetKey);
        DmdbResultSetCache dmdbResultSetCache = new DmdbResultSetCache(executeRetInfo);
        rsHashMap.put(dmdbResultSetKey, dmdbResultSetCache);
        totalDataLen += l2;
    }

    public static DmdbResultSetCache getResultSetCache(String string, String string2, String string3, DmdbStatement dmdbStatement) {
        DmdbResultSetKey dmdbResultSetKey = new DmdbResultSetKey(string, string2, string3, dmdbStatement);
        DmdbResultSetCache dmdbResultSetCache = (DmdbResultSetCache)rsHashMap.get(dmdbResultSetKey);
        if (dmdbResultSetCache == null) {
            return null;
        }
        if (dmdbResultSetCache.refreshed(dmdbStatement.connection)) {
            rsHashMap.remove(dmdbResultSetKey);
            keyList.remove(dmdbResultSetKey);
            return null;
        }
        DmdbResultSetCachePool.refreshKeyList(dmdbResultSetKey);
        return dmdbResultSetCache;
    }
}

