/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.aop.interceptor;

import java.lang.reflect.Method;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.aopalliance.intercept.MethodInvocation;
import org.apache.commons.logging.Log;
import org.springframework.aop.interceptor.AbstractTraceInterceptor;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.StopWatch;
import org.springframework.util.StringUtils;

public class CustomizableTraceInterceptor
extends AbstractTraceInterceptor {
    public static final String PLACEHOLDER_METHOD_NAME = "$[methodName]";
    public static final String PLACEHOLDER_TARGET_CLASS_NAME = "$[targetClassName]";
    public static final String PLACEHOLDER_TARGET_CLASS_SHORT_NAME = "$[targetClassShortName]";
    public static final String PLACEHOLDER_RETURN_VALUE = "$[returnValue]";
    public static final String PLACEHOLDER_ARGUMENT_TYPES = "$[argumentTypes]";
    public static final String PLACEHOLDER_ARGUMENTS = "$[arguments]";
    public static final String PLACEHOLDER_EXCEPTION = "$[exception]";
    public static final String PLACEHOLDER_INVOCATION_TIME = "$[invocationTime]";
    private static final String DEFAULT_ENTER_MESSAGE = "Entering method '$[methodName]' of class [$[targetClassName]]";
    private static final String DEFAULT_EXIT_MESSAGE = "Exiting method '$[methodName]' of class [$[targetClassName]]";
    private static final String DEFAULT_EXCEPTION_MESSAGE = "Exception thrown in method '$[methodName]' of class [$[targetClassName]]";
    private static final Pattern PATTERN = Pattern.compile("\\$\\[\\p{Alpha}+]");
    static final Set<String> ALLOWED_PLACEHOLDERS = Set.of("$[methodName]", "$[targetClassName]", "$[targetClassShortName]", "$[returnValue]", "$[argumentTypes]", "$[arguments]", "$[exception]", "$[invocationTime]");
    private String enterMessage = "Entering method '$[methodName]' of class [$[targetClassName]]";
    private String exitMessage = "Exiting method '$[methodName]' of class [$[targetClassName]]";
    private String exceptionMessage = "Exception thrown in method '$[methodName]' of class [$[targetClassName]]";

    public void setEnterMessage(String enterMessage) throws IllegalArgumentException {
        Assert.hasText((String)enterMessage, (String)"enterMessage must not be empty");
        CustomizableTraceInterceptor.checkForInvalidPlaceholders(enterMessage);
        Assert.doesNotContain((String)enterMessage, (String)PLACEHOLDER_RETURN_VALUE, (String)"enterMessage cannot contain placeholder $[returnValue]");
        Assert.doesNotContain((String)enterMessage, (String)PLACEHOLDER_EXCEPTION, (String)"enterMessage cannot contain placeholder $[exception]");
        Assert.doesNotContain((String)enterMessage, (String)PLACEHOLDER_INVOCATION_TIME, (String)"enterMessage cannot contain placeholder $[invocationTime]");
        this.enterMessage = enterMessage;
    }

    public void setExitMessage(String exitMessage) {
        Assert.hasText((String)exitMessage, (String)"exitMessage must not be empty");
        CustomizableTraceInterceptor.checkForInvalidPlaceholders(exitMessage);
        Assert.doesNotContain((String)exitMessage, (String)PLACEHOLDER_EXCEPTION, (String)"exitMessage cannot contain placeholder$[exception]");
        this.exitMessage = exitMessage;
    }

    public void setExceptionMessage(String exceptionMessage) {
        Assert.hasText((String)exceptionMessage, (String)"exceptionMessage must not be empty");
        CustomizableTraceInterceptor.checkForInvalidPlaceholders(exceptionMessage);
        Assert.doesNotContain((String)exceptionMessage, (String)PLACEHOLDER_RETURN_VALUE, (String)"exceptionMessage cannot contain placeholder $[returnValue]");
        this.exceptionMessage = exceptionMessage;
    }

    @Override
    protected Object invokeUnderTrace(MethodInvocation invocation, Log logger) throws Throwable {
        String name = ClassUtils.getQualifiedMethodName((Method)invocation.getMethod());
        StopWatch stopWatch = new StopWatch(name);
        Object returnValue = null;
        boolean exitThroughException = false;
        try {
            stopWatch.start(name);
            this.writeToLog(logger, this.replacePlaceholders(this.enterMessage, invocation, null, null, -1L));
            Object object = returnValue = invocation.proceed();
            return object;
        }
        catch (Throwable ex) {
            if (stopWatch.isRunning()) {
                stopWatch.stop();
            }
            exitThroughException = true;
            this.writeToLog(logger, this.replacePlaceholders(this.exceptionMessage, invocation, null, ex, stopWatch.getTotalTimeMillis()), ex);
            throw ex;
        }
        finally {
            if (!exitThroughException) {
                if (stopWatch.isRunning()) {
                    stopWatch.stop();
                }
                this.writeToLog(logger, this.replacePlaceholders(this.exitMessage, invocation, returnValue, null, stopWatch.getTotalTimeMillis()));
            }
        }
    }

    protected String replacePlaceholders(String message, MethodInvocation methodInvocation, @Nullable Object returnValue, @Nullable Throwable throwable, long invocationTime) {
        Object target = methodInvocation.getThis();
        Assert.state((target != null ? 1 : 0) != 0, (String)"Target must not be null");
        StringBuilder output = new StringBuilder();
        Matcher matcher = PATTERN.matcher(message);
        block20: while (matcher.find()) {
            String match;
            switch (match = matcher.group()) {
                case "$[methodName]": {
                    matcher.appendReplacement(output, Matcher.quoteReplacement(methodInvocation.getMethod().getName()));
                    continue block20;
                }
                case "$[targetClassName]": {
                    String className = this.getClassForLogging(target).getName();
                    matcher.appendReplacement(output, Matcher.quoteReplacement(className));
                    continue block20;
                }
                case "$[targetClassShortName]": {
                    String shortName = ClassUtils.getShortName(this.getClassForLogging(target));
                    matcher.appendReplacement(output, Matcher.quoteReplacement(shortName));
                    continue block20;
                }
                case "$[arguments]": {
                    matcher.appendReplacement(output, Matcher.quoteReplacement(StringUtils.arrayToCommaDelimitedString((Object[])methodInvocation.getArguments())));
                    continue block20;
                }
                case "$[argumentTypes]": {
                    CustomizableTraceInterceptor.appendArgumentTypes(methodInvocation, matcher, output);
                    continue block20;
                }
                case "$[returnValue]": {
                    CustomizableTraceInterceptor.appendReturnValue(methodInvocation, matcher, output, returnValue);
                    continue block20;
                }
                case "$[exception]": {
                    if (throwable == null) continue block20;
                    matcher.appendReplacement(output, Matcher.quoteReplacement(throwable.toString()));
                    continue block20;
                }
                case "$[invocationTime]": {
                    matcher.appendReplacement(output, Long.toString(invocationTime));
                    continue block20;
                }
            }
            throw new IllegalArgumentException("Unknown placeholder [" + match + "]");
        }
        matcher.appendTail(output);
        return output.toString();
    }

    private static void appendReturnValue(MethodInvocation methodInvocation, Matcher matcher, StringBuilder output, @Nullable Object returnValue) {
        if (methodInvocation.getMethod().getReturnType() == Void.TYPE) {
            matcher.appendReplacement(output, "void");
        } else if (returnValue == null) {
            matcher.appendReplacement(output, "null");
        } else {
            matcher.appendReplacement(output, Matcher.quoteReplacement(returnValue.toString()));
        }
    }

    private static void appendArgumentTypes(MethodInvocation methodInvocation, Matcher matcher, StringBuilder output) {
        Class<?>[] argumentTypes = methodInvocation.getMethod().getParameterTypes();
        Object[] argumentTypeShortNames = new String[argumentTypes.length];
        for (int i = 0; i < argumentTypeShortNames.length; ++i) {
            argumentTypeShortNames[i] = ClassUtils.getShortName(argumentTypes[i]);
        }
        matcher.appendReplacement(output, Matcher.quoteReplacement(StringUtils.arrayToCommaDelimitedString((Object[])argumentTypeShortNames)));
    }

    private static void checkForInvalidPlaceholders(String message) throws IllegalArgumentException {
        Matcher matcher = PATTERN.matcher(message);
        while (matcher.find()) {
            String match = matcher.group();
            if (ALLOWED_PLACEHOLDERS.contains(match)) continue;
            throw new IllegalArgumentException("Placeholder [" + match + "] is not valid");
        }
    }
}

