/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.observers;

import io.reactivex.CompletableObserver;
import io.reactivex.MaybeObserver;
import io.reactivex.SingleObserver;
import io.reactivex.disposables.Disposable;
import io.reactivex.internal.util.BlockingHelper;
import io.reactivex.internal.util.ExceptionHelper;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public final class BlockingMultiObserver<T>
extends CountDownLatch
implements SingleObserver<T>,
CompletableObserver,
MaybeObserver<T> {
    T value;
    Throwable error;
    Disposable upstream;
    volatile boolean cancelled;

    public BlockingMultiObserver() {
        super(1);
    }

    void dispose() {
        this.cancelled = true;
        Disposable d = this.upstream;
        if (d != null) {
            d.dispose();
        }
    }

    @Override
    public void onSubscribe(Disposable d) {
        this.upstream = d;
        if (this.cancelled) {
            d.dispose();
        }
    }

    @Override
    public void onSuccess(T value) {
        this.value = value;
        this.countDown();
    }

    @Override
    public void onError(Throwable e) {
        this.error = e;
        this.countDown();
    }

    @Override
    public void onComplete() {
        this.countDown();
    }

    public T blockingGet() {
        Throwable ex;
        if (this.getCount() != 0L) {
            try {
                BlockingHelper.verifyNonBlocking();
                this.await();
            }
            catch (InterruptedException ex2) {
                this.dispose();
                throw ExceptionHelper.wrapOrThrow(ex2);
            }
        }
        if ((ex = this.error) != null) {
            throw ExceptionHelper.wrapOrThrow(ex);
        }
        return this.value;
    }

    public T blockingGet(T defaultValue) {
        Throwable ex;
        if (this.getCount() != 0L) {
            try {
                BlockingHelper.verifyNonBlocking();
                this.await();
            }
            catch (InterruptedException ex2) {
                this.dispose();
                throw ExceptionHelper.wrapOrThrow(ex2);
            }
        }
        if ((ex = this.error) != null) {
            throw ExceptionHelper.wrapOrThrow(ex);
        }
        T v = this.value;
        return v != null ? v : defaultValue;
    }

    public Throwable blockingGetError() {
        if (this.getCount() != 0L) {
            try {
                BlockingHelper.verifyNonBlocking();
                this.await();
            }
            catch (InterruptedException ex) {
                this.dispose();
                return ex;
            }
        }
        return this.error;
    }

    public Throwable blockingGetError(long timeout, TimeUnit unit) {
        if (this.getCount() != 0L) {
            try {
                BlockingHelper.verifyNonBlocking();
                if (!this.await(timeout, unit)) {
                    this.dispose();
                    throw ExceptionHelper.wrapOrThrow(new TimeoutException(ExceptionHelper.timeoutMessage(timeout, unit)));
                }
            }
            catch (InterruptedException ex) {
                this.dispose();
                throw ExceptionHelper.wrapOrThrow(ex);
            }
        }
        return this.error;
    }

    public boolean blockingAwait(long timeout, TimeUnit unit) {
        Throwable ex;
        if (this.getCount() != 0L) {
            try {
                BlockingHelper.verifyNonBlocking();
                if (!this.await(timeout, unit)) {
                    this.dispose();
                    return false;
                }
            }
            catch (InterruptedException ex2) {
                this.dispose();
                throw ExceptionHelper.wrapOrThrow(ex2);
            }
        }
        if ((ex = this.error) != null) {
            throw ExceptionHelper.wrapOrThrow(ex);
        }
        return true;
    }
}

