/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.tx.impl;

import java.util.Collection;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import org.apache.ignite.internal.logger.IgniteLogger;
import org.apache.ignite.internal.logger.Loggers;
import org.apache.ignite.internal.network.MessagingService;
import org.apache.ignite.internal.network.NetworkMessage;
import org.apache.ignite.internal.network.TopologyService;
import org.apache.ignite.internal.tx.impl.TransactionInflights;
import org.apache.ignite.internal.tx.message.FinishedTransactionsBatchMessage;
import org.apache.ignite.internal.tx.message.TxMessagesFactory;
import org.apache.ignite.network.ClusterNode;

public class FinishedReadOnlyTransactionTracker {
    private static final IgniteLogger LOG = Loggers.forClass(FinishedReadOnlyTransactionTracker.class);
    private static final TxMessagesFactory FACTORY = new TxMessagesFactory();
    private final TopologyService topologyService;
    private final MessagingService messagingService;
    private final TransactionInflights transactionInflights;

    public FinishedReadOnlyTransactionTracker(TopologyService topologyService, MessagingService messagingService, TransactionInflights transactionInflights) {
        this.topologyService = topologyService;
        this.messagingService = messagingService;
        this.transactionInflights = transactionInflights;
    }

    public void broadcastClosedTransactions() {
        try {
            Collection<UUID> txToSend = this.transactionInflights.finishedReadOnlyTransactions();
            if (!txToSend.isEmpty()) {
                FinishedTransactionsBatchMessage message = FACTORY.finishedTransactionsBatchMessage().transactions(txToSend).build();
                CompletableFuture[] messages = (CompletableFuture[])this.topologyService.allMembers().stream().map(clusterNode -> this.sendCursorCleanupCommand((ClusterNode)clusterNode, message)).toArray(CompletableFuture[]::new);
                CompletableFuture.allOf(messages).thenRun(() -> this.transactionInflights.removeTxContexts(txToSend));
            }
        }
        catch (Throwable err) {
            LOG.error("Error occurred during broadcasting closed transactions.", err);
            throw err;
        }
    }

    private CompletableFuture<Void> sendCursorCleanupCommand(ClusterNode node, FinishedTransactionsBatchMessage message) {
        return this.messagingService.send(node, (NetworkMessage)message);
    }

    void onTransactionFinished(UUID id) {
        this.transactionInflights.markReadOnlyTxFinished(id);
    }
}

