/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.network.serialization.marshal;

import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import org.apache.ignite.internal.network.serialization.marshal.BuiltInMarshalling;
import org.apache.ignite.internal.network.serialization.marshal.MarshalException;
import org.apache.ignite.internal.network.serialization.marshal.MarshallingContext;
import org.apache.ignite.internal.network.serialization.marshal.UnmarshalException;
import org.apache.ignite.internal.network.serialization.marshal.UnmarshallingContext;
import org.apache.ignite.internal.network.serialization.marshal.ValueReader;
import org.apache.ignite.internal.network.serialization.marshal.ValueWriter;
import org.apache.ignite.internal.util.io.IgniteDataInput;
import org.apache.ignite.internal.util.io.IgniteDataOutput;

class ProxyMarshaller {
    private final ValueWriter<Object> valueWriter;
    private final ValueReader<Object> valueReader;
    private static final InvocationHandler placeholderInvocationHandler = new PlaceholderInvocationHandler();
    private static final Field proxyHandlerField = ProxyMarshaller.findProxyHandlerField();

    private static Field findProxyHandlerField() {
        Field field;
        try {
            field = Proxy.class.getDeclaredField("h");
        }
        catch (NoSuchFieldException e) {
            throw new ExceptionInInitializerError(e);
        }
        field.setAccessible(true);
        return field;
    }

    ProxyMarshaller(ValueWriter<Object> valueWriter, ValueReader<Object> valueReader) {
        this.valueWriter = valueWriter;
        this.valueReader = valueReader;
    }

    static boolean isProxyClass(Class<?> classToCheck) {
        return Proxy.isProxyClass(classToCheck);
    }

    void writeProxy(Object proxy, IgniteDataOutput output, MarshallingContext context) throws MarshalException, IOException {
        assert (Proxy.isProxyClass(proxy.getClass()));
        BuiltInMarshalling.writeClassArray(proxy.getClass().getInterfaces(), output, context);
        this.valueWriter.write(Proxy.getInvocationHandler(proxy), output, context);
    }

    Object preInstantiateProxy(IgniteDataInput input, UnmarshallingContext context) throws UnmarshalException, IOException {
        Class<?>[] interfaces = BuiltInMarshalling.readClassArray(input, context);
        return Proxy.newProxyInstance(context.classLoader(), interfaces, placeholderInvocationHandler);
    }

    void fillProxyFrom(IgniteDataInput input, Object proxyToFill, UnmarshallingContext context) throws UnmarshalException, IOException {
        InvocationHandler invocationHandler = this.readInvocationHandler(input, context);
        this.replaceInvocationHandler(proxyToFill, invocationHandler);
    }

    private InvocationHandler readInvocationHandler(IgniteDataInput input, UnmarshallingContext context) throws IOException, UnmarshalException {
        Object object = this.valueReader.read(input, context);
        if (!(object instanceof InvocationHandler)) {
            throw new UnmarshalException("Expected an InvocationHandler, but read " + String.valueOf(object));
        }
        return (InvocationHandler)object;
    }

    private void replaceInvocationHandler(Object objectToFill, InvocationHandler invocationHandler) throws UnmarshalException {
        try {
            proxyHandlerField.set(objectToFill, invocationHandler);
        }
        catch (IllegalAccessException e) {
            throw new UnmarshalException("Cannot set Proxy.h", (Throwable)e);
        }
    }

    private static class PlaceholderInvocationHandler
    implements InvocationHandler {
        private PlaceholderInvocationHandler() {
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            if ("equals".equals(method.getName()) && method.getParameterTypes().length == 1 && method.getParameterTypes()[0] == Object.class) {
                return proxy == args[0];
            }
            if ("hashCode".equals(method.getName()) && this.noArgs(method)) {
                return this.hashCode();
            }
            if ("toString".equals(method.getName()) && this.noArgs(method)) {
                return "Proxy with placeholder";
            }
            throw new UnsupportedOperationException("This is a dummy placeholder, but it was got an invocation on " + String.valueOf(method));
        }

        private boolean noArgs(Method method) {
            return method.getParameterTypes().length == 0;
        }
    }
}

