/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.deployunit;

import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.BiConsumer;
import org.apache.ignite.deployment.version.Version;
import org.apache.ignite.internal.deployunit.DeploymentStatus;
import org.apache.ignite.internal.deployunit.exception.DeploymentUnitReadException;
import org.apache.ignite.internal.deployunit.metastore.DeploymentUnitStore;
import org.apache.ignite.internal.deployunit.metastore.status.UnitNodeStatus;
import org.apache.ignite.internal.logger.IgniteLogger;
import org.apache.ignite.internal.logger.Loggers;
import org.apache.ignite.internal.tostring.IgniteToStringInclude;
import org.apache.ignite.internal.tostring.S;
import org.apache.ignite.internal.util.CompletableFutures;

public class StaticUnitDeployer {
    private static final IgniteLogger LOG = Loggers.forClass(StaticUnitDeployer.class);
    private final DeploymentUnitStore deploymentUnitStore;
    private final String nodeName;
    private final Path deploymentUnitsRoot;

    public StaticUnitDeployer(DeploymentUnitStore deploymentUnitStore, String nodeName, Path deploymentUnitsRoot) {
        this.deploymentUnitStore = deploymentUnitStore;
        this.nodeName = nodeName;
        this.deploymentUnitsRoot = deploymentUnitsRoot;
    }

    public CompletableFuture<Void> searchAndDeployStaticUnits() {
        StaticUnits allUnits = this.collectStaticUnits();
        return this.deploymentUnitStore.getNodeStatuses(this.nodeName).thenCompose(statuses -> {
            ArrayList futures = new ArrayList();
            for (UnitNodeStatus status : statuses) {
                allUnits.filter(status.id(), status.version());
            }
            LOG.info("Start processing static deployment units {}", new Object[]{allUnits});
            allUnits.forEach((id, version) -> {
                CompletionStage future = this.deploymentUnitStore.createClusterStatus((String)id, (Version)version, Set.of(this.nodeName)).thenCompose(status -> {
                    if (status == null) {
                        return this.deploymentUnitStore.getClusterStatus((String)id, (Version)version).thenCompose(it -> this.deploymentUnitStore.createNodeStatus(this.nodeName, (String)id, (Version)version, it.opId(), DeploymentStatus.DEPLOYED));
                    }
                    return this.deploymentUnitStore.createNodeStatus(this.nodeName, (String)id, (Version)version, status.opId(), DeploymentStatus.DEPLOYED);
                });
                futures.add(future);
            });
            return CompletableFutures.allOf(futures).whenComplete((unused, t) -> {
                if (!futures.isEmpty()) {
                    LOG.info("Finished static units deploy {}", t, new Object[]{allUnits});
                }
            });
        });
    }

    private StaticUnits collectStaticUnits() {
        StaticUnits units = new StaticUnits();
        List<Path> unitFolders = StaticUnitDeployer.allSubdirectories(this.deploymentUnitsRoot);
        for (Path unitFolder : unitFolders) {
            List<Path> versions = StaticUnitDeployer.allSubdirectories(unitFolder);
            for (Path versionFolder : versions) {
                units.register(unitFolder.getFileName().toString(), Version.parseVersion((String)versionFolder.getFileName().toString()));
            }
        }
        return units;
    }

    private static List<Path> allSubdirectories(Path folder) {
        if (Files.notExists(folder, new LinkOption[0])) {
            return Collections.emptyList();
        }
        try {
            final ArrayList<Path> subfolders = new ArrayList<Path>();
            Files.walkFileTree(folder, Set.of(), 1, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    if (attrs.isDirectory()) {
                        subfolders.add(file);
                    }
                    return super.visitFile(file, attrs);
                }
            });
            return subfolders;
        }
        catch (IOException e) {
            LOG.error("Failed to collect static deployment unit folders.", (Throwable)e);
            throw new DeploymentUnitReadException(e);
        }
    }

    private static class StaticUnits {
        @IgniteToStringInclude
        private final Map<String, Set<Version>> units = new HashMap<String, Set<Version>>();

        private StaticUnits() {
        }

        void filter(String id, Version version) {
            Set<Version> versions = this.units.get(id);
            if (versions != null) {
                versions.remove(version);
            }
        }

        void register(String id, Version version) {
            this.units.computeIfAbsent(id, k -> new HashSet()).add(version);
        }

        void forEach(BiConsumer<String, Version> consumer) {
            for (Map.Entry<String, Set<Version>> entry : this.units.entrySet()) {
                for (Version version : entry.getValue()) {
                    consumer.accept(entry.getKey(), version);
                }
            }
        }

        public String toString() {
            return S.toString((Object)this);
        }
    }
}

