/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.sql.engine.exec.fsm;

import java.util.concurrent.CompletableFuture;
import org.apache.ignite.internal.tostring.IgniteToStringExclude;
import org.apache.ignite.internal.tostring.S;
import org.jetbrains.annotations.Nullable;

class Result {
    private final Status status;
    @IgniteToStringExclude
    @Nullable
    private final CompletableFuture<Void> await;

    static Result completed() {
        return new Result(Status.COMPLETED, null);
    }

    static Result proceedAfter(CompletableFuture<Void> stage) {
        assert (stage != null);
        return new Result(Status.WAITING_FOR_COMPLETION, stage);
    }

    private Result(Status status, @Nullable CompletableFuture<Void> await) {
        this.status = status;
        this.await = await;
    }

    Status status() {
        return this.status;
    }

    @Nullable
    CompletableFuture<Void> await() {
        return this.await;
    }

    public String toString() {
        return S.toString((Object)this);
    }

    static enum Status {
        COMPLETED,
        WAITING_FOR_COMPLETION;

    }
}

