/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.sql.engine.rule.logical;

import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelOptTable;
import org.apache.calcite.plan.RelRule;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.TableScan;
import org.apache.calcite.rel.hint.RelHint;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.util.ImmutableIntList;
import org.apache.calcite.util.Util;
import org.apache.ignite3.internal.sql.engine.hint.IgniteHint;
import org.apache.ignite3.internal.sql.engine.prepare.bounds.SearchBounds;
import org.apache.ignite3.internal.sql.engine.rel.AbstractIndexScan;
import org.apache.ignite3.internal.sql.engine.rel.logical.IgniteLogicalIndexScan;
import org.apache.ignite3.internal.sql.engine.rel.logical.IgniteLogicalTableScan;
import org.apache.ignite3.internal.sql.engine.rule.logical.ImmutableExposeIndexRule;
import org.apache.ignite3.internal.sql.engine.schema.IgniteIndex;
import org.apache.ignite3.internal.sql.engine.schema.IgniteTable;
import org.apache.ignite3.internal.sql.engine.util.HintUtils;
import org.apache.ignite3.internal.util.IgniteUtils;
import org.apache.ignite3.lang.ErrorGroups;
import org.apache.ignite3.sql.SqlException;
import org.immutables.value.Value;

@Value.Enclosing
public class ExposeIndexRule
extends RelRule<Config> {
    public static final RelOptRule INSTANCE = Config.DEFAULT.withDescription("ExposeIndexRule").toRule();
    private static final EnumSet<IgniteHint> INDEX_HINTS = EnumSet.of(IgniteHint.NO_INDEX, IgniteHint.FORCE_INDEX);

    private ExposeIndexRule(Config config) {
        super((RelRule.Config)config);
    }

    private static boolean preMatch(IgniteLogicalTableScan scan) {
        return !((IgniteTable)scan.getTable().unwrap(IgniteTable.class)).indexes().isEmpty();
    }

    public void onMatch(RelOptRuleCall call) {
        IgniteLogicalTableScan scan = (IgniteLogicalTableScan)call.rel(0);
        RelOptCluster cluster = scan.getCluster();
        RelOptTable optTable = scan.getTable();
        IgniteTable igniteTable = (IgniteTable)optTable.unwrap(IgniteTable.class);
        List<String> names = scan.fieldNames();
        List<RexNode> proj = scan.projects();
        RexNode condition = scan.condition();
        ImmutableIntList requiredCols = scan.requiredColumns();
        List<IgniteLogicalIndexScan> indexes = igniteTable.indexes().values().stream().map(idx -> idx.toRel(cluster, optTable, names, proj, condition, requiredCols)).filter(idx -> ExposeIndexRule.filter(igniteTable, idx.indexName(), idx.searchBounds())).collect(Collectors.toList());
        if (indexes.isEmpty()) {
            return;
        }
        if ((indexes = ExposeIndexRule.applyHints(scan, indexes)).isEmpty()) {
            return;
        }
        HashMap<RelNode, IgniteLogicalTableScan> equivMap = IgniteUtils.newHashMap(indexes.size());
        for (int i = 1; i < indexes.size(); ++i) {
            equivMap.put((RelNode)indexes.get(i), scan);
        }
        call.transformTo((RelNode)indexes.get(0), equivMap);
    }

    private static List<IgniteLogicalIndexScan> applyHints(TableScan scan, List<IgniteLogicalIndexScan> indexes) {
        List<RelHint> hints = HintUtils.hints(scan, INDEX_HINTS);
        if (hints.isEmpty()) {
            return indexes;
        }
        Set tblIdxNames = indexes.stream().map(AbstractIndexScan::indexName).collect(Collectors.toSet());
        HashSet<Object> idxToSkip = new HashSet<Object>(IgniteUtils.capacity(tblIdxNames.size()));
        HashSet<String> idxToUse = new HashSet<String>(IgniteUtils.capacity(tblIdxNames.size()));
        for (RelHint hint : hints) {
            List hintIdxNames = hint.listOptions;
            boolean noIndex = hint.hintName.equals(IgniteHint.NO_INDEX.name());
            if (hintIdxNames.isEmpty()) {
                if (!noIndex) continue;
                if (!idxToUse.isEmpty()) {
                    throw new SqlException(ErrorGroups.Sql.STMT_VALIDATION_ERR, "Indexes " + idxToUse + " of table '" + (String)Util.last((List)scan.getTable().getQualifiedName()) + "' has already been forced to use by other hints before.");
                }
                idxToSkip.addAll(tblIdxNames);
                continue;
            }
            for (String hintIdxName : hintIdxNames) {
                if (!tblIdxNames.contains(hintIdxName)) continue;
                if (noIndex) {
                    if (idxToUse.contains(hintIdxName)) {
                        throw new SqlException(ErrorGroups.Sql.STMT_VALIDATION_ERR, "Index '" + hintIdxName + " of table '" + (String)Util.last((List)scan.getTable().getQualifiedName()) + "' has already been forced in other hints.");
                    }
                    idxToSkip.add(hintIdxName);
                    continue;
                }
                if (idxToSkip.contains(hintIdxName)) {
                    throw new SqlException(ErrorGroups.Sql.STMT_VALIDATION_ERR, "Index '" + hintIdxName + "' of table '" + (String)Util.last((List)scan.getTable().getQualifiedName()) + "' has already been disabled in other hints.");
                }
                idxToUse.add(hintIdxName);
            }
        }
        if (!idxToUse.isEmpty()) {
            scan.getCluster().getPlanner().prune((RelNode)scan);
        }
        return indexes.stream().filter(idx -> !idxToSkip.contains(idx.indexName()) && (idxToUse.isEmpty() || idxToUse.contains(idx.indexName()))).collect(Collectors.toList());
    }

    private static boolean filter(IgniteTable table, String idxName, List<SearchBounds> searchBounds) {
        IgniteIndex index = table.indexes().get(idxName);
        return index.type() == IgniteIndex.Type.SORTED || searchBounds != null && searchBounds.stream().noneMatch(bound -> bound.type() == SearchBounds.Type.RANGE);
    }

    @Value.Immutable
    public static interface Config
    extends RelRule.Config {
        public static final Config DEFAULT = ImmutableExposeIndexRule.Config.of().withOperandSupplier(b -> b.operand(IgniteLogicalTableScan.class).predicate(x$0 -> ExposeIndexRule.preMatch(x$0)).anyInputs());

        default public ExposeIndexRule toRule() {
            return new ExposeIndexRule(this);
        }
    }
}

