/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.expression.unary;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.regex.Pattern;
import org.apache.iotdb.db.queryengine.execution.MemoryEstimationHelper;
import org.apache.iotdb.db.queryengine.plan.expression.Expression;
import org.apache.iotdb.db.queryengine.plan.expression.ExpressionType;
import org.apache.iotdb.db.queryengine.plan.expression.unary.UnaryExpression;
import org.apache.iotdb.db.queryengine.plan.expression.visitor.ExpressionVisitor;
import org.apache.tsfile.utils.RamUsageEstimator;
import org.apache.tsfile.utils.ReadWriteIOUtils;
import org.apache.tsfile.utils.RegexUtils;

public class LikeExpression
extends UnaryExpression {
    private static final long INSTANCE_SIZE = RamUsageEstimator.shallowSizeOfInstance(LikeExpression.class);
    private final String patternString;
    private final Pattern pattern;
    private final boolean isNot;

    public LikeExpression(Expression expression, String patternString, boolean isNot) {
        super(expression);
        this.patternString = patternString;
        this.isNot = isNot;
        this.pattern = RegexUtils.compileRegex((String)RegexUtils.parseLikePatternToRegex((String)patternString));
    }

    public LikeExpression(Expression expression, String patternString, Pattern pattern, boolean isNot) {
        super(expression);
        this.patternString = patternString;
        this.pattern = pattern;
        this.isNot = isNot;
    }

    public LikeExpression(ByteBuffer byteBuffer) {
        super(Expression.deserialize(byteBuffer));
        this.patternString = ReadWriteIOUtils.readString((ByteBuffer)byteBuffer);
        this.isNot = ReadWriteIOUtils.readBool((ByteBuffer)byteBuffer);
        this.pattern = RegexUtils.compileRegex((String)RegexUtils.parseLikePatternToRegex((String)this.patternString));
    }

    public String getPatternString() {
        return this.patternString;
    }

    public Pattern getPattern() {
        return this.pattern;
    }

    public boolean isNot() {
        return this.isNot;
    }

    @Override
    protected String getExpressionStringInternal() {
        return this.expression.getExpressionString() + (this.isNot ? " NOT" : "") + " LIKE '" + this.pattern + "'";
    }

    @Override
    public ExpressionType getExpressionType() {
        return ExpressionType.LIKE;
    }

    @Override
    protected void serialize(ByteBuffer byteBuffer) {
        super.serialize(byteBuffer);
        ReadWriteIOUtils.write((String)this.patternString, (ByteBuffer)byteBuffer);
        ReadWriteIOUtils.write((Boolean)this.isNot, (ByteBuffer)byteBuffer);
    }

    @Override
    protected void serialize(DataOutputStream stream) throws IOException {
        super.serialize(stream);
        ReadWriteIOUtils.write((String)this.patternString, (OutputStream)stream);
        ReadWriteIOUtils.write((Boolean)this.isNot, (OutputStream)stream);
    }

    @Override
    public String getOutputSymbolInternal() {
        return this.expression.getOutputSymbol() + (this.isNot ? " NOT" : "") + " LIKE '" + this.pattern + "'";
    }

    @Override
    public <R, C> R accept(ExpressionVisitor<R, C> visitor, C context) {
        return visitor.visitLikeExpression(this, context);
    }

    public long ramBytesUsed() {
        return INSTANCE_SIZE + MemoryEstimationHelper.getEstimatedSizeOfAccountableObject(this.expression) + RamUsageEstimator.sizeOf((String)this.patternString);
    }
}

