/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.persistence.schema;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.commons.io.IOUtils;
import org.apache.iotdb.commons.exception.MetadataException;
import org.apache.iotdb.db.exception.metadata.template.UndefinedTemplateException;
import org.apache.iotdb.db.schemaengine.template.Template;
import org.apache.iotdb.db.schemaengine.template.alter.TemplateExtendInfo;
import org.apache.iotdb.db.utils.EncodingInferenceUtils;
import org.apache.tsfile.common.conf.TSFileDescriptor;
import org.apache.tsfile.enums.TSDataType;
import org.apache.tsfile.file.metadata.enums.CompressionType;
import org.apache.tsfile.file.metadata.enums.TSEncoding;
import org.apache.tsfile.utils.ReadWriteIOUtils;
import org.apache.tsfile.write.schema.IMeasurementSchema;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TemplateTable {
    private static final Logger LOGGER = LoggerFactory.getLogger(TemplateTable.class);
    private final ReentrantReadWriteLock templateReadWriteLock;
    private final AtomicInteger templateIdGenerator;
    private final Map<String, Template> templateMap = new ConcurrentHashMap<String, Template>();
    private final Map<Integer, Template> templateIdMap = new ConcurrentHashMap<Integer, Template>();
    private static final String SNAPSHOT_FILENAME = "template_info.bin";

    public TemplateTable() {
        this.templateReadWriteLock = new ReentrantReadWriteLock();
        this.templateIdGenerator = new AtomicInteger(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Template getTemplate(String name) throws MetadataException {
        this.templateReadWriteLock.readLock().lock();
        try {
            Template template = this.templateMap.get(name);
            if (template == null) {
                throw new MetadataException(String.format("Template %s does not exist", name));
            }
            Template template2 = this.templateMap.get(name);
            return template2;
        }
        finally {
            this.templateReadWriteLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Template getTemplate(int templateId) throws MetadataException {
        this.templateReadWriteLock.readLock().lock();
        try {
            Template template = this.templateIdMap.get(templateId);
            if (template == null) {
                throw new MetadataException(String.format("Template with id=%s does not exist", templateId));
            }
            Template template2 = template;
            return template2;
        }
        finally {
            this.templateReadWriteLock.readLock().unlock();
        }
    }

    public List<Template> getAllTemplate() {
        this.templateReadWriteLock.readLock().lock();
        try {
            ArrayList<Template> arrayList = new ArrayList<Template>(this.templateMap.values());
            return arrayList;
        }
        finally {
            this.templateReadWriteLock.readLock().unlock();
        }
    }

    public void createTemplate(Template template) throws MetadataException {
        this.templateReadWriteLock.writeLock().lock();
        try {
            Template temp = this.templateMap.get(template.getName());
            if (temp != null) {
                LOGGER.error("Failed to create template, because template name {} exists", (Object)template.getName());
                throw new MetadataException("Duplicated template name: " + temp.getName());
            }
            template.setId(this.templateIdGenerator.getAndIncrement());
            this.templateMap.put(template.getName(), template);
            this.templateIdMap.put(template.getId(), template);
        }
        finally {
            this.templateReadWriteLock.writeLock().unlock();
        }
    }

    public void dropTemplate(String templateName) throws MetadataException {
        this.templateReadWriteLock.writeLock().lock();
        try {
            Template temp = this.templateMap.remove(templateName);
            if (temp == null) {
                LOGGER.error("Undefined template {}", (Object)templateName);
                throw new UndefinedTemplateException(templateName);
            }
            this.templateIdMap.remove(temp.getId());
        }
        finally {
            this.templateReadWriteLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void extendTemplate(TemplateExtendInfo templateExtendInfo) throws MetadataException {
        this.templateReadWriteLock.writeLock().lock();
        try {
            Template template = this.templateMap.get(templateExtendInfo.getTemplateName());
            List measurementList = templateExtendInfo.getMeasurements();
            List dataTypeList = templateExtendInfo.getDataTypes();
            List encodingList = templateExtendInfo.getEncodings();
            List compressionTypeList = templateExtendInfo.getCompressors();
            for (int i = 0; i < measurementList.size(); ++i) {
                IMeasurementSchema measurementSchema = template.getSchema((String)measurementList.get(i));
                if (measurementSchema == null) {
                    template.addMeasurement((String)measurementList.get(i), (TSDataType)dataTypeList.get(i), encodingList == null ? EncodingInferenceUtils.getDefaultEncoding((TSDataType)((TSDataType)dataTypeList.get(i))) : (TSEncoding)encodingList.get(i), compressionTypeList == null ? TSFileDescriptor.getInstance().getConfig().getCompressor() : (CompressionType)compressionTypeList.get(i));
                    continue;
                }
                if (measurementSchema.getType().equals(dataTypeList.get(i)) && (encodingList == null || measurementSchema.getEncodingType().equals(encodingList.get(i))) && (compressionTypeList == null || measurementSchema.getCompressor().equals(compressionTypeList.get(i)))) continue;
                throw new MetadataException(String.format("Schema of measurement %s is not compatible with existing measurement in template %s", measurementList.get(i), template.getName()));
            }
        }
        finally {
            this.templateReadWriteLock.writeLock().unlock();
        }
    }

    private void serialize(OutputStream outputStream) throws IOException {
        ReadWriteIOUtils.write((int)this.templateIdGenerator.get(), (OutputStream)outputStream);
        ReadWriteIOUtils.write((int)this.templateMap.size(), (OutputStream)outputStream);
        for (Map.Entry<String, Template> entry : this.templateMap.entrySet()) {
            this.serializeTemplate(entry.getValue(), outputStream);
        }
    }

    private void serializeTemplate(Template template, OutputStream outputStream) {
        try {
            template.serialize(outputStream);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void deserialize(InputStream inputStream) throws IOException {
        ByteBuffer byteBuffer = ByteBuffer.wrap(IOUtils.toByteArray((InputStream)inputStream));
        this.templateIdGenerator.set(ReadWriteIOUtils.readInt((ByteBuffer)byteBuffer));
        for (int size = ReadWriteIOUtils.readInt((ByteBuffer)byteBuffer); size > 0; --size) {
            Template template = this.deserializeTemplate(byteBuffer);
            this.templateMap.put(template.getName(), template);
            this.templateIdMap.put(template.getId(), template);
        }
    }

    private Template deserializeTemplate(ByteBuffer byteBuffer) {
        Template template = new Template();
        template.deserialize(byteBuffer);
        return template;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean processTakeSnapshot(File snapshotDir) throws IOException {
        File snapshotFile = new File(snapshotDir, SNAPSHOT_FILENAME);
        if (snapshotFile.exists() && snapshotFile.isFile()) {
            LOGGER.error("template failed to take snapshot, because snapshot file [{}] is already exist.", (Object)snapshotFile.getAbsolutePath());
            return false;
        }
        File tmpFile = new File(snapshotFile.getAbsolutePath() + "-" + UUID.randomUUID());
        this.templateReadWriteLock.writeLock().lock();
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(tmpFile);
            BufferedOutputStream outputStream = new BufferedOutputStream(fileOutputStream);
            try {
                this.serialize(outputStream);
            }
            finally {
                outputStream.flush();
                fileOutputStream.getFD().sync();
                outputStream.close();
            }
            boolean bl = tmpFile.renameTo(snapshotFile);
            return bl;
        }
        finally {
            for (int retry = 0; retry < 5 && tmpFile.exists() && !tmpFile.delete(); ++retry) {
                LOGGER.warn("Can't delete temporary snapshot file: {}, retrying...", (Object)tmpFile.getAbsolutePath());
            }
            this.templateReadWriteLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processLoadSnapshot(File snapshotDir) throws IOException {
        File snapshotFile = new File(snapshotDir, SNAPSHOT_FILENAME);
        if (!snapshotFile.exists() || !snapshotFile.isFile()) {
            LOGGER.error("Failed to load snapshot,snapshot file [{}] is not exist.", (Object)snapshotFile.getAbsolutePath());
            return;
        }
        this.templateReadWriteLock.writeLock().lock();
        try (FileInputStream fileInputStream = new FileInputStream(snapshotFile);
             BufferedInputStream bufferedInputStream = new BufferedInputStream(fileInputStream);){
            this.templateMap.clear();
            this.deserialize(bufferedInputStream);
            bufferedInputStream.close();
            fileInputStream.close();
        }
        finally {
            this.templateReadWriteLock.writeLock().unlock();
        }
    }

    public void clear() {
        this.templateMap.clear();
    }
}

