/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.execution.fragment;

import com.google.common.collect.ImmutableList;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.tsfile.utils.PublicBAOS;
import org.apache.tsfile.utils.ReadWriteIOUtils;

public class FragmentInstanceFailureInfo
implements Serializable {
    private static final Pattern STACK_TRACE_PATTERN = Pattern.compile("(.*)\\.(.*)\\(([^:]*)(?::(.*))?\\)");
    private final String message;
    private final FragmentInstanceFailureInfo cause;
    private final List<FragmentInstanceFailureInfo> suppressed;
    private final List<String> stack;

    public FragmentInstanceFailureInfo(String message, FragmentInstanceFailureInfo cause, List<FragmentInstanceFailureInfo> suppressed, List<String> stack) {
        Objects.requireNonNull(suppressed, "suppressed is null");
        Objects.requireNonNull(stack, "stack is null");
        this.message = message;
        this.cause = cause;
        this.suppressed = ImmutableList.copyOf(suppressed);
        this.stack = ImmutableList.copyOf(stack);
    }

    public String getMessage() {
        return this.message;
    }

    public FragmentInstanceFailureInfo getCause() {
        return this.cause;
    }

    public List<FragmentInstanceFailureInfo> getSuppressed() {
        return this.suppressed;
    }

    public List<String> getStack() {
        return this.stack;
    }

    public RuntimeException toException() {
        return FragmentInstanceFailureInfo.toException(this);
    }

    private static FailureException toException(FragmentInstanceFailureInfo failureInfo) {
        if (failureInfo == null) {
            return null;
        }
        FailureException failure = new FailureException(failureInfo.getMessage(), FragmentInstanceFailureInfo.toException(failureInfo.getCause()));
        for (FragmentInstanceFailureInfo fragmentInstanceFailureInfo : failureInfo.getSuppressed()) {
            failure.addSuppressed(FragmentInstanceFailureInfo.toException(fragmentInstanceFailureInfo));
        }
        ImmutableList.Builder stackTraceBuilder = ImmutableList.builder();
        for (String stack : failureInfo.getStack()) {
            stackTraceBuilder.add((Object)FragmentInstanceFailureInfo.toStackTraceElement(stack));
        }
        ImmutableList immutableList = stackTraceBuilder.build();
        failure.setStackTrace((StackTraceElement[])immutableList.toArray((Object[])new StackTraceElement[0]));
        return failure;
    }

    public static FragmentInstanceFailureInfo toFragmentInstanceFailureInfo(Throwable throwable) {
        if (throwable == null) {
            return null;
        }
        return new FragmentInstanceFailureInfo(throwable.getMessage(), FragmentInstanceFailureInfo.toFragmentInstanceFailureInfo(throwable.getCause()), Arrays.stream(throwable.getSuppressed()).map(FragmentInstanceFailureInfo::toFragmentInstanceFailureInfo).collect(Collectors.toList()), (List)Arrays.stream(throwable.getStackTrace()).map(Objects::toString).collect(ImmutableList.toImmutableList()));
    }

    public static StackTraceElement toStackTraceElement(String stack) {
        Matcher matcher = STACK_TRACE_PATTERN.matcher(stack);
        if (matcher.matches()) {
            String declaringClass = matcher.group(1);
            String methodName = matcher.group(2);
            String fileName = matcher.group(3);
            int number = -1;
            if (fileName.equals("Native Method")) {
                fileName = null;
                number = -2;
            } else if (matcher.group(4) != null) {
                number = Integer.parseInt(matcher.group(4));
            }
            return new StackTraceElement(declaringClass, methodName, fileName, number);
        }
        return new StackTraceElement("Unknown", stack, null, -1);
    }

    public ByteBuffer serialize() throws IOException {
        PublicBAOS byteArrayOutputStream = new PublicBAOS();
        DataOutputStream outputStream = new DataOutputStream((OutputStream)byteArrayOutputStream);
        this.serialize(outputStream);
        return ByteBuffer.wrap(byteArrayOutputStream.getBuf(), 0, byteArrayOutputStream.size());
    }

    public void serialize(DataOutputStream outputStream) throws IOException {
        ReadWriteIOUtils.write((String)this.message, (OutputStream)outputStream);
        if (this.cause == null) {
            ReadWriteIOUtils.write((int)0, (OutputStream)outputStream);
        } else {
            ReadWriteIOUtils.write((int)1, (OutputStream)outputStream);
            this.cause.serialize(outputStream);
        }
        ReadWriteIOUtils.write((int)this.suppressed.size(), (OutputStream)outputStream);
        for (FragmentInstanceFailureInfo failureInfo : this.suppressed) {
            failureInfo.serialize(outputStream);
        }
        ReadWriteIOUtils.write((int)this.stack.size(), (OutputStream)outputStream);
        for (String s : this.stack) {
            ReadWriteIOUtils.write((String)s, (OutputStream)outputStream);
        }
    }

    public static FragmentInstanceFailureInfo deserialize(ByteBuffer byteBuffer) {
        String message = ReadWriteIOUtils.readString((ByteBuffer)byteBuffer);
        ArrayList<FragmentInstanceFailureInfo> suppressed = new ArrayList<FragmentInstanceFailureInfo>();
        ArrayList<String> stack = new ArrayList<String>();
        int flag = ReadWriteIOUtils.readInt((ByteBuffer)byteBuffer);
        FragmentInstanceFailureInfo cause = flag == 0 ? null : FragmentInstanceFailureInfo.deserialize(byteBuffer);
        int suppressedSize = ReadWriteIOUtils.readInt((ByteBuffer)byteBuffer);
        for (int i = 0; i < suppressedSize; ++i) {
            suppressed.add(FragmentInstanceFailureInfo.deserialize(byteBuffer));
        }
        int stackSize = ReadWriteIOUtils.readInt((ByteBuffer)byteBuffer);
        for (int i = 0; i < stackSize; ++i) {
            stack.add(ReadWriteIOUtils.readString((ByteBuffer)byteBuffer));
        }
        return new FragmentInstanceFailureInfo(message, cause, suppressed, stack);
    }

    public int hashCode() {
        return Objects.hash(this.message, this.cause, this.suppressed, this.stack);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FragmentInstanceFailureInfo that = (FragmentInstanceFailureInfo)o;
        return (this.getMessage() == null ? that.getMessage() == null : this.getMessage().equals(that.getMessage())) && (this.getCause() == null ? that.getCause() == null : this.getCause().equals(that.getCause())) && this.getSuppressed().equals(that.getSuppressed()) && this.getStack().equals(that.getStack());
    }

    private static class FailureException
    extends RuntimeException {
        FailureException(String message, FailureException cause) {
            super(message, cause);
        }
    }
}

