/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.query.lucene;

import java.io.IOException;
import org.apache.jackrabbit.core.HierarchyManager;
import org.apache.jackrabbit.core.id.NodeId;
import org.apache.jackrabbit.core.id.PropertyId;
import org.apache.jackrabbit.core.query.lucene.FieldComparatorBase;
import org.apache.jackrabbit.core.query.lucene.FieldNames;
import org.apache.jackrabbit.core.query.lucene.NamespaceMappings;
import org.apache.jackrabbit.core.query.lucene.SharedFieldCache;
import org.apache.jackrabbit.core.query.lucene.Util;
import org.apache.jackrabbit.core.query.lucene.sort.AbstractFieldComparator;
import org.apache.jackrabbit.core.state.ItemStateManager;
import org.apache.jackrabbit.core.state.PropertyState;
import org.apache.jackrabbit.core.value.InternalValue;
import org.apache.jackrabbit.spi.Path;
import org.apache.jackrabbit.spi.PathFactory;
import org.apache.jackrabbit.spi.commons.conversion.IllegalNameException;
import org.apache.jackrabbit.spi.commons.name.PathBuilder;
import org.apache.jackrabbit.spi.commons.name.PathFactoryImpl;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.FieldComparator;
import org.apache.lucene.search.FieldComparatorSource;

public class SharedFieldComparatorSource
extends FieldComparatorSource {
    private static final long serialVersionUID = -5803240954874585429L;
    private final String field;
    private final ItemStateManager ism;
    private final HierarchyManager hmgr;
    private final NamespaceMappings nsMappings;

    public SharedFieldComparatorSource(String fieldname, ItemStateManager ism, HierarchyManager hmgr, NamespaceMappings nsMappings) {
        this.field = fieldname;
        this.ism = ism;
        this.hmgr = hmgr;
        this.nsMappings = nsMappings;
    }

    public FieldComparator newComparator(String propertyName, int numHits, int sortPos, boolean reversed) throws IOException {
        PathFactory factory = PathFactoryImpl.getInstance();
        Path path = factory.create(propertyName);
        try {
            SimpleFieldComparator simple = new SimpleFieldComparator(this.nsMappings.translatePath(path), this.field, numHits);
            return path.getLength() == 1 ? simple : new CompoundScoreFieldComparator(new FieldComparator[]{simple, new RelPathFieldComparator(path, numHits)}, numHits);
        }
        catch (IllegalNameException e) {
            throw Util.createIOException(e);
        }
    }

    static final class SimpleFieldComparator
    extends AbstractFieldComparator {
        protected SharedFieldCache.ValueIndex[] indexes;
        private final String propertyName;
        private final String fieldName;

        public SimpleFieldComparator(String propertyName, String fieldName, int numHits) {
            super(numHits);
            this.propertyName = propertyName;
            this.fieldName = fieldName;
        }

        @Override
        public void setNextReader(IndexReader reader, int docBase) throws IOException {
            super.setNextReader(reader, docBase);
            this.indexes = new SharedFieldCache.ValueIndex[this.readers.size()];
            String namedValue = FieldNames.createNamedValue(this.propertyName, "");
            for (int i = 0; i < this.readers.size(); ++i) {
                IndexReader r = (IndexReader)this.readers.get(i);
                this.indexes[i] = SharedFieldCache.INSTANCE.getValueIndex(r, this.fieldName, namedValue);
            }
        }

        @Override
        protected Comparable<?> sortValue(int doc) {
            int idx = this.readerIndex(doc);
            return this.indexes[idx].getValue(doc - this.starts[idx]);
        }
    }

    private static final class CompoundScoreFieldComparator
    extends AbstractFieldComparator {
        private final FieldComparator[] fieldComparators;

        public CompoundScoreFieldComparator(FieldComparator[] fieldComparators, int numHits) {
            super(numHits);
            this.fieldComparators = fieldComparators;
        }

        @Override
        public Comparable<?> sortValue(int doc) {
            for (FieldComparator fieldComparator : this.fieldComparators) {
                Comparable<?> c;
                if (!(fieldComparator instanceof FieldComparatorBase) || (c = ((FieldComparatorBase)fieldComparator).sortValue(doc)) == null) continue;
                return c;
            }
            return null;
        }

        @Override
        public void setNextReader(IndexReader reader, int docBase) throws IOException {
            for (FieldComparator fieldComparator : this.fieldComparators) {
                fieldComparator.setNextReader(reader, docBase);
            }
        }
    }

    private final class RelPathFieldComparator
    extends AbstractFieldComparator {
        private final Path propertyName;

        public RelPathFieldComparator(Path propertyName, int numHits) {
            super(numHits);
            this.propertyName = propertyName;
        }

        @Override
        protected Comparable<?> sortValue(int doc) {
            try {
                String uuid = this.getUUIDForIndex(doc);
                Path path = SharedFieldComparatorSource.this.hmgr.getPath(new NodeId(uuid));
                PathBuilder builder = new PathBuilder(path);
                builder.addAll(this.propertyName.getElements());
                PropertyId id = SharedFieldComparatorSource.this.hmgr.resolvePropertyPath(builder.getPath());
                if (id == null) {
                    return null;
                }
                PropertyState state = (PropertyState)SharedFieldComparatorSource.this.ism.getItemState(id);
                if (state == null) {
                    return null;
                }
                InternalValue[] values = state.getValues();
                if (values.length > 0) {
                    return Util.getComparable(values[0]);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return null;
        }
    }
}

