/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mailet.base;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Streams;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import javax.mail.MessagingException;
import org.apache.commons.lang3.StringUtils;
import org.apache.mailet.Mail;
import org.apache.mailet.Mailet;
import org.apache.mailet.MailetConfig;
import org.apache.mailet.MailetContext;
import org.apache.mailet.base.MailetUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class GenericMailet
implements Mailet,
MailetConfig {
    private static final Logger LOGGER = LoggerFactory.getLogger(GenericMailet.class);
    private static final String YES = "yes";
    private static final String NO = "no";
    private static final String TRUE = "true";
    private static final String FALSE = "false";
    private static final String CONFIG_IS_NULL_ERROR_MESSAGE = "Mailet configuration must be set before getInitParameter is called.";
    private static final List<String> ERROR_PARAMETERS = ImmutableList.of("onMailetException", "onMatchException");
    private MailetConfig config = null;

    @Override
    public void destroy() {
    }

    public boolean getInitParameter(String name, boolean defaultValue) {
        Preconditions.checkState(this.config != null, CONFIG_IS_NULL_ERROR_MESSAGE);
        return MailetUtil.getInitParameter(this.config, name).orElse(defaultValue);
    }

    public Optional<String> getInitParameterAsOptional(String name) {
        String value = this.getInitParameter(name);
        if (Strings.isNullOrEmpty(value)) {
            return Optional.empty();
        }
        return Optional.of(value);
    }

    public boolean getBooleanParameter(String value, boolean defaultValue) {
        if (defaultValue) {
            return !GenericMailet.isFalseOrNo(value);
        }
        return GenericMailet.isTrueOrYes(value);
    }

    private static boolean isFalseOrNo(String value) {
        return StringUtils.containsIgnoreCase(value, FALSE) || StringUtils.containsIgnoreCase(value, NO);
    }

    private static boolean isTrueOrYes(String value) {
        return StringUtils.containsIgnoreCase(value, TRUE) || StringUtils.containsIgnoreCase(value, YES);
    }

    @Override
    public String getInitParameter(String name) {
        Preconditions.checkState(this.config != null, CONFIG_IS_NULL_ERROR_MESSAGE);
        return this.config.getInitParameter(name);
    }

    public String getInitParameter(String name, String defValue) {
        Preconditions.checkState(this.config != null, CONFIG_IS_NULL_ERROR_MESSAGE);
        String res = this.config.getInitParameter(name);
        if (res == null) {
            return defValue;
        }
        return res;
    }

    @Override
    public Iterator<String> getInitParameterNames() {
        Preconditions.checkState(this.config != null, CONFIG_IS_NULL_ERROR_MESSAGE);
        return this.config.getInitParameterNames();
    }

    @Override
    public MailetConfig getMailetConfig() {
        return this.config;
    }

    @Override
    public MailetContext getMailetContext() {
        return this.getMailetConfig().getMailetContext();
    }

    @Override
    public String getMailetInfo() {
        return "";
    }

    @Override
    public String getMailetName() {
        Preconditions.checkState(this.config != null, CONFIG_IS_NULL_ERROR_MESSAGE);
        return this.config.getMailetName();
    }

    @Override
    public void init(MailetConfig newConfig) throws MessagingException {
        this.config = newConfig;
        this.init();
    }

    public void init() throws MessagingException {
    }

    @Deprecated
    public void log(String message) {
        LOGGER.info(message);
    }

    @Deprecated
    public void log(String message, Throwable t) {
        LOGGER.error(message, t);
    }

    @Override
    public abstract void service(Mail var1) throws MessagingException;

    protected final void checkInitParameters(Set<String> allowed) throws MessagingException {
        Set bad = Streams.stream(this.getInitParameterNames()).filter(Predicate.not(allowed::contains)).filter(Predicate.not(ERROR_PARAMETERS::contains)).collect(ImmutableSet.toImmutableSet());
        if (!bad.isEmpty()) {
            throw new MessagingException("Unexpected init parameters found: " + bad);
        }
    }
}

