/*
 * Decompiled with CFR 0.152.
 */
package kafka.raft;

import com.typesafe.scalalogging.Logger;
import java.io.File;
import java.io.Serializable;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.util.Optional;
import kafka.log.UnifiedLog;
import kafka.log.UnifiedLog$;
import kafka.raft.KafkaMetadataLog$;
import kafka.raft.KafkaMetadataLog$FullTruncation$;
import kafka.raft.KafkaMetadataLog$UnknownReason$;
import kafka.raft.MetadataLogConfig;
import kafka.raft.SegmentPosition;
import kafka.utils.Logging;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.errors.CorruptRecordException;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.Records;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.raft.Isolation;
import org.apache.kafka.raft.LogFetchInfo;
import org.apache.kafka.raft.LogOffsetMetadata;
import org.apache.kafka.raft.OffsetAndEpoch;
import org.apache.kafka.raft.OffsetMetadata;
import org.apache.kafka.raft.ReplicatedLog;
import org.apache.kafka.raft.ValidOffsetAndEpoch;
import org.apache.kafka.server.common.RequestLocal;
import org.apache.kafka.server.storage.log.FetchIsolation;
import org.apache.kafka.server.util.Scheduler;
import org.apache.kafka.snapshot.FileRawSnapshotReader;
import org.apache.kafka.snapshot.FileRawSnapshotWriter;
import org.apache.kafka.snapshot.NotifyingRawSnapshotWriter;
import org.apache.kafka.snapshot.RawSnapshotReader;
import org.apache.kafka.snapshot.RawSnapshotWriter;
import org.apache.kafka.snapshot.Snapshots;
import org.apache.kafka.storage.internals.log.AppendOrigin;
import org.apache.kafka.storage.internals.log.FetchDataInfo;
import org.apache.kafka.storage.internals.log.LogAppendInfo;
import org.apache.kafka.storage.internals.log.LogStartOffsetIncrementReason;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.Iterator;
import scala.collection.SeqFactory;
import scala.collection.SeqOps;
import scala.collection.StringOps$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.collection.mutable.MapOps;
import scala.collection.mutable.TreeMap;
import scala.collection.mutable.TreeMap$;
import scala.jdk.OptionConverters;
import scala.jdk.OptionConverters$;
import scala.math.Numeric;
import scala.math.Ordering$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LongRef;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005\u0011Ef\u0001\u0002<x\u0005qD!\"a\u000b\u0001\u0005\u000b\u0007I\u0011AA\u0017\u0011)\tI\u0004\u0001B\u0001B\u0003%\u0011q\u0006\u0005\u000b\u0003w\u0001!\u0011!Q\u0001\n\u0005u\u0002BCA&\u0001\t\u0005\t\u0015!\u0003\u0002N!Q\u0011Q\f\u0001\u0003\u0002\u0003\u0006I!a\u0018\t\u0015\u00055\u0005A!A!\u0002\u0013\ty\t\u0003\u0006\u0002\u0018\u0002\u0011\t\u0011)A\u0005\u00033Cq!!)\u0001\t\u0013\t\u0019\u000bC\u0004\u00024\u0002!\t%!.\t\u000f\u0005E\u0007\u0001\"\u0011\u0002T\"9\u0011Q\u001f\u0001\u0005B\u0005]\bbBA\u007f\u0001\u0011%\u0011q \u0005\b\u0005+\u0001A\u0011\tB\f\u0011\u001d\u0011I\u0002\u0001C!\u00057AqAa\b\u0001\t\u0003\u0012\t\u0003C\u0004\u0002@\u0002!\tE!\u000b\t\u000f\t-\u0002\u0001\"\u0011\u0003.!9!\u0011\b\u0001\u0005B\tm\u0002b\u0002B\"\u0001\u0011\u0005#Q\t\u0005\b\u0005\u0013\u0002A\u0011\tB&\u0011\u001d\u0011\t\u0006\u0001C!\u0005CAqAa\u0015\u0001\t\u0003\u0012)\u0006C\u0004\u0002\u000e\u0002!\tEa\u0017\t\u000f\tu\u0003\u0001\"\u0011\u0003`!9!q\r\u0001\u0005B\t%\u0004b\u0002B@\u0001\u0011\u0005#\u0011\u0011\u0005\b\u0005\u000b\u0003A\u0011\tBD\u0011\u001d\u0011\u0019\n\u0001C!\u0005+CqAa&\u0001\t\u0003\u0012I\nC\u0004\u0003\u001e\u0002!\tE!'\t\u000f\t}\u0005\u0001\"\u0011\u0003\"\"9!Q\u0015\u0001\u0005B\t\u001d\u0006b\u0002BS\u0001\u0011%!1\u0016\u0005\b\t[\u0002A\u0011\u0002C8\u0011\u001d!i\b\u0001C\u0005\t\u007fBq\u0001\"\"\u0001\t\u0003\u0012Y\u0004C\u0004\u0005\b\u0002!I\u0001\"#\t\u000f\u0011]\u0005\u0001\"\u0003\u0003<!9A\u0011\u0014\u0001\u0005\n\tm\u0002b\u0002CN\u0001\u0011%AQ\u0014\u0005\b\tG\u0003A\u0011\u0002CS\u0011\u001d!Y\u000b\u0001C!\t[C\u0001\u0002b,\u0001\t\u00039(qC\u0004\b\u0005\u000b<\b\u0012\u0001Bd\r\u00191x\u000f#\u0001\u0003J\"9\u0011\u0011U\u0017\u0005\u0002\tE\u0007b\u0002Bj[\u0011\u0005!Q\u001b\u0005\b\u0005clC\u0011\u0002Bz\u0011\u001d\u001190\fC\u0005\u0005s4\u0011ba\u0006.!\u0003\rJc!\u0007\t\u000f\tE&G\"\u0001\u0004\u001c\u001911\u0011I\u0017G\u0007\u0007B!b!\u00185\u0005+\u0007I\u0011AB0\u0011)\u0019\t\u0007\u000eB\tB\u0003%\u0011\u0011\u0019\u0005\u000b\u0007G\"$Q3A\u0005\u0002\r}\u0003BCB3i\tE\t\u0015!\u0003\u0002B\"Q1q\r\u001b\u0003\u0016\u0004%\taa\u0018\t\u0015\r%DG!E!\u0002\u0013\t\t\rC\u0004\u0002\"R\"\taa\u001b\t\u000f\tEF\u0007\"\u0011\u0004v!I1\u0011\u0010\u001b\u0002\u0002\u0013\u000511\u0010\u0005\n\u0007\u0007#\u0014\u0013!C\u0001\u0007\u000bC\u0011ba'5#\u0003%\ta!\"\t\u0013\ruE'%A\u0005\u0002\r\u0015\u0005\"CBPi\u0005\u0005I\u0011IBQ\u0011%\u00199\u000bNA\u0001\n\u0003\u0019I\u000bC\u0005\u0004,R\n\t\u0011\"\u0001\u0004.\"I1\u0011\u0018\u001b\u0002\u0002\u0013\u000531\u0018\u0005\n\u0007\u000b$\u0014\u0011!C\u0001\u0007\u000fD\u0011ba35\u0003\u0003%\te!4\t\u0013\rEG'!A\u0005B\t]\u0001\"CBji\u0005\u0005I\u0011IBk\u0011%\u00199\u000eNA\u0001\n\u0003\u001aInB\u0005\u0005 5\n\t\u0011#\u0003\u0005\"\u0019I1\u0011I\u0017\u0002\u0002#%A1\u0005\u0005\b\u0003C[E\u0011\u0001C\u001b\u0011%\u0019\u0019nSA\u0001\n\u000b\u001a)\u000eC\u0005\u0003T.\u000b\t\u0011\"!\u00058!IAqH&\u0002\u0002\u0013\u0005E\u0011\t\u0005\n\t\u001fZ\u0015\u0011!C\u0005\t#2aa!8.\r\u000e}\u0007BCBq#\nU\r\u0011\"\u0001\u0004`!Q11])\u0003\u0012\u0003\u0006I!!1\t\u0015\r\u0015\u0018K!f\u0001\n\u0003\u0019y\u0006\u0003\u0006\u0004hF\u0013\t\u0012)A\u0005\u0003\u0003D!b!;R\u0005+\u0007I\u0011AB0\u0011)\u0019Y/\u0015B\tB\u0003%\u0011\u0011\u0019\u0005\b\u0003C\u000bF\u0011ABw\u0011\u001d\u0011\t,\u0015C!\u0007oD\u0011b!\u001fR\u0003\u0003%\taa?\t\u0013\r\r\u0015+%A\u0005\u0002\r\u0015\u0005\"CBN#F\u0005I\u0011ABC\u0011%\u0019i*UI\u0001\n\u0003\u0019)\tC\u0005\u0004 F\u000b\t\u0011\"\u0011\u0004\"\"I1qU)\u0002\u0002\u0013\u00051\u0011\u0016\u0005\n\u0007W\u000b\u0016\u0011!C\u0001\t\u0007A\u0011b!/R\u0003\u0003%\tea/\t\u0013\r\u0015\u0017+!A\u0005\u0002\u0011\u001d\u0001\"CBf#\u0006\u0005I\u0011\tC\u0006\u0011%\u0019\t.UA\u0001\n\u0003\u00129\u0002C\u0005\u0004TF\u000b\t\u0011\"\u0011\u0004V\"I1q[)\u0002\u0002\u0013\u0005CqB\u0004\n\t'j\u0013\u0011!E\u0005\t+2\u0011b!8.\u0003\u0003EI\u0001b\u0016\t\u000f\u0005\u0005\u0006\u000e\"\u0001\u0005\\!I11\u001b5\u0002\u0002\u0013\u00153Q\u001b\u0005\n\u0005'D\u0017\u0011!CA\t;B\u0011\u0002b\u0010i\u0003\u0003%\t\t\"\u001a\t\u0013\u0011=\u0003.!A\u0005\n\u0011Esa\u0002C5[!511\b\u0004\b\u0007ci\u0003RBB\u001a\u0011\u001d\t\tk\u001cC\u0001\u0007sAqA!-p\t\u0003\u001aidB\u0004\u0005l5Bi\u0001\"\u0007\u0007\u000f\u0011MQ\u0006#\u0004\u0005\u0016!9\u0011\u0011U:\u0005\u0002\u0011]\u0001b\u0002BYg\u0012\u0005C1\u0004\u0002\u0011\u0017\u000647.Y'fi\u0006$\u0017\r^1M_\u001eT!\u0001_=\u0002\tI\fg\r\u001e\u0006\u0002u\u0006)1.\u00194lC\u000e\u00011C\u0002\u0001~\u0003\u0017\ty\u0002E\u0002\u007f\u0003\u000fi\u0011a \u0006\u0005\u0003\u0003\t\u0019!\u0001\u0003mC:<'BAA\u0003\u0003\u0011Q\u0017M^1\n\u0007\u0005%qP\u0001\u0004PE*,7\r\u001e\t\u0005\u0003\u001b\tY\"\u0004\u0002\u0002\u0010)\u0019\u00010!\u0005\u000b\u0007i\f\u0019B\u0003\u0003\u0002\u0016\u0005]\u0011AB1qC\u000eDWM\u0003\u0002\u0002\u001a\u0005\u0019qN]4\n\t\u0005u\u0011q\u0002\u0002\u000e%\u0016\u0004H.[2bi\u0016$Gj\\4\u0011\t\u0005\u0005\u0012qE\u0007\u0003\u0003GQ1!!\nz\u0003\u0015)H/\u001b7t\u0013\u0011\tI#a\t\u0003\u000f1{wmZ5oO\u0006\u0019An\\4\u0016\u0005\u0005=\u0002\u0003BA\u0019\u0003ki!!a\r\u000b\u0007\u0005-\u00120\u0003\u0003\u00028\u0005M\"AC+oS\u001aLW\r\u001a'pO\u0006!An\\4!\u0003\u0011!\u0018.\\3\u0011\t\u0005}\u0012qI\u0007\u0003\u0003\u0003RA!!\n\u0002D)!\u0011QIA\t\u0003\u0019\u0019w.\\7p]&!\u0011\u0011JA!\u0005\u0011!\u0016.\\3\u0002\u0013M\u001c\u0007.\u001a3vY\u0016\u0014\b\u0003BA(\u00033j!!!\u0015\u000b\t\u0005M\u0013QK\u0001\u0005kRLGN\u0003\u0003\u0002X\u0005E\u0011AB:feZ,'/\u0003\u0003\u0002\\\u0005E#!C*dQ\u0016$W\u000f\\3s\u0003%\u0019h.\u00199tQ>$8\u000f\u0005\u0005\u0002b\u0005=\u00141OA=\u001b\t\t\u0019G\u0003\u0003\u0002f\u0005\u001d\u0014aB7vi\u0006\u0014G.\u001a\u0006\u0005\u0003S\nY'\u0001\u0006d_2dWm\u0019;j_:T!!!\u001c\u0002\u000bM\u001c\u0017\r\\1\n\t\u0005E\u00141\r\u0002\b)J,W-T1q!\u0011\ti!!\u001e\n\t\u0005]\u0014q\u0002\u0002\u000f\u001f\u001a47/\u001a;B]\u0012,\u0005o\\2i!\u0019\tY(! \u0002\u00026\u0011\u00111N\u0005\u0005\u0003\u007f\nYG\u0001\u0004PaRLwN\u001c\t\u0005\u0003\u0007\u000bI)\u0004\u0002\u0002\u0006*!\u0011qQA\t\u0003!\u0019h.\u00199tQ>$\u0018\u0002BAF\u0003\u000b\u0013QCR5mKJ\u000bwo\u00158baNDw\u000e\u001e*fC\u0012,'/\u0001\bu_BL7\rU1si&$\u0018n\u001c8\u0011\t\u0005E\u00151S\u0007\u0003\u0003\u0007JA!!&\u0002D\tqAk\u001c9jGB\u000b'\u000f^5uS>t\u0017AB2p]\u001aLw\r\u0005\u0003\u0002\u001c\u0006uU\"A<\n\u0007\u0005}uOA\tNKR\fG-\u0019;b\u0019><7i\u001c8gS\u001e\fa\u0001P5oSRtDCDAS\u0003O\u000bI+a+\u0002.\u0006=\u0016\u0011\u0017\t\u0004\u00037\u0003\u0001bBA\u0016\u0011\u0001\u0007\u0011q\u0006\u0005\b\u0003wA\u0001\u0019AA\u001f\u0011\u001d\tY\u0005\u0003a\u0001\u0003\u001bBq!!\u0018\t\u0001\u0004\ty\u0006C\u0004\u0002\u000e\"\u0001\r!a$\t\u000f\u0005]\u0005\u00021\u0001\u0002\u001a\u0006!!/Z1e)\u0019\t9,!0\u0002HB!\u0011QBA]\u0013\u0011\tY,a\u0004\u0003\u00191{wMR3uG\"LeNZ8\t\u000f\u0005}\u0016\u00021\u0001\u0002B\u0006Y1\u000f^1si>3gm]3u!\u0011\tY(a1\n\t\u0005\u0015\u00171\u000e\u0002\u0005\u0019>tw\rC\u0004\u0002J&\u0001\r!a3\u0002\u001bI,\u0017\rZ%t_2\fG/[8o!\u0011\ti!!4\n\t\u0005=\u0017q\u0002\u0002\n\u0013N|G.\u0019;j_:\fa\"\u00199qK:$\u0017i\u001d'fC\u0012,'\u000f\u0006\u0004\u0002V\u0006m\u00171\u001e\t\u0005\u0003\u001b\t9.\u0003\u0003\u0002Z\u0006=!!\u0004'pO\u0006\u0003\b/\u001a8e\u0013:4w\u000eC\u0004\u0002^*\u0001\r!a8\u0002\u000fI,7m\u001c:egB!\u0011\u0011]At\u001b\t\t\u0019O\u0003\u0003\u0002f\u0006\r\u0013A\u0002:fG>\u0014H-\u0003\u0003\u0002j\u0006\r(a\u0002*fG>\u0014Hm\u001d\u0005\b\u0003[T\u0001\u0019AAx\u0003\u0015)\u0007o\\2i!\u0011\tY(!=\n\t\u0005M\u00181\u000e\u0002\u0004\u0013:$\u0018\u0001E1qa\u0016tG-Q:G_2dwn^3s)\u0019\t).!?\u0002|\"9\u0011Q\\\u0006A\u0002\u0005}\u0007bBAw\u0017\u0001\u0007\u0011q^\u0001\u001eQ\u0006tG\r\\3B]\u0012\u001cuN\u001c<feRdunZ!qa\u0016tG-\u00138g_R!\u0011Q\u001bB\u0001\u0011\u001d\u0011\u0019\u0001\u0004a\u0001\u0005\u000b\t!\"\u00199qK:$\u0017J\u001c4p!\u0011\u00119Aa\u0005\u000e\u0005\t%!\u0002BA\u0016\u0005\u0017QAA!\u0004\u0003\u0010\u0005I\u0011N\u001c;fe:\fGn\u001d\u0006\u0005\u0005#\t\t\"A\u0004ti>\u0014\u0018mZ3\n\t\u0005e'\u0011B\u0001\u0011Y\u0006\u001cHOR3uG\",G-\u00129pG\"$\"!a<\u0002#\u0015tGm\u00144gg\u0016$hi\u001c:Fa>\u001c\u0007\u000e\u0006\u0003\u0002t\tu\u0001bBAw\u001d\u0001\u0007\u0011q^\u0001\nK:$wJ\u001a4tKR$\"Aa\t\u0011\t\u00055!QE\u0005\u0005\u0005O\tyAA\tM_\u001e|eMZ:fi6+G/\u00193bi\u0006$\"!!1\u0002\u0015Q\u0014XO\\2bi\u0016$v\u000e\u0006\u0003\u00030\tU\u0002\u0003BA>\u0005cIAAa\r\u0002l\t!QK\\5u\u0011\u001d\u00119$\u0005a\u0001\u0003\u0003\faa\u001c4gg\u0016$\u0018\u0001\u0007;sk:\u001c\u0017\r^3U_2\u000bG/Z:u':\f\u0007o\u001d5piR\u0011!Q\b\t\u0005\u0003w\u0012y$\u0003\u0003\u0003B\u0005-$a\u0002\"p_2,\u0017M\\\u0001\u0016S:LG/[1mSj,G*Z1eKJ,\u0005o\\2i)\u0011\u0011yCa\u0012\t\u000f\u000558\u00031\u0001\u0002p\u0006\u0019R\u000f\u001d3bi\u0016D\u0015n\u001a5XCR,'/\\1sWR!!q\u0006B'\u0011\u001d\u0011y\u0005\u0006a\u0001\u0005G\tab\u001c4gg\u0016$X*\u001a;bI\u0006$\u0018-A\u0007iS\u001eDw+\u0019;fe6\f'o[\u0001\u0006M2,8\u000f\u001b\u000b\u0005\u0005_\u00119\u0006C\u0004\u0003ZY\u0001\rA!\u0010\u0002/\u0019|'oY3GYV\u001c\b.Q2uSZ,7+Z4nK:$HCAAH\u0003\u001d!x\u000e]5d\u0013\u0012$\"A!\u0019\u0011\t\u0005E%1M\u0005\u0005\u0005K\n\u0019E\u0001\u0003Vk&$\u0017!E2sK\u0006$XMT3x':\f\u0007o\u001d5piR!!1\u000eB>!\u0019\u0011iG!\u001d\u0003v5\u0011!q\u000e\u0006\u0005\u0003'\n\u0019!\u0003\u0003\u0003t\t=$\u0001C(qi&|g.\u00197\u0011\t\u0005\r%qO\u0005\u0005\u0005s\n)IA\tSC^\u001cf.\u00199tQ>$xK]5uKJDqA! \u001a\u0001\u0004\t\u0019(\u0001\u0006t]\u0006\u00048\u000f[8u\u0013\u0012\f!d\u0019:fCR,g*Z<T]\u0006\u00048\u000f[8u+:\u001c\u0007.Z2lK\u0012$BAa\u001b\u0003\u0004\"9!Q\u0010\u000eA\u0002\u0005M\u0014\u0001\u0004:fC\u0012\u001cf.\u00199tQ>$H\u0003\u0002BE\u0005#\u0003bA!\u001c\u0003r\t-\u0005\u0003BAB\u0005\u001bKAAa$\u0002\u0006\n\t\"+Y<T]\u0006\u00048\u000f[8u%\u0016\fG-\u001a:\t\u000f\tu4\u00041\u0001\u0002t\u0005qA.\u0019;fgR\u001cf.\u00199tQ>$HC\u0001BE\u0003Aa\u0017\r^3tiNs\u0017\r]:i_RLE\r\u0006\u0002\u0003\u001cB1!Q\u000eB9\u0003g\n!#Z1sY&,7\u000f^*oCB\u001c\bn\u001c;JI\u0006\u0001rN\\*oCB\u001c\bn\u001c;Ge>TXM\u001c\u000b\u0005\u0005_\u0011\u0019\u000bC\u0004\u0003~}\u0001\r!a\u001d\u0002)\u0011,G.\u001a;f\u0005\u00164wN]3T]\u0006\u00048\u000f[8u)\u0011\u0011iD!+\t\u000f\tu\u0004\u00051\u0001\u0002tQ1!Q\bBW\u0005_CqA! \"\u0001\u0004\t\u0019\bC\u0004\u00032\u0006\u0002\rAa-\u0002\rI,\u0017m]8o!\r\u0011)L\r\b\u0004\u0005occ\u0002\u0002B]\u0005\u0007tAAa/\u0003B6\u0011!Q\u0018\u0006\u0004\u0005\u007f[\u0018A\u0002\u001fs_>$h(C\u0001{\u0013\tA\u00180\u0001\tLC\u001a\\\u0017-T3uC\u0012\fG/\u0019'pOB\u0019\u00111T\u0017\u0014\u000b5\u0012Y-a\b\u0011\t\u0005m$QZ\u0005\u0005\u0005\u001f\fYG\u0001\u0004B]f\u0014VM\u001a\u000b\u0003\u0005\u000f\fQ!\u00199qYf$b\"!*\u0003X\ne'1\u001cBv\u0005[\u0014y\u000fC\u0004\u0002\u000e>\u0002\r!a$\t\u000f\tus\u00061\u0001\u0003b!9!Q\\\u0018A\u0002\t}\u0017a\u00023bi\u0006$\u0015N\u001d\t\u0005\u0005C\u00149/\u0004\u0002\u0003d*!!Q]A\u0002\u0003\tIw.\u0003\u0003\u0003j\n\r(\u0001\u0002$jY\u0016Dq!a\u000f0\u0001\u0004\ti\u0004C\u0004\u0002L=\u0002\r!!\u0014\t\u000f\u0005]u\u00061\u0001\u0002\u001a\u0006\u0001\"/Z2pm\u0016\u00148K\\1qg\"|Go\u001d\u000b\u0005\u0003?\u0012)\u0010C\u0004\u0002,A\u0002\r!a\f\u0002'\u0011,G.\u001a;f':\f\u0007o\u001d5pi\u001aKG.Z:\u0015\u0011\t=\"1`B\b\u0007'AqA!@2\u0001\u0004\u0011y0\u0001\u0004m_\u001e$\u0015N\u001d\t\u0005\u0007\u0003\u0019Y!\u0004\u0002\u0004\u0004)!1QAB\u0004\u0003\u00111\u0017\u000e\\3\u000b\t\r%\u00111A\u0001\u0004]&|\u0017\u0002BB\u0007\u0007\u0007\u0011A\u0001U1uQ\"91\u0011C\u0019A\u0002\u0005}\u0013\u0001E3ya&\u0014X\rZ*oCB\u001c\bn\u001c;t\u0011\u001d\u0019)\"\ra\u0001\u0003?\tq\u0001\\8hO&twM\u0001\fT]\u0006\u00048\u000f[8u\t\u0016dW\r^5p]J+\u0017m]8o'\r\u0011$1\u001a\u000b\u0005\u0007;\u0019i\u0003\u0005\u0003\u0004 \r\u001db\u0002BB\u0011\u0007G\u0001BAa/\u0002l%!1QEA6\u0003\u0019\u0001&/\u001a3fM&!1\u0011FB\u0016\u0005\u0019\u0019FO]5oO*!1QEA6\u0011\u001d\u0011ih\ra\u0001\u0003gJSAM85#N\u0014aBR;mYR\u0013XO\\2bi&|gnE\u0003p\u0005\u0017\u001c)\u0004E\u0002\u00048Ij\u0011!\f\u000b\u0003\u0007w\u00012aa\u000ep)\u0011\u0019iba\u0010\t\u000f\tu\u0014\u000f1\u0001\u0002t\t\t\"+\u001a;f]RLwN\\'t\u0005J,\u0017m\u00195\u0014\u0013Q\u0012Ym!\u000e\u0004F\r-\u0003\u0003BA>\u0007\u000fJAa!\u0013\u0002l\t9\u0001K]8ek\u000e$\b\u0003BB'\u0007/rAaa\u0014\u0004T9!!1XB)\u0013\t\ti'\u0003\u0003\u0004V\u0005-\u0014a\u00029bG.\fw-Z\u0005\u0005\u00073\u001aYF\u0001\u0007TKJL\u0017\r\\5{C\ndWM\u0003\u0003\u0004V\u0005-\u0014a\u00018poV\u0011\u0011\u0011Y\u0001\u0005]><\b%A\u0005uS6,7\u000f^1na\u0006QA/[7fgR\fW\u000e\u001d\u0011\u0002\u001fI,G/\u001a8uS>tW*\u001b7mSN\f\u0001C]3uK:$\u0018n\u001c8NS2d\u0017n\u001d\u0011\u0015\u0011\r54qNB9\u0007g\u00022aa\u000e5\u0011\u001d\u0019if\u000fa\u0001\u0003\u0003Dqaa\u0019<\u0001\u0004\t\t\rC\u0004\u0004hm\u0002\r!!1\u0015\t\ru1q\u000f\u0005\b\u0005{b\u0004\u0019AA:\u0003\u0011\u0019w\u000e]=\u0015\u0011\r54QPB@\u0007\u0003C\u0011b!\u0018>!\u0003\u0005\r!!1\t\u0013\r\rT\b%AA\u0002\u0005\u0005\u0007\"CB4{A\u0005\t\u0019AAa\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIE*\"aa\"+\t\u0005\u00057\u0011R\u0016\u0003\u0007\u0017\u0003Ba!$\u0004\u00186\u00111q\u0012\u0006\u0005\u0007#\u001b\u0019*A\u0005v]\u000eDWmY6fI*!1QSA6\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u00073\u001byIA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\fabY8qs\u0012\"WMZ1vYR$#'\u0001\bd_BLH\u0005Z3gCVdG\u000fJ\u001a\u0002\u001bA\u0014x\u000eZ;diB\u0013XMZ5y+\t\u0019\u0019\u000bE\u0002\u007f\u0007KK1a!\u000b\u0000\u00031\u0001(o\u001c3vGR\f%/\u001b;z+\t\ty/\u0001\bqe>$Wo\u0019;FY\u0016lWM\u001c;\u0015\t\r=6Q\u0017\t\u0005\u0003w\u001a\t,\u0003\u0003\u00044\u0006-$aA!os\"I1qW\"\u0002\u0002\u0003\u0007\u0011q^\u0001\u0004q\u0012\n\u0014a\u00049s_\u0012,8\r^%uKJ\fGo\u001c:\u0016\u0005\ru\u0006CBB`\u0007\u0003\u001cy+\u0004\u0002\u0002h%!11YA4\u0005!IE/\u001a:bi>\u0014\u0018\u0001C2b]\u0016\u000bX/\u00197\u0015\t\tu2\u0011\u001a\u0005\n\u0007o+\u0015\u0011!a\u0001\u0007_\u000b!\u0003\u001d:pIV\u001cG/\u00127f[\u0016tGOT1nKR!11UBh\u0011%\u00199LRA\u0001\u0002\u0004\ty/\u0001\u0005iCND7i\u001c3f\u0003!!xn\u0015;sS:<GCABR\u0003\u0019)\u0017/^1mgR!!QHBn\u0011%\u00199,SA\u0001\u0002\u0004\u0019yKA\nSKR,g\u000e^5p]NK'0\u001a\"sK\u0006\u001c\u0007nE\u0005R\u0005\u0017\u001c)d!\u0012\u0004L\u00059An\\4TSj,\u0017\u0001\u00037pONK'0\u001a\u0011\u0002\u001bMt\u0017\r]:i_R\u001c8+\u001b>f\u00039\u0019h.\u00199tQ>$8oU5{K\u0002\n\u0011C]3uK:$\u0018n\u001c8NCb\u0014\u0015\u0010^3t\u0003I\u0011X\r^3oi&|g.T1y\u0005f$Xm\u001d\u0011\u0015\u0011\r=8\u0011_Bz\u0007k\u00042aa\u000eR\u0011\u001d\u0019\t\u000f\u0017a\u0001\u0003\u0003Dqa!:Y\u0001\u0004\t\t\rC\u0004\u0004jb\u0003\r!!1\u0015\t\ru1\u0011 \u0005\b\u0005{J\u0006\u0019AA:)!\u0019yo!@\u0004\u0000\u0012\u0005\u0001\"CBq5B\u0005\t\u0019AAa\u0011%\u0019)O\u0017I\u0001\u0002\u0004\t\t\rC\u0005\u0004jj\u0003\n\u00111\u0001\u0002BR!1q\u0016C\u0003\u0011%\u00199\fYA\u0001\u0002\u0004\ty\u000f\u0006\u0003\u0003>\u0011%\u0001\"CB\\E\u0006\u0005\t\u0019ABX)\u0011\u0019\u0019\u000b\"\u0004\t\u0013\r]6-!AA\u0002\u0005=H\u0003\u0002B\u001f\t#A\u0011ba.g\u0003\u0003\u0005\raa,\u0003\u001bUs7N\\8x]J+\u0017m]8o'\u0015\u0019(1ZB\u001b)\t!I\u0002E\u0002\u00048M$Ba!\b\u0005\u001e!9!QP;A\u0002\u0005M\u0014!\u0005*fi\u0016tG/[8o\u001bN\u0014%/Z1dQB\u00191qG&\u0014\u000b-#)\u0003\"\r\u0011\u0019\u0011\u001dBQFAa\u0003\u0003\f\tm!\u001c\u000e\u0005\u0011%\"\u0002\u0002C\u0016\u0003W\nqA];oi&lW-\u0003\u0003\u00050\u0011%\"!E!cgR\u0014\u0018m\u0019;Gk:\u001cG/[8ogA!!\u0011\u001dC\u001a\u0013\u0011\u0019IFa9\u0015\u0005\u0011\u0005B\u0003CB7\ts!Y\u0004\"\u0010\t\u000f\ruc\n1\u0001\u0002B\"911\r(A\u0002\u0005\u0005\u0007bBB4\u001d\u0002\u0007\u0011\u0011Y\u0001\bk:\f\u0007\u000f\u001d7z)\u0011!\u0019\u0005b\u0013\u0011\r\u0005m\u0014Q\u0010C#!)\tY\bb\u0012\u0002B\u0006\u0005\u0017\u0011Y\u0005\u0005\t\u0013\nYG\u0001\u0004UkBdWm\r\u0005\n\t\u001bz\u0015\u0011!a\u0001\u0007[\n1\u0001\u001f\u00131\u000319(/\u001b;f%\u0016\u0004H.Y2f)\u0005i\u0018a\u0005*fi\u0016tG/[8o'&TXM\u0011:fC\u000eD\u0007cAB\u001cQN)\u0001\u000e\"\u0017\u00052AaAq\u0005C\u0017\u0003\u0003\f\t-!1\u0004pR\u0011AQ\u000b\u000b\t\u0007_$y\u0006\"\u0019\u0005d!91\u0011]6A\u0002\u0005\u0005\u0007bBBsW\u0002\u0007\u0011\u0011\u0019\u0005\b\u0007S\\\u0007\u0019AAa)\u0011!\u0019\u0005b\u001a\t\u0013\u00115C.!AA\u0002\r=\u0018A\u0004$vY2$&/\u001e8dCRLwN\\\u0001\u000e+:\\gn\\<o%\u0016\f7o\u001c8\u0002#1|\u0017\rZ*oCB\u001c\bn\u001c;TSj,7\u000f\u0006\u0002\u0005rA11Q\nC:\toJA\u0001\"\u001e\u0004\\\t\u00191+Z9\u0011\u0011\u0005mD\u0011PA:\u0003\u0003LA\u0001b\u001f\u0002l\t1A+\u001e9mKJ\nQC]3bINs\u0017\r]:i_R$\u0016.\\3ti\u0006l\u0007\u000f\u0006\u0003\u0005\u0002\u0012\r\u0005CBA>\u0003{\n\t\rC\u0004\u0003~\r\u0002\r!a\u001d\u0002\u00155\f\u0017PY3DY\u0016\fg.\u0001\bdY\u0016\fgn\u00158baNDw\u000e^:\u0015\t\tuB1\u0012\u0005\b\t\u001b+\u0003\u0019\u0001CH\u0003%\u0001(/\u001a3jG\u0006$X\r\u0005\u0005\u0002|\u0011E\u00151\u000fCK\u0013\u0011!\u0019*a\u001b\u0003\u0013\u0019+hn\u0019;j_:\f\u0004CBA>\u0003{\u0012\u0019,A\rdY\u0016\fgn\u00158baNDw\u000e^:SKR,g\u000e^5p]6\u001b\u0018aG2mK\u0006t7K\\1qg\"|Go\u001d*fi\u0016tG/[8o'&TX-A\u000bg_J<W\r^*oCB\u001c\bn\u001c;t\u0005\u00164wN]3\u0015\t\u0005}Cq\u0014\u0005\b\tCC\u0003\u0019AA:\u0003IawnZ*uCJ$8K\\1qg\"|G/\u00133\u0002\u001fI,Wn\u001c<f':\f\u0007o\u001d5piN$bAa\f\u0005(\u0012%\u0006bBB\tS\u0001\u0007\u0011q\f\u0005\b\u0005cK\u0003\u0019\u0001BZ\u0003\u0015\u0019Gn\\:f)\t\u0011y#A\u0007t]\u0006\u00048\u000f[8u\u0007>,h\u000e\u001e")
public final class KafkaMetadataLog
implements ReplicatedLog,
Logging {
    private final UnifiedLog log;
    private final Time time;
    private final Scheduler scheduler;
    private final TreeMap<OffsetAndEpoch, Option<FileRawSnapshotReader>> snapshots;
    private final TopicPartition topicPartition;
    private final MetadataLogConfig config;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    public static KafkaMetadataLog apply(TopicPartition topicPartition, Uuid topicId, File dataDir, Time time, Scheduler scheduler, MetadataLogConfig config) {
        return KafkaMetadataLog$.MODULE$.apply(topicPartition, topicId, dataDir, time, scheduler, config);
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    public ValidOffsetAndEpoch validateOffsetAndEpoch(long x$1, int x$2) {
        return super.validateOffsetAndEpoch(x$1, x$2);
    }

    public long truncateToEndOffset(OffsetAndEpoch x$1) {
        return super.truncateToEndOffset(x$1);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public UnifiedLog log() {
        return this.log;
    }

    public LogFetchInfo read(long startOffset, Isolation readIsolation) {
        FetchIsolation fetchIsolation;
        if (Isolation.COMMITTED.equals(readIsolation)) {
            fetchIsolation = FetchIsolation.HIGH_WATERMARK;
        } else if (Isolation.UNCOMMITTED.equals(readIsolation)) {
            fetchIsolation = FetchIsolation.LOG_END;
        } else {
            throw new IllegalArgumentException("Unhandled read isolation " + readIsolation);
        }
        FetchIsolation isolation = fetchIsolation;
        FetchDataInfo fetchInfo = this.log().read(startOffset, this.config.maxFetchSizeInBytes(), isolation, true);
        return new LogFetchInfo(fetchInfo.records, new LogOffsetMetadata(fetchInfo.fetchOffsetMetadata.messageOffset, Optional.of(new SegmentPosition(fetchInfo.fetchOffsetMetadata.segmentBaseOffset, fetchInfo.fetchOffsetMetadata.relativePositionInSegment))));
    }

    public org.apache.kafka.raft.LogAppendInfo appendAsLeader(Records records, int epoch) {
        if (records.sizeInBytes() == 0) {
            throw new IllegalArgumentException("Attempt to append an empty record set");
        }
        return this.handleAndConvertLogAppendInfo(this.log().appendAsLeader((MemoryRecords)records, epoch, AppendOrigin.RAFT_LEADER, RequestLocal.noCaching(), this.log().appendAsLeader$default$5()));
    }

    public org.apache.kafka.raft.LogAppendInfo appendAsFollower(Records records, int epoch) {
        if (records.sizeInBytes() == 0) {
            throw new IllegalArgumentException("Attempt to append an empty record set");
        }
        return this.handleAndConvertLogAppendInfo(this.log().appendAsFollower((MemoryRecords)records, epoch));
    }

    private org.apache.kafka.raft.LogAppendInfo handleAndConvertLogAppendInfo(LogAppendInfo appendInfo) {
        if (appendInfo.firstOffset() == UnifiedLog$.MODULE$.UnknownOffset()) {
            throw new CorruptRecordException("Append failed unexpectedly " + appendInfo);
        }
        return new org.apache.kafka.raft.LogAppendInfo(appendInfo.firstOffset(), appendInfo.lastOffset());
    }

    public int lastFetchedEpoch() {
        return BoxesRunTime.unboxToInt((Object)this.log().latestEpoch().getOrElse((Function0)(JFunction0.mcI.sp & Serializable)() -> BoxesRunTime.unboxToInt((Object)this.latestSnapshotId().map(snapshotId -> BoxesRunTime.boxToInteger((int)KafkaMetadataLog.$anonfun$lastFetchedEpoch$2(this, snapshotId))).orElse(BoxesRunTime.boxToInteger((int)0)))));
    }

    public OffsetAndEpoch endOffsetForEpoch(int epoch) {
        Option option = OptionConverters.RichOptional$.MODULE$.toScala$extension(OptionConverters$.MODULE$.RichOptional(this.earliestSnapshotId()));
        Option<org.apache.kafka.server.common.OffsetAndEpoch> option2 = this.log().endOffsetForEpoch(epoch);
        Tuple2 tuple2 = new Tuple2(option2, (Object)option);
        if (option2 instanceof Some) {
            org.apache.kafka.server.common.OffsetAndEpoch offsetAndEpoch = (org.apache.kafka.server.common.OffsetAndEpoch)((Some)option2).value();
            if (option instanceof Some) {
                OffsetAndEpoch snapshotId = (OffsetAndEpoch)((Some)option).value();
                if (offsetAndEpoch.offset() == snapshotId.offset() && offsetAndEpoch.leaderEpoch() == epoch) {
                    return new OffsetAndEpoch(snapshotId.offset(), snapshotId.epoch());
                }
            }
        }
        if (option2 instanceof Some) {
            org.apache.kafka.server.common.OffsetAndEpoch offsetAndEpoch = (org.apache.kafka.server.common.OffsetAndEpoch)((Some)option2).value();
            return new OffsetAndEpoch(offsetAndEpoch.offset(), offsetAndEpoch.leaderEpoch());
        }
        if (None$.MODULE$.equals(option2)) {
            return new OffsetAndEpoch(this.endOffset().offset(), this.lastFetchedEpoch());
        }
        throw new MatchError((Object)tuple2);
    }

    public LogOffsetMetadata endOffset() {
        org.apache.kafka.storage.internals.log.LogOffsetMetadata endOffsetMetadata = this.log().logEndOffsetMetadata();
        return new LogOffsetMetadata(endOffsetMetadata.messageOffset, Optional.of(new SegmentPosition(endOffsetMetadata.segmentBaseOffset, endOffsetMetadata.relativePositionInSegment)));
    }

    public long startOffset() {
        return this.log().logStartOffset();
    }

    public void truncateTo(long offset) {
        if (offset < this.highWatermark().offset()) {
            throw new IllegalArgumentException("Attempt to truncate to offset " + offset + ", which is below the current high watermark " + this.highWatermark().offset());
        }
        this.log().truncateTo(offset);
    }

    /*
     * WARNING - void declaration
     */
    public boolean truncateToLatestSnapshot() {
        void var5_8;
        TreeMap<OffsetAndEpoch, Option<FileRawSnapshotReader>> treeMap;
        boolean bl;
        OffsetAndEpoch snapshotId;
        int latestEpoch = BoxesRunTime.unboxToInt((Object)this.log().latestEpoch().getOrElse((Function0)(JFunction0.mcI.sp & Serializable)() -> 0));
        Option option = OptionConverters.RichOptional$.MODULE$.toScala$extension(OptionConverters$.MODULE$.RichOptional(this.latestSnapshotId()));
        if (option instanceof Some && ((snapshotId = (OffsetAndEpoch)((Some)option).value()).epoch() > latestEpoch || snapshotId.epoch() == latestEpoch && snapshotId.offset() > this.endOffset().offset())) {
            this.log().truncateFullyAndStartAt(snapshotId.offset(), this.log().truncateFullyAndStartAt$default$2());
            TreeMap<OffsetAndEpoch, Option<FileRawSnapshotReader>> treeMap2 = this.snapshots;
            synchronized (treeMap2) {
                TreeMap<OffsetAndEpoch, Option<FileRawSnapshotReader>> treeMap3 = this.forgetSnapshotsBefore(snapshotId);
                boolean bl2 = true;
                // MONITOREXIT @DISABLED, blocks:[0, 1, 4] lbl10 : MonitorExitStatement: MONITOREXIT : var4_4
                bl = bl2;
                treeMap = treeMap3;
            }
        } else {
            bl = false;
            treeMap = TreeMap$.MODULE$.empty(Ordering$.MODULE$.ordered(Predef$.MODULE$.$conforms()));
        }
        TreeMap<OffsetAndEpoch, Option<FileRawSnapshotReader>> treeMap4 = treeMap;
        boolean truncated = bl;
        this.removeSnapshots(treeMap4, KafkaMetadataLog$FullTruncation$.MODULE$);
        return (boolean)var5_8;
    }

    public void initializeLeaderEpoch(int epoch) {
        this.log().assignEpochStartOffset(epoch, this.log().logEndOffset());
    }

    public void updateHighWatermark(LogOffsetMetadata offsetMetadata) {
        long logHighWatermark;
        OffsetMetadata segmentPosition;
        Option option = OptionConverters.RichOptional$.MODULE$.toScala$extension(OptionConverters$.MODULE$.RichOptional(offsetMetadata.metadata()));
        if (option instanceof Some && (segmentPosition = (OffsetMetadata)((Some)option).value()) instanceof SegmentPosition) {
            SegmentPosition segmentPosition2 = (SegmentPosition)segmentPosition;
            v0 = this.log().updateHighWatermark(new org.apache.kafka.storage.internals.log.LogOffsetMetadata(offsetMetadata.offset(), segmentPosition2.baseOffset(), segmentPosition2.relativePosition()));
        } else {
            v0 = logHighWatermark = this.log().updateHighWatermark(offsetMetadata.offset());
        }
        if (logHighWatermark != offsetMetadata.offset()) {
            if (this.logger().underlying().isWarnEnabled()) {
                String msgWithLogIdent_msg = KafkaMetadataLog.$anonfun$updateHighWatermark$1(logHighWatermark, offsetMetadata);
                Object var7_6 = null;
                this.logger().underlying().warn(Logging.msgWithLogIdent$(this, msgWithLogIdent_msg));
                return;
            }
            return;
        }
    }

    public LogOffsetMetadata highWatermark() {
        org.apache.kafka.storage.internals.log.LogOffsetMetadata hwm = this.log().fetchOffsetSnapshot().highWatermark;
        Optional segmentPosition = !hwm.messageOffsetOnly() ? Optional.of(new SegmentPosition(hwm.segmentBaseOffset, hwm.relativePositionInSegment)) : Optional.empty();
        return new LogOffsetMetadata(hwm.messageOffset, segmentPosition);
    }

    public void flush(boolean forceFlushActiveSegment) {
        this.log().flush(forceFlushActiveSegment);
    }

    public TopicPartition topicPartition() {
        return this.topicPartition;
    }

    public Uuid topicId() {
        return (Uuid)this.log().topicId().get();
    }

    public Optional<RawSnapshotWriter> createNewSnapshot(OffsetAndEpoch snapshotId) {
        if (snapshotId.offset() < this.startOffset()) {
            if (this.logger().underlying().isInfoEnabled()) {
                String msgWithLogIdent_msg = KafkaMetadataLog.$anonfun$createNewSnapshot$1(this, snapshotId);
                Object var8_2 = null;
                this.logger().underlying().info(Logging.msgWithLogIdent$(this, msgWithLogIdent_msg));
            }
            return Optional.empty();
        }
        long highWatermarkOffset = this.highWatermark().offset();
        if (snapshotId.offset() > highWatermarkOffset) {
            throw new IllegalArgumentException("Cannot create a snapshot with an id (" + snapshotId + ") greater than the high-watermark (" + highWatermarkOffset + ")");
        }
        ValidOffsetAndEpoch validOffsetAndEpoch = this.validateOffsetAndEpoch(snapshotId.offset(), snapshotId.epoch());
        ValidOffsetAndEpoch.Kind kind = validOffsetAndEpoch.kind();
        ValidOffsetAndEpoch.Kind kind2 = ValidOffsetAndEpoch.Kind.VALID;
        if (kind == null ? kind2 != null : !kind.equals(kind2)) {
            throw new IllegalArgumentException("Snapshot id (" + snapshotId + ") is not valid according to the log: " + validOffsetAndEpoch);
        }
        long baseOffset = this.read((long)snapshotId.offset(), (Isolation)Isolation.COMMITTED).startOffsetMetadata.offset();
        if (snapshotId.offset() != baseOffset) {
            throw new IllegalArgumentException("Cannot create snapshot at offset (" + snapshotId.offset() + ") because it is not batch aligned. The batch containing the requested offset has a base offset of (" + baseOffset + ")");
        }
        return this.createNewSnapshotUnchecked(snapshotId);
    }

    public Optional<RawSnapshotWriter> createNewSnapshotUnchecked(OffsetAndEpoch snapshotId2) {
        boolean bl;
        TreeMap<OffsetAndEpoch, Option<FileRawSnapshotReader>> treeMap = this.snapshots;
        synchronized (treeMap) {
            bl = this.snapshots.contains((Object)snapshotId2);
        }
        if (bl) {
            return Optional.empty();
        }
        return Optional.of(new NotifyingRawSnapshotWriter((RawSnapshotWriter)FileRawSnapshotWriter.create((Path)this.log().dir().toPath(), (OffsetAndEpoch)snapshotId2), snapshotId -> this.onSnapshotFrozen((OffsetAndEpoch)snapshotId)));
    }

    /*
     * Unable to fully structure code
     */
    public Optional<RawSnapshotReader> readSnapshot(OffsetAndEpoch snapshotId) {
        var2_2 = this.snapshots;
        synchronized (var2_2) {
            block8: {
                block7: {
                    var5_3 = false;
                    var6_4 = null;
                    var7_5 = this.snapshots.get((Object)snapshotId);
                    if (!None$.MODULE$.equals(var7_5)) break block7;
                    v0 = None$.MODULE$;
                    break block8;
                }
                if (!(var7_5 instanceof Some)) ** GOTO lbl-1000
                var5_3 = true;
                var6_4 = (Some)var7_5;
                var8_6 = (Option)var6_4.value();
                if (None$.MODULE$.equals(var8_6)) {
                    v0 = this.liftedTree1$1(snapshotId);
                } else if (var5_3) {
                    v0 = (Option)var6_4.value();
                } else {
                    throw new MatchError((Object)var7_5);
                }
            }
            reader = v0;
            var3_8 = OptionConverters.RichOption$.MODULE$.toJava$extension(OptionConverters$.MODULE$.RichOption((Option)reader));
            return var3_8;
        }
    }

    public Optional<RawSnapshotReader> latestSnapshot() {
        TreeMap<OffsetAndEpoch, Option<FileRawSnapshotReader>> treeMap = this.snapshots;
        synchronized (treeMap) {
            Optional<RawSnapshotReader> optional = this.latestSnapshotId().flatMap(snapshotId -> this.readSnapshot((OffsetAndEpoch)snapshotId));
            return optional;
        }
    }

    public Optional<OffsetAndEpoch> latestSnapshotId() {
        TreeMap<OffsetAndEpoch, Option<FileRawSnapshotReader>> treeMap = this.snapshots;
        synchronized (treeMap) {
            Optional optional = OptionConverters.RichOption$.MODULE$.toJava$extension(OptionConverters$.MODULE$.RichOption(this.snapshots.lastOption().map((Function1 & Serializable)x0$1 -> {
                if (x0$1 != null) {
                    return (OffsetAndEpoch)x0$1._1();
                }
                throw new MatchError(null);
            })));
            return optional;
        }
    }

    public Optional<OffsetAndEpoch> earliestSnapshotId() {
        TreeMap<OffsetAndEpoch, Option<FileRawSnapshotReader>> treeMap = this.snapshots;
        synchronized (treeMap) {
            Optional optional = OptionConverters.RichOption$.MODULE$.toJava$extension(OptionConverters$.MODULE$.RichOption(this.snapshots.headOption().map((Function1 & Serializable)x0$1 -> {
                if (x0$1 != null) {
                    return (OffsetAndEpoch)x0$1._1();
                }
                throw new MatchError(null);
            })));
            return optional;
        }
    }

    public void onSnapshotFrozen(OffsetAndEpoch snapshotId) {
        TreeMap<OffsetAndEpoch, Option<FileRawSnapshotReader>> treeMap = this.snapshots;
        synchronized (treeMap) {
            this.snapshots.put((Object)snapshotId, (Object)None$.MODULE$);
            return;
        }
    }

    public boolean deleteBeforeSnapshot(OffsetAndEpoch snapshotId) {
        return this.deleteBeforeSnapshot(snapshotId, KafkaMetadataLog$UnknownReason$.MODULE$);
    }

    /*
     * Unable to fully structure code
     */
    private boolean deleteBeforeSnapshot(OffsetAndEpoch snapshotId, SnapshotDeletionReason reason) {
        var3_3 = this.snapshots;
        synchronized (var3_3) {
            var4_4 = OptionConverters.RichOptional$.MODULE$.toScala$extension(OptionConverters$.MODULE$.RichOptional(this.latestSnapshotId()));
            if (!(var4_4 instanceof Some)) ** GOTO lbl-1000
            latestSnapshotId = (OffsetAndEpoch)((Some)var4_4).value();
            if (this.snapshots.contains((Object)snapshotId) && this.startOffset() < snapshotId.offset() && snapshotId.offset() <= latestSnapshotId.offset() && this.log().maybeIncrementLogStartOffset(snapshotId.offset(), LogStartOffsetIncrementReason.SnapshotGenerated)) {
                deletedSegments = this.log().deleteOldSegments();
                forgottenSnapshots = this.forgetSnapshotsBefore(snapshotId);
                v0 = deletedSegments != 0 || forgottenSnapshots.nonEmpty() != false;
                v1 = forgottenSnapshots;
            } else lbl-1000:
            // 2 sources

            {
                v0 = false;
                v1 = TreeMap$.MODULE$.empty(Ordering$.MODULE$.ordered(Predef$.MODULE$.$conforms()));
            }
            var9_8 = v1;
            var8_9 = v0;
        }
        this.removeSnapshots(var9_8, reason);
        return var8_9;
    }

    private Seq<Tuple2<OffsetAndEpoch, Object>> loadSnapshotSizes() {
        return (Seq)this.snapshots.keys().toSeq().flatMap((Function1 & Serializable)snapshotId -> OptionConverters.RichOptional$.MODULE$.toScala$extension(OptionConverters$.MODULE$.RichOptional(this.readSnapshot((OffsetAndEpoch)snapshotId))).map((Function1 & Serializable)reader -> new Tuple2(snapshotId, (Object)BoxesRunTime.boxToLong((long)reader.sizeInBytes()))));
    }

    private Option<Object> readSnapshotTimestamp(OffsetAndEpoch snapshotId) {
        return OptionConverters.RichOptional$.MODULE$.toScala$extension(OptionConverters$.MODULE$.RichOptional(this.readSnapshot(snapshotId))).map((Function1 & Serializable)reader -> BoxesRunTime.boxToLong((long)KafkaMetadataLog.$anonfun$readSnapshotTimestamp$1(reader)));
    }

    public boolean maybeClean() {
        TreeMap<OffsetAndEpoch, Option<FileRawSnapshotReader>> treeMap = this.snapshots;
        synchronized (treeMap) {
            boolean didClean = false;
            boolean bl = (didClean |= this.cleanSnapshotsRetentionSize()) | this.cleanSnapshotsRetentionMs();
            return bl;
        }
    }

    private boolean cleanSnapshots(Function1<OffsetAndEpoch, Option<SnapshotDeletionReason>> predicate) {
        Object object = new Object();
        try {
            if (this.snapshots.size() < 2) {
                return false;
            }
            BooleanRef didClean = BooleanRef.create((boolean)false);
            this.snapshots.keys().toSeq().sliding(2).foreach((Function1 & Serializable)x0$1 -> {
                SeqOps seqOps;
                if (x0$1 != null && !SeqFactory.UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps = package$.MODULE$.Seq().unapplySeq((SeqOps)x0$1))) {
                    new SeqFactory.UnapplySeqWrapper(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps));
                    if (SeqFactory.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 2) == 0) {
                        OffsetAndEpoch snapshot = (OffsetAndEpoch)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 0);
                        OffsetAndEpoch nextSnapshot = (OffsetAndEpoch)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 1);
                        if (snapshot != null && nextSnapshot != null) {
                            Option option = (Option)predicate.apply((Object)snapshot);
                            if (option instanceof Some) {
                                SnapshotDeletionReason reason = (SnapshotDeletionReason)((Some)option).value();
                                if (!this.deleteBeforeSnapshot(nextSnapshot, reason)) {
                                    throw new NonLocalReturnControl.mcZ.sp(object, didClean$1.elem);
                                }
                            } else {
                                if (None$.MODULE$.equals(option)) {
                                    throw new NonLocalReturnControl.mcZ.sp(object, didClean$1.elem);
                                }
                                throw new MatchError((Object)option);
                            }
                            didClean$1.elem = true;
                            return BoxedUnit.UNIT;
                        }
                    }
                }
                return BoxesRunTime.boxToBoolean((boolean)false);
            });
            return didClean.elem;
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                return ex.value$mcZ$sp();
            }
            throw ex;
        }
    }

    private boolean cleanSnapshotsRetentionMs() {
        boolean bl;
        if (this.config.retentionMillis() < 0L) {
            return false;
        }
        Function1 & Serializable cleanSnapshots_predicate = (Function1 & Serializable)snapshotId -> this.shouldClean$1((OffsetAndEpoch)snapshotId);
        Object object = new Object();
        try {
            if (this.snapshots.size() >= 2) {
                BooleanRef cleanSnapshots_didClean = BooleanRef.create((boolean)false);
                this.snapshots.keys().toSeq().sliding(2).foreach((Function1 & Serializable)x0$1 -> {
                    SeqOps seqOps;
                    if (x0$1 != null && !SeqFactory.UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps = package$.MODULE$.Seq().unapplySeq((SeqOps)x0$1))) {
                        new SeqFactory.UnapplySeqWrapper(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps));
                        if (SeqFactory.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 2) == 0) {
                            OffsetAndEpoch snapshot = (OffsetAndEpoch)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 0);
                            OffsetAndEpoch nextSnapshot = (OffsetAndEpoch)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 1);
                            if (snapshot != null && nextSnapshot != null) {
                                Option option = (Option)predicate.apply((Object)snapshot);
                                if (option instanceof Some) {
                                    SnapshotDeletionReason reason = (SnapshotDeletionReason)((Some)option).value();
                                    if (!this.deleteBeforeSnapshot(nextSnapshot, reason)) {
                                        throw new NonLocalReturnControl.mcZ.sp(object, didClean$1.elem);
                                    }
                                } else {
                                    if (None$.MODULE$.equals(option)) {
                                        throw new NonLocalReturnControl.mcZ.sp(object, didClean$1.elem);
                                    }
                                    throw new MatchError((Object)option);
                                }
                                didClean$1.elem = true;
                                return BoxedUnit.UNIT;
                            }
                        }
                    }
                    return BoxesRunTime.boxToBoolean((boolean)false);
                });
                return cleanSnapshots_didClean.elem;
            }
            bl = false;
        }
        catch (NonLocalReturnControl cleanSnapshots_ex) {
            if (cleanSnapshots_ex.key() == object) {
                return cleanSnapshots_ex.value$mcZ$sp();
            }
            throw cleanSnapshots_ex;
        }
        return bl;
    }

    private boolean cleanSnapshotsRetentionSize() {
        boolean bl;
        if (this.config.retentionMaxBytes() < 0L) {
            return false;
        }
        Map snapshotSizes = this.loadSnapshotSizes().toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        LongRef snapshotTotalSize = LongRef.create((long)BoxesRunTime.unboxToLong((Object)snapshotSizes.values().sum((Numeric)Numeric.LongIsIntegral$.MODULE$)));
        Function1 & Serializable cleanSnapshots_predicate = (Function1 & Serializable)snapshotId -> this.shouldClean$2((OffsetAndEpoch)snapshotId, snapshotSizes, snapshotTotalSize);
        Object object = new Object();
        try {
            if (this.snapshots.size() >= 2) {
                BooleanRef cleanSnapshots_didClean = BooleanRef.create((boolean)false);
                this.snapshots.keys().toSeq().sliding(2).foreach((Function1 & Serializable)x0$1 -> {
                    SeqOps seqOps;
                    if (x0$1 != null && !SeqFactory.UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps = package$.MODULE$.Seq().unapplySeq((SeqOps)x0$1))) {
                        new SeqFactory.UnapplySeqWrapper(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps));
                        if (SeqFactory.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 2) == 0) {
                            OffsetAndEpoch snapshot = (OffsetAndEpoch)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 0);
                            OffsetAndEpoch nextSnapshot = (OffsetAndEpoch)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 1);
                            if (snapshot != null && nextSnapshot != null) {
                                Option option = (Option)predicate.apply((Object)snapshot);
                                if (option instanceof Some) {
                                    SnapshotDeletionReason reason = (SnapshotDeletionReason)((Some)option).value();
                                    if (!this.deleteBeforeSnapshot(nextSnapshot, reason)) {
                                        throw new NonLocalReturnControl.mcZ.sp(object, didClean$1.elem);
                                    }
                                } else {
                                    if (None$.MODULE$.equals(option)) {
                                        throw new NonLocalReturnControl.mcZ.sp(object, didClean$1.elem);
                                    }
                                    throw new MatchError((Object)option);
                                }
                                didClean$1.elem = true;
                                return BoxedUnit.UNIT;
                            }
                        }
                    }
                    return BoxesRunTime.boxToBoolean((boolean)false);
                });
                return cleanSnapshots_didClean.elem;
            }
            bl = false;
        }
        catch (NonLocalReturnControl cleanSnapshots_ex) {
            if (cleanSnapshots_ex.key() == object) {
                return cleanSnapshots_ex.value$mcZ$sp();
            }
            throw cleanSnapshots_ex;
        }
        return bl;
    }

    private TreeMap<OffsetAndEpoch, Option<FileRawSnapshotReader>> forgetSnapshotsBefore(OffsetAndEpoch logStartSnapshotId) {
        TreeMap expiredSnapshots = (TreeMap)((MapOps)this.snapshots.until((Object)logStartSnapshotId)).clone();
        this.snapshots.$minus$minus$eq((IterableOnce)expiredSnapshots.keys());
        return expiredSnapshots;
    }

    private void removeSnapshots(TreeMap<OffsetAndEpoch, Option<FileRawSnapshotReader>> expiredSnapshots, SnapshotDeletionReason reason) {
        expiredSnapshots.foreach((Function1 & Serializable)x0$1 -> {
            if (x0$1 != null) {
                OffsetAndEpoch snapshotId = (OffsetAndEpoch)x0$1._1();
                if (this.logger().underlying().isInfoEnabled()) {
                    String msgWithLogIdent_msg = reason.reason(snapshotId);
                    Object var4_4 = null;
                    this.logger().underlying().info(Logging.msgWithLogIdent$(this, msgWithLogIdent_msg));
                }
                return Snapshots.markForDelete((Path)this.log().dir().toPath(), (OffsetAndEpoch)snapshotId);
            }
            throw new MatchError(null);
        });
        if (expiredSnapshots.nonEmpty()) {
            this.scheduler.scheduleOnce("delete-snapshot-files", () -> KafkaMetadataLog$.MODULE$.kafka$raft$KafkaMetadataLog$$deleteSnapshotFiles(this.log().dir().toPath(), expiredSnapshots, this), this.config.fileDeleteDelayMs());
            return;
        }
    }

    public void close() {
        this.log().close();
        TreeMap<OffsetAndEpoch, Option<FileRawSnapshotReader>> treeMap = this.snapshots;
        synchronized (treeMap) {
            ((IterableOnceOps)this.snapshots.values().flatten(Predef$.MODULE$.$conforms())).foreach((Function1 & Serializable)x$3 -> {
                x$3.close();
                return BoxedUnit.UNIT;
            });
            this.snapshots.clear();
            return;
        }
    }

    public int snapshotCount() {
        TreeMap<OffsetAndEpoch, Option<FileRawSnapshotReader>> treeMap = this.snapshots;
        synchronized (treeMap) {
            int n = this.snapshots.size();
            return n;
        }
    }

    public static final /* synthetic */ int $anonfun$lastFetchedEpoch$2(KafkaMetadataLog $this, OffsetAndEpoch snapshotId) {
        long logEndOffset = $this.endOffset().offset();
        if (snapshotId.offset() == $this.startOffset() && snapshotId.offset() == logEndOffset) {
            return snapshotId.epoch();
        }
        throw new KafkaException("Log doesn't have a last fetch epoch and there is a snapshot (" + snapshotId + "). Expected the snapshot's end offset to match the log's end offset (" + logEndOffset + ") and the log start offset (" + $this.startOffset() + ")");
    }

    public static final /* synthetic */ String $anonfun$updateHighWatermark$1(long logHighWatermark$1, LogOffsetMetadata offsetMetadata$1) {
        return "Log's high watermark (" + logHighWatermark$1 + ") is different from the local replica's high watermark (" + offsetMetadata$1 + ")";
    }

    public static final /* synthetic */ String $anonfun$createNewSnapshot$1(KafkaMetadataLog $this, OffsetAndEpoch snapshotId$1) {
        return "Cannot create a snapshot with an id (" + snapshotId$1 + ") less than the log start offset (" + $this.startOffset() + ")";
    }

    public static final /* synthetic */ String $anonfun$readSnapshot$1(OffsetAndEpoch snapshotId$2, Path path$1) {
        return "Couldn't read " + snapshotId$2 + "; expected to find snapshot file " + path$1;
    }

    /*
     * WARNING - void declaration
     */
    private final /* synthetic */ Option liftedTree1$1(OffsetAndEpoch snapshotId$2) {
        try {
            void var2_2;
            Some snapshotReader = new Some((Object)FileRawSnapshotReader.open((Path)this.log().dir().toPath(), (OffsetAndEpoch)snapshotId$2));
            this.snapshots.put((Object)snapshotId$2, (Object)snapshotReader);
            return var2_2;
        }
        catch (NoSuchFileException noSuchFileException) {
            Path path = Snapshots.snapshotPath((Path)this.log().dir().toPath(), (OffsetAndEpoch)snapshotId$2);
            if (this.logger().underlying().isWarnEnabled()) {
                String msgWithLogIdent_msg = KafkaMetadataLog.$anonfun$readSnapshot$1(snapshotId$2, path);
                Object var4_4 = null;
                this.logger().underlying().warn(Logging.msgWithLogIdent$(this, msgWithLogIdent_msg));
            }
            this.snapshots.remove((Object)snapshotId$2);
            return None$.MODULE$;
        }
    }

    public static final /* synthetic */ long $anonfun$readSnapshotTimestamp$1(RawSnapshotReader reader) {
        return Snapshots.lastContainedLogTimestamp((RawSnapshotReader)reader);
    }

    public static final /* synthetic */ Option $anonfun$cleanSnapshotsRetentionMs$1(KafkaMetadataLog $this, long timestamp) {
        long now = $this.time.milliseconds();
        if (now - timestamp > $this.config.retentionMillis()) {
            return new Some((Object)new RetentionMsBreach(now, timestamp, $this.config.retentionMillis()));
        }
        return None$.MODULE$;
    }

    private final Option shouldClean$1(OffsetAndEpoch snapshotId) {
        return this.readSnapshotTimestamp(snapshotId).flatMap((Function1 & Serializable)timestamp -> KafkaMetadataLog.$anonfun$cleanSnapshotsRetentionMs$1(this, BoxesRunTime.unboxToLong((Object)timestamp)));
    }

    public static final /* synthetic */ Option $anonfun$cleanSnapshotsRetentionSize$1(KafkaMetadataLog $this, LongRef snapshotTotalSize$1, long snapshotSize) {
        if ($this.log().size() + snapshotTotalSize$1.elem > $this.config.retentionMaxBytes()) {
            long oldSnapshotTotalSize = snapshotTotalSize$1.elem;
            snapshotTotalSize$1.elem -= snapshotSize;
            return new Some((Object)new RetentionSizeBreach($this.log().size(), oldSnapshotTotalSize, $this.config.retentionMaxBytes()));
        }
        return None$.MODULE$;
    }

    private final Option shouldClean$2(OffsetAndEpoch snapshotId, Map snapshotSizes$1, LongRef snapshotTotalSize$1) {
        return snapshotSizes$1.get((Object)snapshotId).flatMap((Function1 & Serializable)snapshotSize -> KafkaMetadataLog.$anonfun$cleanSnapshotsRetentionSize$1(this, snapshotTotalSize$1, BoxesRunTime.unboxToLong((Object)snapshotSize)));
    }

    public static final /* synthetic */ String $anonfun$removeSnapshots$2(SnapshotDeletionReason reason$1, OffsetAndEpoch snapshotId$4) {
        return reason$1.reason(snapshotId$4);
    }

    public KafkaMetadataLog(UnifiedLog log, Time time, Scheduler scheduler, TreeMap<OffsetAndEpoch, Option<FileRawSnapshotReader>> snapshots, TopicPartition topicPartition, MetadataLogConfig config) {
        this.log = log;
        this.time = time;
        this.scheduler = scheduler;
        this.snapshots = snapshots;
        this.topicPartition = topicPartition;
        this.config = config;
        this.logIdent_$eq("[MetadataLog partition=" + topicPartition + ", nodeId=" + config.nodeId() + "] ");
    }

    private static final class RetentionMsBreach
    implements SnapshotDeletionReason,
    Product,
    Serializable {
        private final long now;
        private final long timestamp;
        private final long retentionMillis;

        public Iterator<String> productElementNames() {
            return Product.productElementNames$((Product)this);
        }

        public long now() {
            return this.now;
        }

        public long timestamp() {
            return this.timestamp;
        }

        public long retentionMillis() {
            return this.retentionMillis;
        }

        @Override
        public String reason(OffsetAndEpoch snapshotId) {
            return StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("Marking snapshot " + snapshotId + " for deletion because its timestamp (" + this.timestamp() + ") is now (" + this.now() + ") older than the\n          |retention (" + this.retentionMillis() + ")"));
        }

        public RetentionMsBreach copy(long now, long timestamp, long retentionMillis) {
            return new RetentionMsBreach(now, timestamp, retentionMillis);
        }

        public long copy$default$1() {
            return this.now();
        }

        public long copy$default$2() {
            return this.timestamp();
        }

        public long copy$default$3() {
            return this.retentionMillis();
        }

        public String productPrefix() {
            return "RetentionMsBreach";
        }

        public int productArity() {
            return 3;
        }

        public Object productElement(int x$1) {
            switch (x$1) {
                case 0: {
                    return BoxesRunTime.boxToLong((long)this.now());
                }
                case 1: {
                    return BoxesRunTime.boxToLong((long)this.timestamp());
                }
                case 2: {
                    return BoxesRunTime.boxToLong((long)this.retentionMillis());
                }
            }
            return Statics.ioobe((int)x$1);
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof RetentionMsBreach;
        }

        public String productElementName(int x$1) {
            switch (x$1) {
                case 0: {
                    return "now";
                }
                case 1: {
                    return "timestamp";
                }
                case 2: {
                    return "retentionMillis";
                }
            }
            return (String)Statics.ioobe((int)x$1);
        }

        public int hashCode() {
            return Statics.finalizeHash((int)Statics.mix((int)Statics.mix((int)Statics.mix((int)Statics.mix((int)-889275714, (int)"RetentionMsBreach".hashCode()), (int)Statics.longHash((long)this.now())), (int)Statics.longHash((long)this.timestamp())), (int)Statics.longHash((long)this.retentionMillis())), (int)3);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean equals(Object x$1) {
            block3: {
                block2: {
                    if (this == x$1) break block2;
                    if (!(x$1 instanceof RetentionMsBreach)) break block3;
                    RetentionMsBreach retentionMsBreach = (RetentionMsBreach)x$1;
                    if (this.now() != retentionMsBreach.now() || this.timestamp() != retentionMsBreach.timestamp() || this.retentionMillis() != retentionMsBreach.retentionMillis()) break block3;
                }
                return true;
            }
            return false;
        }

        public RetentionMsBreach(long now, long timestamp, long retentionMillis) {
            this.now = now;
            this.timestamp = timestamp;
            this.retentionMillis = retentionMillis;
            Product.$init$((Product)this);
        }
    }

    private static final class RetentionSizeBreach
    implements SnapshotDeletionReason,
    Product,
    Serializable {
        private final long logSize;
        private final long snapshotsSize;
        private final long retentionMaxBytes;

        public Iterator<String> productElementNames() {
            return Product.productElementNames$((Product)this);
        }

        public long logSize() {
            return this.logSize;
        }

        public long snapshotsSize() {
            return this.snapshotsSize;
        }

        public long retentionMaxBytes() {
            return this.retentionMaxBytes;
        }

        @Override
        public String reason(OffsetAndEpoch snapshotId) {
            return StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("Marking snapshot " + snapshotId + " for deletion because the log size (" + this.logSize() + ") and snapshots size (" + this.snapshotsSize() + ")\n          |is greater than " + this.retentionMaxBytes()));
        }

        public RetentionSizeBreach copy(long logSize, long snapshotsSize, long retentionMaxBytes) {
            return new RetentionSizeBreach(logSize, snapshotsSize, retentionMaxBytes);
        }

        public long copy$default$1() {
            return this.logSize();
        }

        public long copy$default$2() {
            return this.snapshotsSize();
        }

        public long copy$default$3() {
            return this.retentionMaxBytes();
        }

        public String productPrefix() {
            return "RetentionSizeBreach";
        }

        public int productArity() {
            return 3;
        }

        public Object productElement(int x$1) {
            switch (x$1) {
                case 0: {
                    return BoxesRunTime.boxToLong((long)this.logSize());
                }
                case 1: {
                    return BoxesRunTime.boxToLong((long)this.snapshotsSize());
                }
                case 2: {
                    return BoxesRunTime.boxToLong((long)this.retentionMaxBytes());
                }
            }
            return Statics.ioobe((int)x$1);
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof RetentionSizeBreach;
        }

        public String productElementName(int x$1) {
            switch (x$1) {
                case 0: {
                    return "logSize";
                }
                case 1: {
                    return "snapshotsSize";
                }
                case 2: {
                    return "retentionMaxBytes";
                }
            }
            return (String)Statics.ioobe((int)x$1);
        }

        public int hashCode() {
            return Statics.finalizeHash((int)Statics.mix((int)Statics.mix((int)Statics.mix((int)Statics.mix((int)-889275714, (int)"RetentionSizeBreach".hashCode()), (int)Statics.longHash((long)this.logSize())), (int)Statics.longHash((long)this.snapshotsSize())), (int)Statics.longHash((long)this.retentionMaxBytes())), (int)3);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean equals(Object x$1) {
            block3: {
                block2: {
                    if (this == x$1) break block2;
                    if (!(x$1 instanceof RetentionSizeBreach)) break block3;
                    RetentionSizeBreach retentionSizeBreach = (RetentionSizeBreach)x$1;
                    if (this.logSize() != retentionSizeBreach.logSize() || this.snapshotsSize() != retentionSizeBreach.snapshotsSize() || this.retentionMaxBytes() != retentionSizeBreach.retentionMaxBytes()) break block3;
                }
                return true;
            }
            return false;
        }

        public RetentionSizeBreach(long logSize, long snapshotsSize, long retentionMaxBytes) {
            this.logSize = logSize;
            this.snapshotsSize = snapshotsSize;
            this.retentionMaxBytes = retentionMaxBytes;
            Product.$init$((Product)this);
        }
    }

    private static interface SnapshotDeletionReason {
        public String reason(OffsetAndEpoch var1);
    }
}

