/*
 * Decompiled with CFR 0.152.
 */
package kafka.server.handlers;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Stream;
import kafka.network.RequestChannel;
import kafka.server.AuthHelper;
import kafka.server.KafkaConfig;
import kafka.server.metadata.KRaftMetadataCache;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.acl.AclOperation;
import org.apache.kafka.common.errors.InvalidRequestException;
import org.apache.kafka.common.message.DescribeTopicPartitionsRequestData;
import org.apache.kafka.common.message.DescribeTopicPartitionsResponseData;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.DescribeTopicPartitionsRequest;
import org.apache.kafka.common.resource.Resource;
import org.apache.kafka.common.resource.ResourceType;
import scala.Function1;
import scala.collection.Iterator;
import scala.jdk.javaapi.CollectionConverters;

public class DescribeTopicPartitionsRequestHandler {
    KRaftMetadataCache metadataCache;
    AuthHelper authHelper;
    KafkaConfig config;

    public DescribeTopicPartitionsRequestHandler(KRaftMetadataCache metadataCache, AuthHelper authHelper, KafkaConfig config) {
        this.metadataCache = metadataCache;
        this.authHelper = authHelper;
        this.config = config;
    }

    public DescribeTopicPartitionsResponseData handleDescribeTopicPartitionsRequest(RequestChannel.Request abstractRequest) {
        String cursorTopicName;
        DescribeTopicPartitionsRequestData request = ((DescribeTopicPartitionsRequest)abstractRequest.loggableRequest()).data();
        HashSet topics = new HashSet();
        boolean fetchAllTopics = request.topics().isEmpty();
        DescribeTopicPartitionsRequestData.Cursor cursor = request.cursor();
        String string = cursorTopicName = cursor != null ? cursor.topicName() : "";
        if (fetchAllTopics) {
            CollectionConverters.asJavaCollection(this.metadataCache.getAllTopics()).forEach(topicName -> {
                if (topicName.compareTo(cursorTopicName) >= 0) {
                    topics.add(topicName);
                }
            });
        } else {
            request.topics().forEach(topic -> {
                String topicName = topic.name();
                if (topicName.compareTo(cursorTopicName) >= 0) {
                    topics.add(topicName);
                }
            });
            if (cursor != null && !topics.contains(cursor.topicName())) {
                throw new InvalidRequestException("DescribeTopicPartitionsRequest topic list should contain the cursor topic: " + cursor.topicName());
            }
        }
        if (cursor != null && cursor.partitionIndex() < 0) {
            throw new InvalidRequestException("DescribeTopicPartitionsRequest cursor partition must be valid: " + String.valueOf(cursor));
        }
        HashSet unauthorizedForDescribeTopicMetadata = new HashSet();
        Stream<String> authorizedTopicsStream = topics.stream().sorted().filter(topicName -> {
            boolean isAuthorized = this.authHelper.authorize(abstractRequest.context(), AclOperation.DESCRIBE, ResourceType.TOPIC, (String)topicName, true, true, 1);
            if (!fetchAllTopics && !isAuthorized) {
                unauthorizedForDescribeTopicMetadata.add(this.describeTopicPartitionsResponseTopic(Errors.TOPIC_AUTHORIZATION_FAILED, (String)topicName, Uuid.ZERO_UUID, false, Collections.emptyList()));
            }
            return isAuthorized;
        });
        DescribeTopicPartitionsResponseData response = this.metadataCache.getTopicMetadataForDescribeTopicResponse((Iterator<String>)CollectionConverters.asScala(authorizedTopicsStream.iterator()), abstractRequest.context().listenerName, (Function1<String, Object>)((Function1)topicName -> topicName.equals(cursorTopicName) ? cursor.partitionIndex() : 0), Math.max(Math.min(this.config.maxRequestPartitionSizeLimit(), request.responsePartitionLimit()), 1), fetchAllTopics);
        response.topics().forEach(topicData -> topicData.setTopicAuthorizedOperations(this.authHelper.authorizedOperations(abstractRequest, new Resource(ResourceType.TOPIC, topicData.name()))));
        response.topics().addAll(unauthorizedForDescribeTopicMetadata);
        return response;
    }

    private DescribeTopicPartitionsResponseData.DescribeTopicPartitionsResponseTopic describeTopicPartitionsResponseTopic(Errors error, String topic, Uuid topicId, Boolean isInternal, List<DescribeTopicPartitionsResponseData.DescribeTopicPartitionsResponsePartition> partitionData) {
        return new DescribeTopicPartitionsResponseData.DescribeTopicPartitionsResponseTopic().setErrorCode(error.code()).setName(topic).setTopicId(topicId).setIsInternal(isInternal.booleanValue()).setPartitions(partitionData);
    }
}

