/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.service.knoxtoken;

import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collections;
import java.util.Enumeration;
import java.util.EventListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.servlet.Filter;
import javax.servlet.FilterRegistration;
import javax.servlet.RequestDispatcher;
import javax.servlet.Servlet;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRegistration;
import javax.servlet.SessionCookieConfig;
import javax.servlet.SessionTrackingMode;
import javax.servlet.descriptor.JspConfigDescriptor;

class ServletContextWrapper
implements ServletContext {
    private ServletContext delegate;
    private Map<String, String> defaultParams;
    private Map<String, String> extensionParams;

    ServletContextWrapper(ServletContext delegate) {
        this.delegate = delegate;
        this.defaultParams = new HashMap<String, String>();
        this.extensionParams = new HashMap<String, String>();
    }

    public String getContextPath() {
        return this.delegate.getContextPath();
    }

    public ServletContext getContext(String uripath) {
        return this.delegate.getContext(uripath);
    }

    public int getMajorVersion() {
        return this.delegate.getMajorVersion();
    }

    public int getMinorVersion() {
        return this.delegate.getMinorVersion();
    }

    public int getEffectiveMajorVersion() {
        return this.delegate.getEffectiveMajorVersion();
    }

    public int getEffectiveMinorVersion() {
        return this.delegate.getEffectiveMinorVersion();
    }

    public String getMimeType(String file) {
        return this.delegate.getMimeType(file);
    }

    public Set<String> getResourcePaths(String path) {
        return this.delegate.getResourcePaths(path);
    }

    public URL getResource(String path) throws MalformedURLException {
        return this.delegate.getResource(path);
    }

    public InputStream getResourceAsStream(String path) {
        return this.delegate.getResourceAsStream(path);
    }

    public RequestDispatcher getRequestDispatcher(String path) {
        return this.delegate.getRequestDispatcher(path);
    }

    public RequestDispatcher getNamedDispatcher(String name) {
        return this.delegate.getNamedDispatcher(name);
    }

    public Servlet getServlet(String name) throws ServletException {
        return this.delegate.getServlet(name);
    }

    public Enumeration<Servlet> getServlets() {
        return this.delegate.getServlets();
    }

    public Enumeration<String> getServletNames() {
        return this.delegate.getServletNames();
    }

    public void log(String msg) {
        this.delegate.log(msg);
    }

    public void log(Exception exception, String msg) {
        this.delegate.log(exception, msg);
    }

    public void log(String message, Throwable throwable) {
        this.delegate.log(message, throwable);
    }

    public String getRealPath(String path) {
        return this.delegate.getRealPath(path);
    }

    public String getServerInfo() {
        return this.delegate.getServerInfo();
    }

    public String getInitParameter(String name) {
        String value = this.extensionParams.get(name);
        if (value == null) {
            value = this.delegate.getInitParameter(name);
        }
        if (value == null) {
            value = this.defaultParams.get(name);
        }
        return value;
    }

    public Enumeration<String> getInitParameterNames() {
        HashSet<String> combinedNames = new HashSet<String>(this.defaultParams.keySet());
        Enumeration delegateNames = this.delegate.getInitParameterNames();
        while (delegateNames.hasMoreElements()) {
            combinedNames.add((String)delegateNames.nextElement());
        }
        Set<String> extensionNames = this.extensionParams.keySet();
        combinedNames.addAll(extensionNames);
        return Collections.enumeration(combinedNames);
    }

    public boolean setInitParameter(String name, String value) {
        this.defaultParams.put(name, value);
        return this.defaultParams.get(name).equals(value);
    }

    public boolean setExtensionParameter(String name, String value) {
        this.extensionParams.put(name, value);
        return this.extensionParams.get(name).equals(value);
    }

    public Object getAttribute(String name) {
        return this.delegate.getAttribute(name);
    }

    public Enumeration<String> getAttributeNames() {
        return this.delegate.getAttributeNames();
    }

    public void setAttribute(String name, Object object) {
        this.delegate.setAttribute(name, object);
    }

    public void removeAttribute(String name) {
        this.delegate.removeAttribute(name);
    }

    public String getServletContextName() {
        return this.delegate.getServletContextName();
    }

    public ServletRegistration.Dynamic addServlet(String servletName, String className) {
        return this.delegate.addServlet(servletName, className);
    }

    public ServletRegistration.Dynamic addServlet(String servletName, Servlet servlet) {
        return this.delegate.addServlet(servletName, servlet);
    }

    public ServletRegistration.Dynamic addServlet(String servletName, Class<? extends Servlet> servletClass) {
        return this.delegate.addServlet(servletName, servletClass);
    }

    public <T extends Servlet> T createServlet(Class<T> clazz) throws ServletException {
        return (T)this.delegate.createServlet(clazz);
    }

    public ServletRegistration getServletRegistration(String servletName) {
        return this.delegate.getServletRegistration(servletName);
    }

    public Map<String, ? extends ServletRegistration> getServletRegistrations() {
        return this.delegate.getServletRegistrations();
    }

    public FilterRegistration.Dynamic addFilter(String filterName, String className) {
        return this.delegate.addFilter(filterName, className);
    }

    public FilterRegistration.Dynamic addFilter(String filterName, Filter filter) {
        return this.delegate.addFilter(filterName, filter);
    }

    public FilterRegistration.Dynamic addFilter(String filterName, Class<? extends Filter> filterClass) {
        return this.delegate.addFilter(filterName, filterClass);
    }

    public <T extends Filter> T createFilter(Class<T> clazz) throws ServletException {
        return (T)this.delegate.createFilter(clazz);
    }

    public FilterRegistration getFilterRegistration(String filterName) {
        return this.delegate.getFilterRegistration(filterName);
    }

    public Map<String, ? extends FilterRegistration> getFilterRegistrations() {
        return this.delegate.getFilterRegistrations();
    }

    public SessionCookieConfig getSessionCookieConfig() {
        return this.delegate.getSessionCookieConfig();
    }

    public void setSessionTrackingModes(Set<SessionTrackingMode> sessionTrackingModes) {
        this.delegate.setSessionTrackingModes(sessionTrackingModes);
    }

    public Set<SessionTrackingMode> getDefaultSessionTrackingModes() {
        return this.delegate.getDefaultSessionTrackingModes();
    }

    public Set<SessionTrackingMode> getEffectiveSessionTrackingModes() {
        return this.delegate.getEffectiveSessionTrackingModes();
    }

    public void addListener(String className) {
        this.delegate.addListener(className);
    }

    public <T extends EventListener> void addListener(T t) {
        this.delegate.addListener(t);
    }

    public void addListener(Class<? extends EventListener> listenerClass) {
        this.delegate.addListener(listenerClass);
    }

    public <T extends EventListener> T createListener(Class<T> clazz) throws ServletException {
        return (T)this.delegate.createListener(clazz);
    }

    public JspConfigDescriptor getJspConfigDescriptor() {
        return this.delegate.getJspConfigDescriptor();
    }

    public ClassLoader getClassLoader() {
        return this.delegate.getClassLoader();
    }

    public void declareRoles(String ... roleNames) {
        this.delegate.declareRoles(roleNames);
    }

    public String getVirtualServerName() {
        return this.delegate.getVirtualServerName();
    }
}

