/*
 * Decompiled with CFR 0.152.
 */
package org.ldaptive.asn1;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import org.ldaptive.LdapUtils;
import org.ldaptive.asn1.AbstractDERType;
import org.ldaptive.asn1.ConstructedDEREncoder;
import org.ldaptive.asn1.DEREncoder;
import org.ldaptive.asn1.DERParser;
import org.ldaptive.asn1.DERTag;
import org.ldaptive.asn1.OidType;
import org.ldaptive.asn1.ParseHandler;
import org.ldaptive.asn1.UniversalDERTag;

public class AttributeValueAssertion
extends AbstractDERType
implements DEREncoder {
    private static final int HASH_CODE_SEED = 613;
    private final String attributeOid;
    private final Value attributeValue;

    public AttributeValueAssertion(String oid, Value value) {
        super(value.getTag());
        this.attributeOid = oid;
        this.attributeValue = value;
    }

    public String getOid() {
        return this.attributeOid;
    }

    public Value getValue() {
        return this.attributeValue;
    }

    @Override
    public byte[] encode() {
        ConstructedDEREncoder se = new ConstructedDEREncoder(UniversalDERTag.SEQ, new DEREncoder(){

            @Override
            public byte[] encode() {
                OidType type = new OidType(AttributeValueAssertion.this.attributeOid);
                return type.encode();
            }
        }, new DEREncoder(){

            @Override
            public byte[] encode() {
                return AttributeValueAssertion.this.encode(new byte[][]{AttributeValueAssertion.this.attributeValue.getBytes()});
            }
        });
        return se.encode();
    }

    public static AttributeValueAssertion[] decode(ByteBuffer encoded) {
        final ArrayList assertions = new ArrayList();
        DERParser parser = new DERParser();
        parser.registerHandler("/SEQ", new ParseHandler(){

            @Override
            public void handle(DERParser parser, ByteBuffer encoded) {
                if (UniversalDERTag.OID.getTagNo() != parser.readTag(encoded).getTagNo()) {
                    throw new IllegalArgumentException("Expected OID tag");
                }
                int seqLimit = encoded.limit();
                int oidLength = parser.readLength(encoded);
                encoded.limit(encoded.position() + oidLength);
                String oid = OidType.decode(encoded);
                encoded.limit(seqLimit);
                DERTag tag = parser.readTag(encoded);
                parser.readLength(encoded);
                assertions.add(new AttributeValueAssertion(oid, new Value(tag, AbstractDERType.readBuffer(encoded))));
            }
        });
        parser.parse(encoded);
        return assertions.toArray(new AttributeValueAssertion[assertions.size()]);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof AttributeValueAssertion) {
            AttributeValueAssertion v = (AttributeValueAssertion)o;
            return LdapUtils.areEqual(this.attributeOid, v.attributeOid) && LdapUtils.areEqual(this.attributeValue, v.attributeValue);
        }
        return false;
    }

    public int hashCode() {
        return LdapUtils.computeHashCode(613, this.attributeOid, this.attributeValue);
    }

    public String toString() {
        return String.format("[%s@%d::attributeOid=%s, attributeValue=%s]", this.getClass().getName(), this.hashCode(), this.attributeOid, this.attributeValue);
    }

    public static class Value {
        private static final int HASH_CODE_SEED = 617;
        private final DERTag attributeValueTag;
        private final byte[] attributeValueBytes;

        public Value(DERTag tag, byte[] bytes) {
            this.attributeValueTag = tag;
            this.attributeValueBytes = bytes;
        }

        public DERTag getTag() {
            return this.attributeValueTag;
        }

        public byte[] getBytes() {
            return this.attributeValueBytes;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o instanceof Value) {
                Value v = (Value)o;
                return LdapUtils.areEqual(this.attributeValueTag, v.attributeValueTag) && LdapUtils.areEqual(this.attributeValueBytes, v.attributeValueBytes);
            }
            return false;
        }

        public int hashCode() {
            return LdapUtils.computeHashCode(617, this.attributeValueTag, this.attributeValueBytes);
        }

        public String toString() {
            return String.format("[%s@%d::attributeValueTag=%s, attributeValueBytes=%s]", this.getClass().getName(), this.hashCode(), this.attributeValueTag, LdapUtils.utf8Encode(this.attributeValueBytes));
        }
    }
}

