/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.model.filter;

import java.util.Arrays;
import org.apache.directory.api.i18n.I18n;
import org.apache.directory.api.ldap.model.entry.Value;
import org.apache.directory.api.ldap.model.exception.LdapInvalidAttributeValueException;
import org.apache.directory.api.ldap.model.filter.AssertionType;
import org.apache.directory.api.ldap.model.filter.ExprNode;
import org.apache.directory.api.ldap.model.filter.LeafNode;
import org.apache.directory.api.ldap.model.schema.AttributeType;
import org.apache.directory.api.util.Strings;

public abstract class SimpleNode<T>
extends LeafNode {
    protected Value value;
    protected byte[] bytes;
    public static final boolean EVAL_GREATER = true;
    public static final boolean EVAL_LESSER = false;

    protected SimpleNode(String attribute, byte[] bytes, AssertionType assertionType) {
        super(attribute, assertionType);
        this.bytes = bytes;
    }

    protected SimpleNode(AttributeType attributeType, byte[] bytes, AssertionType assertionType) {
        super(attributeType, assertionType);
        this.bytes = bytes;
        try {
            this.value = attributeType.isHR() ? new Value(attributeType, Strings.utf8ToString((byte[])bytes)) : new Value(attributeType, bytes);
        }
        catch (LdapInvalidAttributeValueException e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    protected SimpleNode(String attribute, String string, AssertionType assertionType) {
        super(attribute, assertionType);
        this.bytes = Strings.getBytesUtf8((String)string);
        if (this.attributeType != null) {
            try {
                this.value = this.attributeType.isHR() ? new Value(this.attributeType, string) : new Value(this.attributeType, this.bytes);
            }
            catch (LdapInvalidAttributeValueException e) {
                throw new RuntimeException(e.getMessage());
            }
        }
    }

    protected SimpleNode(AttributeType attributeType, Value value, AssertionType assertionType) {
        super(attributeType, assertionType);
        this.value = value;
    }

    @Override
    public ExprNode clone() {
        ExprNode clone = super.clone();
        if (this.value != null) {
            ((SimpleNode)clone).value = this.value.clone();
        } else if (this.bytes != null) {
            ((SimpleNode)clone).bytes = new byte[this.bytes.length];
            System.arraycopy(this.bytes, 0, ((SimpleNode)clone).bytes, 0, this.bytes.length);
        }
        return clone;
    }

    public final Value getValue() {
        if (this.value == null) {
            return new Value(this.bytes);
        }
        return this.value;
    }

    public String getEscapedValue() {
        if (this.value != null) {
            return SimpleNode.escapeFilterValue(this.value.getAttributeType(), this.value.getBytes());
        }
        return SimpleNode.escapeFilterValue(null, this.bytes);
    }

    public void setValue(Value value) {
        this.value = value;
        this.bytes = value.getBytes();
    }

    public StringBuilder printToBuffer(StringBuilder buf) {
        if (null != this.getAnnotations() && this.getAnnotations().containsKey("count")) {
            buf.append(":[");
            buf.append(this.getAnnotations().get("count").toString());
            buf.append("] ");
        }
        buf.append(')');
        return buf;
    }

    @Override
    public StringBuilder printRefinementToBuffer(StringBuilder buf) {
        if (this.isSchemaAware() ? !this.attributeType.getOid().equals("2.5.4.0") : this.attribute == null || !"objectClass".equalsIgnoreCase(this.attribute) && !"2.5.4.0".equalsIgnoreCase(this.attribute)) {
            throw new UnsupportedOperationException(I18n.err((I18n)I18n.ERR_13318_INVALID_ATTR_IN_REFINEMENT, (Object[])new Object[]{this.attribute}));
        }
        buf.append("item: ").append(this.value);
        return buf;
    }

    @Override
    public int hashCode() {
        int h = 37;
        h = h * 17 + super.hashCode();
        h = h * 17 + (this.value == null ? 0 : this.value.hashCode());
        return h;
    }

    @Override
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof SimpleNode)) {
            return false;
        }
        if (other.getClass() != this.getClass()) {
            return false;
        }
        if (!super.equals(other)) {
            return false;
        }
        SimpleNode otherNode = (SimpleNode)other;
        if (this.value == null) {
            if (this.bytes == null) {
                return otherNode.bytes == null;
            }
            return Arrays.equals(this.bytes, otherNode.bytes);
        }
        return this.value.equals(otherNode.value);
    }
}

