/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.topology.discovery.cm.monitor;

import com.cloudera.api.swagger.model.ApiConfig;
import com.cloudera.api.swagger.model.ApiConfigList;
import com.cloudera.api.swagger.model.ApiRole;
import com.cloudera.api.swagger.model.ApiServiceConfig;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

final class ServiceConfigurationModel {
    private static final String NULL_VALUE = "null";
    private Map<String, String> serviceProps = new ConcurrentHashMap<String, String>();
    private Map<String, Map<String, String>> roleProps = new ConcurrentHashMap<String, Map<String, String>>();

    ServiceConfigurationModel() {
    }

    ServiceConfigurationModel(ApiServiceConfig serviceConfig, Map<ApiRole, ApiConfigList> roles) {
        for (ApiConfig apiConfig : serviceConfig.getItems()) {
            String value = apiConfig.getValue();
            if (value == null || value.isEmpty()) {
                value = apiConfig.getDefault();
            }
            this.addServiceProperty(apiConfig.getName(), value);
        }
        if (roles != null && !roles.isEmpty()) {
            for (Map.Entry entry : roles.entrySet()) {
                ApiRole role = (ApiRole)entry.getKey();
                ApiConfigList roleConfigList = (ApiConfigList)entry.getValue();
                for (ApiConfig roleConfig : roleConfigList.getItems()) {
                    roleConfig.getName();
                    String value = roleConfig.getValue();
                    if (value == null) {
                        value = roleConfig.getDefault();
                    }
                    this.addRoleProperty(role.getType(), roleConfig.getName(), value);
                }
            }
        }
    }

    void addServiceProperty(String name, String value) {
        this.serviceProps.put(name, value != null ? value : NULL_VALUE);
    }

    Map<String, String> getServiceProps() {
        return this.serviceProps;
    }

    void addRoleProperty(String roleType, String name, String value) {
        this.roleProps.computeIfAbsent(roleType, p -> new ConcurrentHashMap()).put(name, value != null ? value : NULL_VALUE);
    }

    Set<String> getRoleTypes() {
        return this.roleProps.keySet();
    }

    Map<String, String> getRoleProps(String roleType) {
        return this.roleProps.get(roleType);
    }

    Map<String, Map<String, String>> getRoleProps() {
        return this.roleProps;
    }
}

