/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.api.swagger.model;

import com.cloudera.api.swagger.model.ApiConfigList;
import com.google.gson.annotations.SerializedName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;

@Schema(description="Represents an instantiation of an external account type, referencing a supported external account type, via the typeName field, along with suitable configuration to access an external resource of the provided type.  The typeName field must match the name of an external account type.")
public class ApiExternalAccount {
    @SerializedName(value="name")
    private String name = null;
    @SerializedName(value="displayName")
    private String displayName = null;
    @SerializedName(value="createdTime")
    private String createdTime = null;
    @SerializedName(value="lastModifiedTime")
    private String lastModifiedTime = null;
    @SerializedName(value="typeName")
    private String typeName = null;
    @SerializedName(value="accountConfigs")
    private ApiConfigList accountConfigs = null;

    public ApiExternalAccount name(String name) {
        this.name = name;
        return this;
    }

    @Schema(description="Represents the intial name of the account; used to uniquely identify this account.")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public ApiExternalAccount displayName(String displayName) {
        this.displayName = displayName;
        return this;
    }

    @Schema(description="Represents a modifiable label to identify this account for user-visible purposes.")
    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public ApiExternalAccount createdTime(String createdTime) {
        this.createdTime = createdTime;
        return this;
    }

    @Schema(description="Represents the time of creation for this account.")
    public String getCreatedTime() {
        return this.createdTime;
    }

    public void setCreatedTime(String createdTime) {
        this.createdTime = createdTime;
    }

    public ApiExternalAccount lastModifiedTime(String lastModifiedTime) {
        this.lastModifiedTime = lastModifiedTime;
        return this;
    }

    @Schema(description="Represents the last modification time for this account.")
    public String getLastModifiedTime() {
        return this.lastModifiedTime;
    }

    public void setLastModifiedTime(String lastModifiedTime) {
        this.lastModifiedTime = lastModifiedTime;
    }

    public ApiExternalAccount typeName(String typeName) {
        this.typeName = typeName;
        return this;
    }

    @Schema(description="Represents the Type ID of a supported external account type. The type represented by this field dictates which configuration options must be defined for this account.")
    public String getTypeName() {
        return this.typeName;
    }

    public void setTypeName(String typeName) {
        this.typeName = typeName;
    }

    public ApiExternalAccount accountConfigs(ApiConfigList accountConfigs) {
        this.accountConfigs = accountConfigs;
        return this;
    }

    @Schema(description="")
    public ApiConfigList getAccountConfigs() {
        return this.accountConfigs;
    }

    public void setAccountConfigs(ApiConfigList accountConfigs) {
        this.accountConfigs = accountConfigs;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ApiExternalAccount apiExternalAccount = (ApiExternalAccount)o;
        return Objects.equals(this.name, apiExternalAccount.name) && Objects.equals(this.displayName, apiExternalAccount.displayName) && Objects.equals(this.createdTime, apiExternalAccount.createdTime) && Objects.equals(this.lastModifiedTime, apiExternalAccount.lastModifiedTime) && Objects.equals(this.typeName, apiExternalAccount.typeName) && Objects.equals(this.accountConfigs, apiExternalAccount.accountConfigs);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.displayName, this.createdTime, this.lastModifiedTime, this.typeName, this.accountConfigs);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ApiExternalAccount {\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    displayName: ").append(this.toIndentedString(this.displayName)).append("\n");
        sb.append("    createdTime: ").append(this.toIndentedString(this.createdTime)).append("\n");
        sb.append("    lastModifiedTime: ").append(this.toIndentedString(this.lastModifiedTime)).append("\n");
        sb.append("    typeName: ").append(this.toIndentedString(this.typeName)).append("\n");
        sb.append("    accountConfigs: ").append(this.toIndentedString(this.accountConfigs)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

