/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.codec.actions.response.extended;

import org.apache.directory.api.asn1.DecoderException;
import org.apache.directory.api.asn1.ber.grammar.GrammarAction;
import org.apache.directory.api.asn1.ber.tlv.TLV;
import org.apache.directory.api.i18n.I18n;
import org.apache.directory.api.ldap.codec.api.ExtendedOperationFactory;
import org.apache.directory.api.ldap.codec.api.LdapMessageContainer;
import org.apache.directory.api.ldap.model.message.ExtendedResponse;
import org.apache.directory.api.ldap.model.message.OpaqueExtendedResponse;
import org.apache.directory.api.util.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StoreExtendedResponseValue
extends GrammarAction<LdapMessageContainer<ExtendedResponse>> {
    private static final Logger LOG = LoggerFactory.getLogger(StoreExtendedResponseValue.class);

    public StoreExtendedResponseValue() {
        super("Store response value");
    }

    public void action(LdapMessageContainer<ExtendedResponse> container) throws DecoderException {
        ExtendedResponse extendedResponse = container.getMessage();
        TLV tlv = container.getCurrentTLV();
        ExtendedOperationFactory factory = container.getExtendedFactory();
        try {
            if (factory == null) {
                if (tlv.getLength() == 0) {
                    ((OpaqueExtendedResponse)extendedResponse).setResponseValue(Strings.EMPTY_BYTES);
                } else {
                    ((OpaqueExtendedResponse)extendedResponse).setResponseValue(tlv.getValue().getData());
                }
            } else {
                factory.decodeValue(extendedResponse, tlv.getValue().getData());
            }
        }
        catch (DecoderException de) {
            String msg = I18n.err((I18n)I18n.ERR_05158_INVALID_REQUEST_VALUE, (Object[])new Object[]{Strings.dumpBytes((byte[])tlv.getValue().getData())});
            LOG.error(I18n.err((I18n)I18n.ERR_05114_ERROR_MESSAGE, (Object[])new Object[]{msg, de.getMessage()}));
            throw de;
        }
        container.setGrammarEndAllowed(true);
        if (LOG.isDebugEnabled()) {
            LOG.debug(I18n.msg((I18n)I18n.MSG_05173_EXTENDED_VALUE, (Object[])new Object[]{Strings.dumpBytes((byte[])tlv.getValue().getData())}));
        }
    }
}

