/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.util.functional;

import java.io.IOException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;
import org.apache.hadoop.util.Preconditions;
import org.apache.hadoop.util.functional.CallableRaisingIOE;
import org.apache.hadoop.util.functional.LazyAtomicReference;

public class LazyAutoCloseableReference<T extends AutoCloseable>
extends LazyAtomicReference<T>
implements AutoCloseable {
    private final AtomicBoolean closed = new AtomicBoolean(false);

    public LazyAutoCloseableReference(CallableRaisingIOE<? extends T> constructor) {
        super(constructor);
    }

    @Override
    public synchronized T eval() throws IOException {
        Preconditions.checkState(!this.closed.get(), "Reference is closed");
        return (T)((AutoCloseable)super.eval());
    }

    public boolean isClosed() {
        return this.closed.get();
    }

    @Override
    public synchronized void close() throws Exception {
        if (this.closed.getAndSet(true)) {
            return;
        }
        AutoCloseable v = (AutoCloseable)this.getReference().get();
        if (v != null) {
            try {
                v.close();
            }
            finally {
                this.getReference().set(null);
            }
        }
    }

    public static <T extends AutoCloseable> LazyAutoCloseableReference<T> lazyAutoCloseablefromSupplier(Supplier<T> supplier) {
        return new LazyAutoCloseableReference<AutoCloseable>(supplier::get);
    }
}

