/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.topology.discovery.cm.model.solr;

import com.cloudera.api.swagger.model.ApiConfigList;
import com.cloudera.api.swagger.model.ApiRole;
import com.cloudera.api.swagger.model.ApiService;
import com.cloudera.api.swagger.model.ApiServiceConfig;
import java.util.Locale;
import org.apache.knox.gateway.topology.discovery.cm.ServiceModel;
import org.apache.knox.gateway.topology.discovery.cm.model.AbstractServiceModelGenerator;

public class SolrServiceModelGenerator
extends AbstractServiceModelGenerator {
    public static final String SERVICE = "SOLR";
    public static final String SERVICE_TYPE = "SOLR";
    public static final String ROLE_TYPE = "SOLR_SERVER";
    public static final String DISCOVERY_SERVICE_NAME = "service-name";
    public static final String DISCOVERY_SERVICE_DISPLAY_NAME = "service-display-name";
    static final String USE_SSL = "solr_use_ssl";
    static final String HTTP_PORT = "solr_http_port";
    static final String HTTPS_PORT = "solr_https_port";

    @Override
    public String getService() {
        return "SOLR";
    }

    @Override
    public String getServiceType() {
        return "SOLR";
    }

    @Override
    public String getRoleType() {
        return ROLE_TYPE;
    }

    @Override
    public ServiceModel.Type getModelType() {
        return ServiceModel.Type.API;
    }

    @Override
    public ServiceModel generateService(ApiService service, ApiServiceConfig serviceConfig, ApiRole role, ApiConfigList roleConfig, ApiServiceConfig coreSettingsConfig) {
        String port;
        String scheme;
        String hostname = role.getHostRef().getHostname();
        String sslEnabled = this.getServiceConfigValue(serviceConfig, USE_SSL);
        if (Boolean.parseBoolean(sslEnabled)) {
            scheme = "https";
            port = this.getRoleConfigValue(roleConfig, HTTPS_PORT);
        } else {
            scheme = "http";
            port = this.getRoleConfigValue(roleConfig, HTTP_PORT);
        }
        ServiceModel model = this.createServiceModel(String.format(Locale.getDefault(), "%s://%s:%s/solr/", scheme, hostname, port));
        model.addServiceProperty(USE_SSL, sslEnabled);
        model.addRoleProperty(this.getRoleType(), HTTP_PORT, this.getRoleConfigValue(roleConfig, HTTP_PORT));
        model.addRoleProperty(this.getRoleType(), HTTPS_PORT, this.getRoleConfigValue(roleConfig, HTTPS_PORT));
        model.addQualifyingServiceParam(DISCOVERY_SERVICE_NAME, service.getName());
        model.addQualifyingServiceParam(DISCOVERY_SERVICE_DISPLAY_NAME, service.getDisplayName());
        return model;
    }
}

