/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.kylin.query.util

import org.apache.kylin.common.state.StateSwitchConstant
import org.apache.kylin.metadata.state.QueryShareStateManager
import org.slf4j.{Logger, LoggerFactory}

// scalastyle:off
object SparkQueryJobManager {
  val logger: Logger = LoggerFactory.getLogger(classOf[SparkQueryJobManager])

  def isNewBigQueryRefuse: Boolean = {
    val stateValue = QueryShareStateManager.getInstance().getState(StateSwitchConstant.QUERY_LIMIT_STATE)
    if ("true".equals(stateValue)) {
      return true
    }
    false
  }

}

class SparkQueryJobManager
