/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.tests.index;

import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Random;
import java.util.concurrent.CountDownLatch;
import java.util.function.LongSupplier;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.NumericDocValuesField;
import org.apache.lucene.document.StringField;
import org.apache.lucene.document.TextField;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.FieldInvertState;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.MergePolicy;
import org.apache.lucene.index.MultiDocValues;
import org.apache.lucene.index.NoMergePolicy;
import org.apache.lucene.index.NumericDocValues;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.CollectionStatistics;
import org.apache.lucene.search.TermStatistics;
import org.apache.lucene.search.similarities.Similarity;
import org.apache.lucene.store.Directory;
import org.apache.lucene.tests.analysis.MockAnalyzer;
import org.apache.lucene.tests.analysis.MockTokenizer;
import org.apache.lucene.tests.index.BaseIndexFileFormatTestCase;
import org.apache.lucene.tests.index.RandomIndexWriter;
import org.apache.lucene.tests.store.BaseDirectoryWrapper;
import org.apache.lucene.tests.util.LuceneTestCase;
import org.apache.lucene.tests.util.TestUtil;
import org.apache.lucene.util.FixedBitSet;
import org.apache.lucene.util.IOUtils;

public abstract class BaseNormsFormatTestCase
extends BaseIndexFileFormatTestCase {
    protected boolean codecSupportsSparsity() {
        return true;
    }

    public void testByteRange() throws Exception {
        int iterations = BaseNormsFormatTestCase.atLeast(1);
        final Random r = BaseNormsFormatTestCase.random();
        for (int i = 0; i < iterations; ++i) {
            this.doTestNormsVersusDocValues(1.0, new LongSupplier(){

                @Override
                public long getAsLong() {
                    return TestUtil.nextLong(r, -128L, 127L);
                }
            });
        }
    }

    public void testSparseByteRange() throws Exception {
        BaseNormsFormatTestCase.assumeTrue("Requires sparse norms support", this.codecSupportsSparsity());
        int iterations = BaseNormsFormatTestCase.atLeast(1);
        final Random r = BaseNormsFormatTestCase.random();
        for (int i = 0; i < iterations; ++i) {
            this.doTestNormsVersusDocValues(BaseNormsFormatTestCase.random().nextDouble(), new LongSupplier(){

                @Override
                public long getAsLong() {
                    return TestUtil.nextLong(r, -128L, 127L);
                }
            });
        }
    }

    public void testShortRange() throws Exception {
        int iterations = BaseNormsFormatTestCase.atLeast(1);
        final Random r = BaseNormsFormatTestCase.random();
        for (int i = 0; i < iterations; ++i) {
            this.doTestNormsVersusDocValues(1.0, new LongSupplier(){

                @Override
                public long getAsLong() {
                    return TestUtil.nextLong(r, -32768L, 32767L);
                }
            });
        }
    }

    public void testSparseShortRange() throws Exception {
        BaseNormsFormatTestCase.assumeTrue("Requires sparse norms support", this.codecSupportsSparsity());
        int iterations = BaseNormsFormatTestCase.atLeast(1);
        final Random r = BaseNormsFormatTestCase.random();
        for (int i = 0; i < iterations; ++i) {
            this.doTestNormsVersusDocValues(BaseNormsFormatTestCase.random().nextDouble(), new LongSupplier(){

                @Override
                public long getAsLong() {
                    return TestUtil.nextLong(r, -32768L, 32767L);
                }
            });
        }
    }

    public void testLongRange() throws Exception {
        int iterations = BaseNormsFormatTestCase.atLeast(1);
        final Random r = BaseNormsFormatTestCase.random();
        for (int i = 0; i < iterations; ++i) {
            this.doTestNormsVersusDocValues(1.0, new LongSupplier(){

                @Override
                public long getAsLong() {
                    return TestUtil.nextLong(r, Long.MIN_VALUE, Long.MAX_VALUE);
                }
            });
        }
    }

    public void testSparseLongRange() throws Exception {
        BaseNormsFormatTestCase.assumeTrue("Requires sparse norms support", this.codecSupportsSparsity());
        int iterations = BaseNormsFormatTestCase.atLeast(1);
        final Random r = BaseNormsFormatTestCase.random();
        for (int i = 0; i < iterations; ++i) {
            this.doTestNormsVersusDocValues(BaseNormsFormatTestCase.random().nextDouble(), new LongSupplier(){

                @Override
                public long getAsLong() {
                    return TestUtil.nextLong(r, Long.MIN_VALUE, Long.MAX_VALUE);
                }
            });
        }
    }

    public void testFullLongRange() throws Exception {
        int iterations = BaseNormsFormatTestCase.atLeast(1);
        final Random r = BaseNormsFormatTestCase.random();
        for (int i = 0; i < iterations; ++i) {
            this.doTestNormsVersusDocValues(1.0, new LongSupplier(){

                @Override
                public long getAsLong() {
                    int thingToDo = r.nextInt(3);
                    switch (thingToDo) {
                        case 0: {
                            return Long.MIN_VALUE;
                        }
                        case 1: {
                            return Long.MAX_VALUE;
                        }
                    }
                    return TestUtil.nextLong(r, Long.MIN_VALUE, Long.MAX_VALUE);
                }
            });
        }
    }

    public void testSparseFullLongRange() throws Exception {
        BaseNormsFormatTestCase.assumeTrue("Requires sparse norms support", this.codecSupportsSparsity());
        int iterations = BaseNormsFormatTestCase.atLeast(1);
        final Random r = BaseNormsFormatTestCase.random();
        for (int i = 0; i < iterations; ++i) {
            this.doTestNormsVersusDocValues(BaseNormsFormatTestCase.random().nextDouble(), new LongSupplier(){

                @Override
                public long getAsLong() {
                    int thingToDo = r.nextInt(3);
                    switch (thingToDo) {
                        case 0: {
                            return Long.MIN_VALUE;
                        }
                        case 1: {
                            return Long.MAX_VALUE;
                        }
                    }
                    return TestUtil.nextLong(r, Long.MIN_VALUE, Long.MAX_VALUE);
                }
            });
        }
    }

    public void testFewValues() throws Exception {
        int iterations = BaseNormsFormatTestCase.atLeast(1);
        final Random r = BaseNormsFormatTestCase.random();
        for (int i = 0; i < iterations; ++i) {
            this.doTestNormsVersusDocValues(1.0, new LongSupplier(){

                @Override
                public long getAsLong() {
                    return r.nextBoolean() ? 20L : 3L;
                }
            });
        }
    }

    public void testFewSparseValues() throws Exception {
        BaseNormsFormatTestCase.assumeTrue("Requires sparse norms support", this.codecSupportsSparsity());
        int iterations = BaseNormsFormatTestCase.atLeast(1);
        final Random r = BaseNormsFormatTestCase.random();
        for (int i = 0; i < iterations; ++i) {
            this.doTestNormsVersusDocValues(BaseNormsFormatTestCase.random().nextDouble(), new LongSupplier(){

                @Override
                public long getAsLong() {
                    return r.nextBoolean() ? 20L : 3L;
                }
            });
        }
    }

    public void testFewLargeValues() throws Exception {
        int iterations = BaseNormsFormatTestCase.atLeast(1);
        final Random r = BaseNormsFormatTestCase.random();
        for (int i = 0; i < iterations; ++i) {
            this.doTestNormsVersusDocValues(1.0, new LongSupplier(){

                @Override
                public long getAsLong() {
                    return r.nextBoolean() ? 1000000L : -5000L;
                }
            });
        }
    }

    public void testFewSparseLargeValues() throws Exception {
        BaseNormsFormatTestCase.assumeTrue("Requires sparse norms support", this.codecSupportsSparsity());
        int iterations = BaseNormsFormatTestCase.atLeast(1);
        final Random r = BaseNormsFormatTestCase.random();
        for (int i = 0; i < iterations; ++i) {
            this.doTestNormsVersusDocValues(BaseNormsFormatTestCase.random().nextDouble(), new LongSupplier(){

                @Override
                public long getAsLong() {
                    return r.nextBoolean() ? 1000000L : -5000L;
                }
            });
        }
    }

    public void testAllZeros() throws Exception {
        int iterations = BaseNormsFormatTestCase.atLeast(1);
        for (int i = 0; i < iterations; ++i) {
            this.doTestNormsVersusDocValues(1.0, new LongSupplier(this){

                @Override
                public long getAsLong() {
                    return 0L;
                }
            });
        }
    }

    public void testSparseAllZeros() throws Exception {
        BaseNormsFormatTestCase.assumeTrue("Requires sparse norms support", this.codecSupportsSparsity());
        int iterations = BaseNormsFormatTestCase.atLeast(1);
        for (int i = 0; i < iterations; ++i) {
            this.doTestNormsVersusDocValues(BaseNormsFormatTestCase.random().nextDouble(), new LongSupplier(this){

                @Override
                public long getAsLong() {
                    return 0L;
                }
            });
        }
    }

    public void testMostZeros() throws Exception {
        int iterations = BaseNormsFormatTestCase.atLeast(1);
        final Random r = BaseNormsFormatTestCase.random();
        for (int i = 0; i < iterations; ++i) {
            this.doTestNormsVersusDocValues(1.0, new LongSupplier(){

                @Override
                public long getAsLong() {
                    return r.nextInt(100) == 0 ? TestUtil.nextLong(r, -128L, 127L) : 0L;
                }
            });
        }
    }

    public void testOutliers() throws Exception {
        int iterations = BaseNormsFormatTestCase.atLeast(1);
        final Random r = BaseNormsFormatTestCase.random();
        for (int i = 0; i < iterations; ++i) {
            final long commonValue = TestUtil.nextLong(r, -128L, 127L);
            this.doTestNormsVersusDocValues(1.0, new LongSupplier(){

                @Override
                public long getAsLong() {
                    return r.nextInt(100) == 0 ? TestUtil.nextLong(r, -128L, 127L) : commonValue;
                }
            });
        }
    }

    public void testSparseOutliers() throws Exception {
        BaseNormsFormatTestCase.assumeTrue("Requires sparse norms support", this.codecSupportsSparsity());
        int iterations = BaseNormsFormatTestCase.atLeast(1);
        final Random r = BaseNormsFormatTestCase.random();
        for (int i = 0; i < iterations; ++i) {
            final long commonValue = TestUtil.nextLong(r, -128L, 127L);
            this.doTestNormsVersusDocValues(BaseNormsFormatTestCase.random().nextDouble(), new LongSupplier(){

                @Override
                public long getAsLong() {
                    return r.nextInt(100) == 0 ? TestUtil.nextLong(r, -128L, 127L) : commonValue;
                }
            });
        }
    }

    public void testOutliers2() throws Exception {
        int iterations = BaseNormsFormatTestCase.atLeast(1);
        final Random r = BaseNormsFormatTestCase.random();
        for (int i = 0; i < iterations; ++i) {
            final long commonValue = TestUtil.nextLong(r, -128L, 127L);
            final long uncommonValue = TestUtil.nextLong(r, -128L, 127L);
            this.doTestNormsVersusDocValues(1.0, new LongSupplier(){

                @Override
                public long getAsLong() {
                    return r.nextInt(100) == 0 ? uncommonValue : commonValue;
                }
            });
        }
    }

    public void testSparseOutliers2() throws Exception {
        BaseNormsFormatTestCase.assumeTrue("Requires sparse norms support", this.codecSupportsSparsity());
        int iterations = BaseNormsFormatTestCase.atLeast(1);
        final Random r = BaseNormsFormatTestCase.random();
        for (int i = 0; i < iterations; ++i) {
            final long commonValue = TestUtil.nextLong(r, -128L, 127L);
            final long uncommonValue = TestUtil.nextLong(r, -128L, 127L);
            this.doTestNormsVersusDocValues(BaseNormsFormatTestCase.random().nextDouble(), new LongSupplier(){

                @Override
                public long getAsLong() {
                    return r.nextInt(100) == 0 ? uncommonValue : commonValue;
                }
            });
        }
    }

    public void testNCommon() throws Exception {
        final Random r = BaseNormsFormatTestCase.random();
        final int N = TestUtil.nextInt(r, 2, 15);
        final long[] commonValues = new long[N];
        for (int j = 0; j < N; ++j) {
            commonValues[j] = TestUtil.nextLong(r, -128L, 127L);
        }
        final int numOtherValues = TestUtil.nextInt(r, 2, 256 - N);
        final long[] otherValues = new long[numOtherValues];
        for (int j = 0; j < numOtherValues; ++j) {
            otherValues[j] = TestUtil.nextLong(r, -128L, 127L);
        }
        this.doTestNormsVersusDocValues(1.0, new LongSupplier(){

            @Override
            public long getAsLong() {
                return r.nextInt(100) == 0 ? otherValues[r.nextInt(numOtherValues - 1)] : commonValues[r.nextInt(N - 1)];
            }
        });
    }

    public void testSparseNCommon() throws Exception {
        BaseNormsFormatTestCase.assumeTrue("Requires sparse norms support", this.codecSupportsSparsity());
        final Random r = BaseNormsFormatTestCase.random();
        final int N = TestUtil.nextInt(r, 2, 15);
        final long[] commonValues = new long[N];
        for (int j = 0; j < N; ++j) {
            commonValues[j] = TestUtil.nextLong(r, -128L, 127L);
        }
        final int numOtherValues = TestUtil.nextInt(r, 2, 256 - N);
        final long[] otherValues = new long[numOtherValues];
        for (int j = 0; j < numOtherValues; ++j) {
            otherValues[j] = TestUtil.nextLong(r, -128L, 127L);
        }
        this.doTestNormsVersusDocValues(BaseNormsFormatTestCase.random().nextDouble(), new LongSupplier(){

            @Override
            public long getAsLong() {
                return r.nextInt(100) == 0 ? otherValues[r.nextInt(numOtherValues - 1)] : commonValues[r.nextInt(N - 1)];
            }
        });
    }

    @LuceneTestCase.Nightly
    public void testNCommonBig() throws Exception {
        int iterations = BaseNormsFormatTestCase.atLeast(1);
        final Random r = BaseNormsFormatTestCase.random();
        for (int i = 0; i < iterations; ++i) {
            for (int n = 2; n < 16; ++n) {
                final int N = n;
                final long[] commonValues = new long[N];
                for (int j = 0; j < N; ++j) {
                    commonValues[j] = TestUtil.nextLong(r, -128L, 127L);
                }
                final int numOtherValues = TestUtil.nextInt(r, 2, 256 - N);
                final long[] otherValues = new long[numOtherValues];
                for (int j = 0; j < numOtherValues; ++j) {
                    otherValues[j] = TestUtil.nextLong(r, -128L, 127L);
                }
                this.doTestNormsVersusDocValues(1.0, new LongSupplier(){

                    @Override
                    public long getAsLong() {
                        return r.nextInt(100) == 0 ? otherValues[r.nextInt(numOtherValues - 1)] : commonValues[r.nextInt(N - 1)];
                    }
                });
            }
        }
    }

    @LuceneTestCase.Nightly
    public void testSparseNCommonBig() throws Exception {
        BaseNormsFormatTestCase.assumeTrue("Requires sparse norms support", this.codecSupportsSparsity());
        int iterations = BaseNormsFormatTestCase.atLeast(1);
        final Random r = BaseNormsFormatTestCase.random();
        for (int i = 0; i < iterations; ++i) {
            for (int n = 2; n < 16; ++n) {
                final int N = n;
                final long[] commonValues = new long[N];
                for (int j = 0; j < N; ++j) {
                    commonValues[j] = TestUtil.nextLong(r, -128L, 127L);
                }
                final int numOtherValues = TestUtil.nextInt(r, 2, 256 - N);
                final long[] otherValues = new long[numOtherValues];
                for (int j = 0; j < numOtherValues; ++j) {
                    otherValues[j] = TestUtil.nextLong(r, -128L, 127L);
                }
                this.doTestNormsVersusDocValues(BaseNormsFormatTestCase.random().nextDouble(), new LongSupplier(){

                    @Override
                    public long getAsLong() {
                        return r.nextInt(100) == 0 ? otherValues[r.nextInt(numOtherValues - 1)] : commonValues[r.nextInt(N - 1)];
                    }
                });
            }
        }
    }

    private void doTestNormsVersusDocValues(double density, LongSupplier longs) throws Exception {
        int numDocs = BaseNormsFormatTestCase.atLeast(500);
        FixedBitSet docsWithField = new FixedBitSet(numDocs);
        int numDocsWithField = Math.max(1, (int)(density * (double)numDocs));
        if (numDocsWithField == numDocs) {
            docsWithField.set(0, numDocs);
        } else {
            int i = 0;
            while (i < numDocsWithField) {
                int doc = BaseNormsFormatTestCase.random().nextInt(numDocs);
                if (docsWithField.get(doc)) continue;
                docsWithField.set(doc);
                ++i;
            }
        }
        long[] norms = new long[numDocsWithField];
        for (int i = 0; i < numDocsWithField; ++i) {
            norms[i] = longs.getAsLong();
        }
        BaseDirectoryWrapper dir = this.applyCreatedVersionMajor(BaseNormsFormatTestCase.newDirectory());
        MockAnalyzer analyzer = new MockAnalyzer(BaseNormsFormatTestCase.random(), MockTokenizer.WHITESPACE, false);
        IndexWriterConfig conf = BaseNormsFormatTestCase.newIndexWriterConfig(analyzer);
        CannedNormSimilarity sim = new CannedNormSimilarity(norms);
        conf.setSimilarity((Similarity)sim);
        RandomIndexWriter writer = new RandomIndexWriter(BaseNormsFormatTestCase.random(), (Directory)dir, conf);
        Document doc = new Document();
        StringField idField = new StringField("id", "", Field.Store.NO);
        TextField indexedField = new TextField("indexed", "", Field.Store.NO);
        NumericDocValuesField dvField = new NumericDocValuesField("dv", 0L);
        doc.add((IndexableField)idField);
        doc.add((IndexableField)indexedField);
        doc.add((IndexableField)dvField);
        int j = 0;
        for (int i = 0; i < numDocs; ++i) {
            idField.setStringValue(Integer.toString(i));
            if (!docsWithField.get(i)) {
                Document doc2 = new Document();
                doc2.add((IndexableField)idField);
                writer.addDocument(doc2);
            } else {
                long value = norms[j++];
                dvField.setLongValue(value);
                indexedField.setStringValue(value == 0L ? "" : "a");
                writer.addDocument(doc);
            }
            if (BaseNormsFormatTestCase.random().nextInt(31) != 0) continue;
            writer.commit();
        }
        int numDeletions = BaseNormsFormatTestCase.random().nextInt(numDocs / 20);
        for (int i = 0; i < numDeletions; ++i) {
            int id = BaseNormsFormatTestCase.random().nextInt(numDocs);
            writer.deleteDocuments(new Term("id", Integer.toString(id)));
        }
        writer.commit();
        DirectoryReader ir = this.maybeWrapWithMergingReader(DirectoryReader.open((Directory)dir));
        this.checkNormsVsDocValues((IndexReader)ir);
        ir.close();
        writer.forceMerge(1);
        ir = this.maybeWrapWithMergingReader(DirectoryReader.open((Directory)dir));
        this.checkNormsVsDocValues((IndexReader)ir);
        writer.close();
        ir.close();
        dir.close();
    }

    private void checkNormsVsDocValues(IndexReader ir) throws IOException {
        for (LeafReaderContext context : ir.leaves()) {
            LeafReader r = context.reader();
            NumericDocValues expected = r.getNumericDocValues("dv");
            NumericDocValues actual = r.getNormValues("indexed");
            BaseNormsFormatTestCase.assertEquals((Object)(expected == null ? 1 : 0), (Object)(actual == null ? 1 : 0));
            if (expected == null) continue;
            int d = expected.nextDoc();
            while (d != Integer.MAX_VALUE) {
                BaseNormsFormatTestCase.assertEquals((long)d, (long)actual.nextDoc());
                BaseNormsFormatTestCase.assertEquals((String)("doc " + d), (long)expected.longValue(), (long)actual.longValue());
                d = expected.nextDoc();
            }
            BaseNormsFormatTestCase.assertEquals((long)Integer.MAX_VALUE, (long)actual.nextDoc());
        }
    }

    @Override
    protected void addRandomFields(Document doc) {
        doc.add((IndexableField)new TextField("foobar", TestUtil.randomSimpleString(BaseNormsFormatTestCase.random()), Field.Store.NO));
    }

    @Override
    public void testMergeStability() throws Exception {
        BaseNormsFormatTestCase.assumeTrue("The MockRandom PF randomizes content on the fly, so we can't check it", false);
    }

    public void testUndeadNorms() throws Exception {
        BaseDirectoryWrapper dir = this.applyCreatedVersionMajor(BaseNormsFormatTestCase.newDirectory());
        RandomIndexWriter w = new RandomIndexWriter(BaseNormsFormatTestCase.random(), (Directory)dir);
        int numDocs = BaseNormsFormatTestCase.atLeast(500);
        ArrayList<Integer> toDelete = new ArrayList<Integer>();
        for (int i = 0; i < numDocs; ++i) {
            Document doc = new Document();
            doc.add((IndexableField)new StringField("id", "" + i, Field.Store.NO));
            if (BaseNormsFormatTestCase.random().nextInt(5) == 1) {
                toDelete.add(i);
                doc.add((IndexableField)new TextField("content", "some content", Field.Store.NO));
            }
            w.addDocument(doc);
        }
        for (Integer id : toDelete) {
            w.deleteDocuments(new Term("id", "" + id));
        }
        w.forceMerge(1);
        DirectoryReader r = this.maybeWrapWithMergingReader(w.getReader());
        BaseNormsFormatTestCase.assertFalse((boolean)r.hasDeletions());
        NumericDocValues norms = MultiDocValues.getNormValues((IndexReader)r, (String)"content");
        BaseNormsFormatTestCase.assertNotNull((Object)norms);
        if (this.codecSupportsSparsity()) {
            BaseNormsFormatTestCase.assertEquals((long)Integer.MAX_VALUE, (long)norms.nextDoc());
        } else {
            for (int i = 0; i < r.maxDoc(); ++i) {
                BaseNormsFormatTestCase.assertEquals((long)i, (long)norms.nextDoc());
                BaseNormsFormatTestCase.assertEquals((long)0L, (long)norms.longValue());
            }
        }
        r.close();
        w.close();
        dir.close();
    }

    public void testThreads() throws Exception {
        float density = !this.codecSupportsSparsity() || BaseNormsFormatTestCase.random().nextBoolean() ? 1.0f : BaseNormsFormatTestCase.random().nextFloat();
        int numDocs = BaseNormsFormatTestCase.atLeast(500);
        FixedBitSet docsWithField = new FixedBitSet(numDocs);
        int numDocsWithField = Math.max(1, (int)(density * (float)numDocs));
        if (numDocsWithField == numDocs) {
            docsWithField.set(0, numDocs);
        } else {
            int i = 0;
            while (i < numDocsWithField) {
                int doc = BaseNormsFormatTestCase.random().nextInt(numDocs);
                if (docsWithField.get(doc)) continue;
                docsWithField.set(doc);
                ++i;
            }
        }
        long[] norms = new long[numDocsWithField];
        for (int i = 0; i < numDocsWithField; ++i) {
            norms[i] = BaseNormsFormatTestCase.random().nextLong();
        }
        BaseDirectoryWrapper dir = this.applyCreatedVersionMajor(BaseNormsFormatTestCase.newDirectory());
        MockAnalyzer analyzer = new MockAnalyzer(BaseNormsFormatTestCase.random(), MockTokenizer.WHITESPACE, false);
        IndexWriterConfig conf = BaseNormsFormatTestCase.newIndexWriterConfig(analyzer);
        conf.setMergePolicy(NoMergePolicy.INSTANCE);
        conf.setSimilarity((Similarity)new CannedNormSimilarity(norms));
        RandomIndexWriter writer = new RandomIndexWriter(BaseNormsFormatTestCase.random(), (Directory)dir, conf);
        Document doc = new Document();
        StringField idField = new StringField("id", "", Field.Store.NO);
        TextField indexedField = new TextField("indexed", "", Field.Store.NO);
        NumericDocValuesField dvField = new NumericDocValuesField("dv", 0L);
        doc.add((IndexableField)idField);
        doc.add((IndexableField)indexedField);
        doc.add((IndexableField)dvField);
        int j = 0;
        for (int i = 0; i < numDocs; ++i) {
            idField.setStringValue(Integer.toString(i));
            if (!docsWithField.get(i)) {
                Document doc2 = new Document();
                doc2.add((IndexableField)idField);
                writer.addDocument(doc2);
            } else {
                long value = norms[j++];
                dvField.setLongValue(value);
                indexedField.setStringValue(value == 0L ? "" : "a");
                writer.addDocument(doc);
            }
            if (BaseNormsFormatTestCase.random().nextInt(31) != 0) continue;
            writer.commit();
        }
        final DirectoryReader reader = this.maybeWrapWithMergingReader(writer.getReader());
        writer.close();
        int numThreads = TestUtil.nextInt(BaseNormsFormatTestCase.random(), 3, 30);
        Thread[] threads = new Thread[numThreads];
        final CountDownLatch latch = new CountDownLatch(1);
        for (int i = 0; i < numThreads; ++i) {
            threads[i] = new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        latch.await();
                        BaseNormsFormatTestCase.this.checkNormsVsDocValues((IndexReader)reader);
                        TestUtil.checkReader((IndexReader)reader);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }
        for (Thread thread : threads) {
            thread.start();
        }
        latch.countDown();
        for (Thread thread : threads) {
            thread.join();
        }
        reader.close();
        dir.close();
    }

    public void testIndependantIterators() throws IOException {
        BaseDirectoryWrapper dir = BaseNormsFormatTestCase.newDirectory();
        IndexWriterConfig conf = BaseNormsFormatTestCase.newIndexWriterConfig().setMergePolicy((MergePolicy)BaseNormsFormatTestCase.newLogMergePolicy());
        CannedNormSimilarity sim = new CannedNormSimilarity(new long[]{42L, 10L, 20L});
        conf.setSimilarity((Similarity)sim);
        RandomIndexWriter writer = new RandomIndexWriter(BaseNormsFormatTestCase.random(), (Directory)dir, conf);
        Document doc = new Document();
        TextField indexedField = new TextField("indexed", "a", Field.Store.NO);
        doc.add((IndexableField)indexedField);
        for (int i = 0; i < 3; ++i) {
            writer.addDocument(doc);
        }
        writer.forceMerge(1);
        LeafReader r = BaseNormsFormatTestCase.getOnlyLeafReader((IndexReader)this.maybeWrapWithMergingReader(writer.getReader()));
        NumericDocValues n1 = r.getNormValues("indexed");
        NumericDocValues n2 = r.getNormValues("indexed");
        BaseNormsFormatTestCase.assertEquals((long)0L, (long)n1.nextDoc());
        BaseNormsFormatTestCase.assertEquals((long)42L, (long)n1.longValue());
        BaseNormsFormatTestCase.assertEquals((long)1L, (long)n1.nextDoc());
        BaseNormsFormatTestCase.assertEquals((long)10L, (long)n1.longValue());
        BaseNormsFormatTestCase.assertEquals((long)0L, (long)n2.nextDoc());
        BaseNormsFormatTestCase.assertEquals((long)42L, (long)n2.longValue());
        BaseNormsFormatTestCase.assertEquals((long)1L, (long)n2.nextDoc());
        BaseNormsFormatTestCase.assertEquals((long)10L, (long)n2.longValue());
        BaseNormsFormatTestCase.assertEquals((long)2L, (long)n2.nextDoc());
        BaseNormsFormatTestCase.assertEquals((long)20L, (long)n2.longValue());
        BaseNormsFormatTestCase.assertEquals((long)2L, (long)n1.nextDoc());
        BaseNormsFormatTestCase.assertEquals((long)20L, (long)n1.longValue());
        BaseNormsFormatTestCase.assertEquals((long)Integer.MAX_VALUE, (long)n1.nextDoc());
        BaseNormsFormatTestCase.assertEquals((long)Integer.MAX_VALUE, (long)n2.nextDoc());
        IOUtils.close((Closeable[])new Closeable[]{r, writer, dir});
    }

    public void testIndependantSparseIterators() throws IOException {
        BaseDirectoryWrapper dir = BaseNormsFormatTestCase.newDirectory();
        IndexWriterConfig conf = BaseNormsFormatTestCase.newIndexWriterConfig().setMergePolicy((MergePolicy)BaseNormsFormatTestCase.newLogMergePolicy());
        CannedNormSimilarity sim = new CannedNormSimilarity(new long[]{42L, 10L, 20L});
        conf.setSimilarity((Similarity)sim);
        RandomIndexWriter writer = new RandomIndexWriter(BaseNormsFormatTestCase.random(), (Directory)dir, conf);
        Document doc = new Document();
        TextField indexedField = new TextField("indexed", "a", Field.Store.NO);
        doc.add((IndexableField)indexedField);
        Document emptyDoc = new Document();
        for (int i = 0; i < 3; ++i) {
            writer.addDocument(doc);
            writer.addDocument(emptyDoc);
        }
        writer.forceMerge(1);
        LeafReader r = BaseNormsFormatTestCase.getOnlyLeafReader((IndexReader)this.maybeWrapWithMergingReader(writer.getReader()));
        NumericDocValues n1 = r.getNormValues("indexed");
        NumericDocValues n2 = r.getNormValues("indexed");
        BaseNormsFormatTestCase.assertEquals((long)0L, (long)n1.nextDoc());
        BaseNormsFormatTestCase.assertEquals((long)42L, (long)n1.longValue());
        BaseNormsFormatTestCase.assertEquals((long)2L, (long)n1.nextDoc());
        BaseNormsFormatTestCase.assertEquals((long)10L, (long)n1.longValue());
        BaseNormsFormatTestCase.assertEquals((long)0L, (long)n2.nextDoc());
        BaseNormsFormatTestCase.assertEquals((long)42L, (long)n2.longValue());
        BaseNormsFormatTestCase.assertEquals((long)2L, (long)n2.nextDoc());
        BaseNormsFormatTestCase.assertEquals((long)10L, (long)n2.longValue());
        BaseNormsFormatTestCase.assertEquals((long)4L, (long)n2.nextDoc());
        BaseNormsFormatTestCase.assertEquals((long)20L, (long)n2.longValue());
        BaseNormsFormatTestCase.assertEquals((long)4L, (long)n1.nextDoc());
        BaseNormsFormatTestCase.assertEquals((long)20L, (long)n1.longValue());
        BaseNormsFormatTestCase.assertEquals((long)Integer.MAX_VALUE, (long)n1.nextDoc());
        BaseNormsFormatTestCase.assertEquals((long)Integer.MAX_VALUE, (long)n2.nextDoc());
        IOUtils.close((Closeable[])new Closeable[]{r, writer, dir});
    }

    static class CannedNormSimilarity
    extends Similarity {
        final long[] norms;
        int index = 0;

        CannedNormSimilarity(long[] norms) {
            this.norms = norms;
        }

        public long computeNorm(FieldInvertState state) {
            long norm;
            assert (state.getLength() > 0);
            while ((norm = this.norms[this.index++]) == 0L) {
            }
            return norm;
        }

        public Similarity.SimScorer scorer(float boost, CollectionStatistics collectionStats, TermStatistics ... termStats) {
            throw new UnsupportedOperationException();
        }
    }
}

