/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.coverage.grid;

import java.awt.image.RenderedImage;
import java.util.Arrays;
import org.apache.sis.coverage.BandedCoverage;
import org.apache.sis.coverage.CannotEvaluateException;
import org.apache.sis.coverage.PointOutsideCoverageException;
import org.apache.sis.coverage.grid.DisjointExtentException;
import org.apache.sis.coverage.grid.FractionalGridCoordinates;
import org.apache.sis.coverage.grid.GridCoverage;
import org.apache.sis.coverage.grid.GridExtent;
import org.apache.sis.coverage.grid.GridGeometry;
import org.apache.sis.internal.coverage.j2d.ImageUtilities;
import org.apache.sis.referencing.CRS;
import org.apache.sis.referencing.operation.transform.MathTransforms;
import org.apache.sis.util.ArgumentChecks;
import org.opengis.geometry.DirectPosition;
import org.opengis.metadata.extent.GeographicBoundingBox;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.datum.PixelInCell;
import org.opengis.referencing.operation.CoordinateOperation;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.TransformException;
import org.opengis.util.FactoryException;

public class GridEvaluator
implements BandedCoverage.Evaluator {
    private final GridCoverage coverage;
    private CoordinateReferenceSystem sourceCRS;
    private MathTransform crsToGrid;
    private FractionalGridCoordinates.Position position;
    double[] values;
    private boolean nullIfOutside;

    protected GridEvaluator(GridCoverage gridCoverage) {
        ArgumentChecks.ensureNonNull("coverage", gridCoverage);
        this.coverage = gridCoverage;
    }

    @Override
    public GridCoverage getCoverage() {
        return this.coverage;
    }

    @Override
    public boolean isNullIfOutside() {
        return this.nullIfOutside;
    }

    @Override
    public void setNullIfOutside(boolean bl) {
        this.nullIfOutside = bl;
    }

    @Override
    public double[] apply(DirectPosition directPosition) throws CannotEvaluateException {
        GridGeometry gridGeometry = this.coverage.gridGeometry;
        long[] lArray = new long[gridGeometry.getDimension()];
        Arrays.fill(lArray, 1L);
        try {
            FractionalGridCoordinates.Position position = this.toGridPosition(directPosition);
            try {
                GridExtent gridExtent = position.toExtent(gridGeometry.extent, lArray);
                return this.evaluate(this.coverage.render(gridExtent), 0, 0);
            }
            catch (ArithmeticException | IndexOutOfBoundsException | DisjointExtentException runtimeException) {
                if (this.nullIfOutside) {
                    return null;
                }
                throw (PointOutsideCoverageException)new PointOutsideCoverageException(position.pointOutsideCoverage(gridGeometry.extent)).initCause(runtimeException);
            }
        }
        catch (PointOutsideCoverageException pointOutsideCoverageException) {
            throw pointOutsideCoverageException;
        }
        catch (RuntimeException | TransformException throwable) {
            throw new CannotEvaluateException(throwable.getMessage(), throwable);
        }
    }

    final double[] evaluate(RenderedImage renderedImage, int n, int n2) {
        int n3 = ImageUtilities.pixelToTileX(renderedImage, n);
        int n4 = ImageUtilities.pixelToTileY(renderedImage, n2);
        this.values = renderedImage.getTile(n3, n4).getPixel(n, n2, this.values);
        return this.values;
    }

    public FractionalGridCoordinates toGridCoordinates(DirectPosition directPosition) throws TransformException {
        ArgumentChecks.ensureNonNull("point", directPosition);
        return new FractionalGridCoordinates(this.toGridPosition(directPosition));
    }

    final FractionalGridCoordinates.Position toGridPosition(DirectPosition directPosition) throws TransformException {
        Object object;
        GridGeometry gridGeometry;
        CoordinateReferenceSystem coordinateReferenceSystem = directPosition.getCoordinateReferenceSystem();
        if (coordinateReferenceSystem != this.sourceCRS || this.crsToGrid == null) {
            gridGeometry = this.coverage.getGridGeometry();
            object = gridGeometry.getGridToCRS(PixelInCell.CELL_CENTER).inverse();
            if (coordinateReferenceSystem != null) {
                try {
                    CoordinateOperation coordinateOperation = CRS.findOperation((CoordinateReferenceSystem)coordinateReferenceSystem, (CoordinateReferenceSystem)this.coverage.getCoordinateReferenceSystem(), (GeographicBoundingBox)gridGeometry.geographicBBox());
                    object = MathTransforms.concatenate((MathTransform)coordinateOperation.getMathTransform(), (MathTransform)object);
                }
                catch (FactoryException factoryException) {
                    throw new TransformException(factoryException.getMessage(), (Throwable)factoryException);
                }
            }
            this.position = new FractionalGridCoordinates.Position(object.getTargetDimensions());
            this.crsToGrid = object;
            this.sourceCRS = coordinateReferenceSystem;
        }
        if ((gridGeometry = this.crsToGrid.transform(directPosition, (DirectPosition)this.position)) != this.position) {
            object = gridGeometry.getCoordinate();
            System.arraycopy(object, 0, this.position.coordinates, 0, this.position.coordinates.length);
        }
        return this.position;
    }
}

