/*
 * Decompiled with CFR 0.152.
 */
package com.healthmarketscience.jackcess.util;

import com.healthmarketscience.jackcess.RuntimeIOException;
import com.healthmarketscience.jackcess.Table;
import com.healthmarketscience.jackcess.impl.ColumnImpl;
import com.healthmarketscience.jackcess.util.ColumnMatcher;
import com.healthmarketscience.jackcess.util.SimpleColumnMatcher;
import java.io.IOException;

public class CaseInsensitiveColumnMatcher
implements ColumnMatcher {
    public static final CaseInsensitiveColumnMatcher INSTANCE = new CaseInsensitiveColumnMatcher();

    @Override
    public boolean matches(Table table, String columnName, Object value1, Object value2) {
        if (!table.getColumn(columnName).getType().isTextual()) {
            return SimpleColumnMatcher.INSTANCE.matches(table, columnName, value1, value2);
        }
        try {
            CharSequence cs1 = ColumnImpl.toCharSequence(value1);
            CharSequence cs2 = ColumnImpl.toCharSequence(value2);
            return cs1 == cs2 || cs1 != null && cs2 != null && cs1.toString().equalsIgnoreCase(cs2.toString());
        }
        catch (IOException e) {
            throw new RuntimeIOException("Could not read column " + columnName + " value", e);
        }
    }
}

