/*
 * Decompiled with CFR 0.152.
 */
package org.castor.persist.resolver;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.castor.persist.ProposedEntity;
import org.castor.persist.TransactionContext;
import org.castor.persist.UpdateAndRemovedFlags;
import org.castor.persist.UpdateFlags;
import org.castor.persist.proxy.LazyCGLIB;
import org.castor.persist.proxy.SingleProxy;
import org.castor.persist.resolver.ResolverStrategy;
import org.exolab.castor.jdo.DuplicateIdentityException;
import org.exolab.castor.jdo.ObjectNotFoundException;
import org.exolab.castor.jdo.PersistenceException;
import org.exolab.castor.mapping.AccessMode;
import org.exolab.castor.persist.ClassMolder;
import org.exolab.castor.persist.ClassMolderHelper;
import org.exolab.castor.persist.FieldMolder;
import org.exolab.castor.persist.OID;
import org.exolab.castor.persist.spi.Identity;

public final class PersistanceCapableRelationResolver
implements ResolverStrategy {
    private ClassMolder _classMolder;
    private FieldMolder _fieldMolder;
    private int _fieldIndex;
    private boolean _debug;
    private static final Log LOG = LogFactory.getLog((Class)PersistanceCapableRelationResolver.class);

    public PersistanceCapableRelationResolver(ClassMolder classMolder, FieldMolder fieldMolder, int fieldIndex, boolean debug) {
        this._classMolder = classMolder;
        this._fieldMolder = fieldMolder;
        this._fieldIndex = fieldIndex;
        this._debug = debug;
    }

    public Object create(TransactionContext tx, Object object) {
        Identity fid;
        Identity field = null;
        ClassMolder fieldClassMolder = this._fieldMolder.getFieldClassMolder();
        Object o = this._fieldMolder.getValue(object, tx.getClassLoader());
        if (o != null && (fid = fieldClassMolder.getIdentity(tx, o)) != null) {
            field = fid;
        }
        return field;
    }

    public boolean markCreate(TransactionContext tx, OID oid, Object object) throws PersistenceException {
        boolean updateCache = false;
        ClassMolder fieldClassMolder = this._fieldMolder.getFieldClassMolder();
        Object o = this._fieldMolder.getValue(object, tx.getClassLoader());
        if (o != null) {
            if (this._fieldMolder.isDependent()) {
                if (!tx.isRecorded(o)) {
                    tx.markCreate(fieldClassMolder, o, oid);
                    if (!this._fieldMolder.isStored() && fieldClassMolder.isKeyGenUsed()) {
                        updateCache = true;
                    }
                } else if (!tx.isDepended(oid, o)) {
                    throw new PersistenceException("Dependent object may not change its master. Object: " + o + " new master: " + oid);
                }
            } else if (tx.isAutoStore() && !tx.isRecorded(o)) {
                tx.markCreate(fieldClassMolder, o, null);
                if (!this._fieldMolder.isStored() && fieldClassMolder.isKeyGenUsed()) {
                    updateCache = true;
                }
            }
        }
        return updateCache;
    }

    public UpdateFlags preStore(TransactionContext tx, OID oid, Object object, int timeout, Object field) throws PersistenceException {
        UpdateFlags flags = new UpdateFlags();
        ClassMolder fieldClassMolder = this._fieldMolder.getFieldClassMolder();
        Object value = this._fieldMolder.getValue(object, tx.getClassLoader());
        Identity curIdentity = (Identity)field;
        Identity newIdentity = null;
        if (value != null) {
            newIdentity = fieldClassMolder.getIdentity(tx, value);
            flags.setNewField(newIdentity);
        }
        if (ClassMolderHelper.isEquals(curIdentity, newIdentity)) {
            if (field == null && value != null && this._fieldMolder.isDependent() && !tx.isRecorded(value)) {
                if (this._fieldMolder.isStored() && this._fieldMolder.isCheckDirty()) {
                    flags.setUpdatePersist(true);
                }
                flags.setUpdateCache(true);
                tx.markCreate(fieldClassMolder, value, oid);
            }
            if (!this._debug) {
                return flags;
            }
            if (curIdentity == null) {
                return flags;
            }
            if (value != null && tx.isDeleted(value)) {
                LOG.warn((Object)"Deleted object found!");
                if (this._fieldMolder.isStored() && this._fieldMolder.isCheckDirty()) {
                    flags.setUpdatePersist(true);
                }
                flags.setUpdateCache(true);
                this._fieldMolder.setValue(object, null, tx.getClassLoader());
                return flags;
            }
            if ((tx.isAutoStore() || this._fieldMolder.isDependent()) && value != tx.fetch(fieldClassMolder, curIdentity, null)) {
                throw new DuplicateIdentityException("");
            }
        } else {
            if (this._fieldMolder.isStored() && this._fieldMolder.isCheckDirty()) {
                flags.setUpdatePersist(true);
            }
            flags.setUpdateCache(true);
            if (this._fieldMolder.isDependent()) {
                Object reldel;
                if (curIdentity != null && (reldel = tx.fetch(fieldClassMolder, curIdentity, null)) != null) {
                    tx.delete(reldel);
                }
                if (value != null && !tx.isRecorded(value)) {
                    tx.markCreate(fieldClassMolder, value, oid);
                }
            } else if (tx.isAutoStore()) {
                Object deref;
                if (curIdentity != null && (deref = tx.fetch(fieldClassMolder, curIdentity, null)) != null) {
                    fieldClassMolder.removeRelation(tx, deref, this._classMolder, object);
                }
                if (value != null && !tx.isRecorded(value)) {
                    tx.markCreate(fieldClassMolder, value, null);
                }
            } else {
                Object deref;
                if (curIdentity != null && (deref = tx.fetch(fieldClassMolder, curIdentity, null)) != null) {
                    fieldClassMolder.removeRelation(tx, deref, this._classMolder, object);
                }
                if (value != null && !tx.isRecorded(value) && !this._fieldMolder.isLazy()) {
                    throw new PersistenceException("Object, " + object + ", links to another object, " + value + " that is not loaded/updated/created in this transaction");
                }
            }
        }
        return flags;
    }

    public Object store(TransactionContext tx, Object object, Object field) {
        Identity newField = null;
        if (this._fieldMolder.isStored()) {
            ClassMolder fieldClassMolder = this._fieldMolder.getFieldClassMolder();
            Object value = this._fieldMolder.getValue(object, tx.getClassLoader());
            if (value != null) {
                newField = fieldClassMolder.getIdentity(tx, value);
            }
        }
        return newField;
    }

    public void update(TransactionContext tx, OID oid, Object object, AccessMode suggestedAccessMode, Object field) throws PersistenceException {
        Identity nfield = (Identity)field;
        ClassMolder fieldClassMolder = this._fieldMolder.getFieldClassMolder();
        Object o = this._fieldMolder.getValue(object, tx.getClassLoader());
        if (this._fieldMolder.isDependent()) {
            if (o != null && !tx.isRecorded(o)) {
                tx.markUpdate(fieldClassMolder, o, oid);
            }
            if (nfield != null) {
                ProposedEntity proposedValue = new ProposedEntity(fieldClassMolder);
                tx.load(nfield, proposedValue, suggestedAccessMode);
            }
        } else if (tx.isAutoStore()) {
            if (o != null && !tx.isRecorded(o)) {
                tx.markUpdate(fieldClassMolder, o, null);
            }
            if (nfield != null) {
                ProposedEntity proposedValue = new ProposedEntity(fieldClassMolder);
                tx.load(nfield, proposedValue, suggestedAccessMode);
            }
        }
    }

    public Object updateCache(TransactionContext tx, OID oid, Object object) {
        Identity field = null;
        ClassMolder fieldClassMolder = this._fieldMolder.getFieldClassMolder();
        Object value = this._fieldMolder.getValue(object, tx.getClassLoader());
        if (value != null) {
            boolean hasMaterialized;
            Identity fid = fieldClassMolder.getIdentity(tx, value);
            if (this._fieldMolder.isLazy() && value instanceof LazyCGLIB && !(hasMaterialized = ((LazyCGLIB)value).interceptedHasMaterialized().booleanValue())) {
                fid = fieldClassMolder.getActualIdentity(tx, value);
            }
            if (fid != null) {
                field = fid;
            }
        }
        return field;
    }

    public void markDelete(TransactionContext tx, Object object, Object field) throws PersistenceException {
        Object fobject;
        Object fetched;
        ClassMolder fieldClassMolder = this._fieldMolder.getFieldClassMolder();
        Identity identity = (Identity)field;
        if (identity != null && (fetched = tx.fetch(fieldClassMolder, identity, null)) != null) {
            if (this._fieldMolder.isDependent()) {
                tx.delete(fetched);
            } else {
                fieldClassMolder.removeRelation(tx, fetched, this._classMolder, object);
            }
        }
        if (this._fieldMolder.isDependent() && (fobject = this._fieldMolder.getValue(object, tx.getClassLoader())) != null && tx.isPersistent(fobject)) {
            tx.delete(fobject);
        }
    }

    public void revertObject(TransactionContext tx, OID oid, Object object, Object field) throws PersistenceException {
        ClassMolder fieldClassMolder = this._fieldMolder.getFieldClassMolder();
        if (field != null) {
            Object value = tx.fetch(fieldClassMolder, (Identity)field, null);
            this._fieldMolder.setValue(object, value, tx.getClassLoader());
        } else {
            this._fieldMolder.setValue(object, null, tx.getClassLoader());
        }
    }

    public void expireCache(TransactionContext tx, Object field) throws PersistenceException {
        ClassMolder fieldClassMolder = this._fieldMolder.getFieldClassMolder();
        if (field != null) {
            tx.expireCache(fieldClassMolder, (Identity)field);
        }
    }

    public void load(TransactionContext tx, OID oid, ProposedEntity proposedObject, AccessMode suggestedAccessMode) throws PersistenceException {
        ClassMolder fieldClassMolder = this._fieldMolder.getFieldClassMolder();
        Identity fieldValue = (Identity)proposedObject.getField(this._fieldIndex);
        if (fieldValue != null) {
            Object temp;
            try {
                if (this._fieldMolder.isLazy()) {
                    temp = SingleProxy.getProxy(tx, fieldClassMolder, fieldValue, null, suggestedAccessMode);
                } else {
                    ProposedEntity proposedTemp = new ProposedEntity(fieldClassMolder);
                    temp = tx.load(fieldValue, proposedTemp, suggestedAccessMode);
                }
            }
            catch (ObjectNotFoundException ex) {
                temp = null;
            }
            this._fieldMolder.setValue(proposedObject.getEntity(), temp, tx.getClassLoader());
        } else {
            this._fieldMolder.setValue(proposedObject.getEntity(), null, tx.getClassLoader());
        }
    }

    public Object postCreate(TransactionContext tx, OID oid, Object object, Object field, Identity createdId) {
        return field;
    }

    public UpdateAndRemovedFlags removeRelation(TransactionContext tx, Object object, ClassMolder relatedMolder, Object relatedObject) {
        Object related;
        ClassMolder relatedBaseMolder;
        UpdateAndRemovedFlags flags = new UpdateAndRemovedFlags();
        ClassMolder fieldClassMolder = this._fieldMolder.getFieldClassMolder();
        for (relatedBaseMolder = relatedMolder; fieldClassMolder != relatedBaseMolder && relatedBaseMolder != null; relatedBaseMolder = relatedBaseMolder.getExtends()) {
        }
        if (fieldClassMolder == relatedBaseMolder && (related = this._fieldMolder.getValue(object, tx.getClassLoader())) == relatedObject) {
            this._fieldMolder.setValue(object, null, tx.getClassLoader());
            flags.setUpdateCache(true);
            flags.setUpdatePersist(true);
            flags.setRemoved(true);
        }
        return flags;
    }

    public boolean updateWhenNoTimestampSet(TransactionContext tx, OID oid, Object object, AccessMode suggestedAccessMode) throws PersistenceException {
        boolean updateCache = false;
        ClassMolder fieldClassMolder = this._fieldMolder.getFieldClassMolder();
        Object o = this._fieldMolder.getValue(object, tx.getClassLoader());
        if (o != null) {
            boolean creating;
            if (this._fieldMolder.isDependent()) {
                if (!tx.isRecorded(o)) {
                    tx.markCreate(fieldClassMolder, o, oid);
                    if (!this._fieldMolder.isStored() && fieldClassMolder._isKeyGenUsed) {
                        updateCache = true;
                    }
                }
            } else if (tx.isAutoStore() && !tx.isRecorded(o) && (creating = tx.markUpdate(fieldClassMolder, o, null)) && !this._fieldMolder.isStored() && fieldClassMolder._isKeyGenUsed) {
                updateCache = true;
            }
        }
        return updateCache;
    }
}

