# Source.repeat

Stream a single object repeatedly.

@ref[Source operators](../index.md#source-operators)

## Signature

@apidoc[Source.repeat](Source$) { scala="#repeat[T](element:T):org.apache.pekko.stream.scaladsl.Source[T,org.apache.pekko.NotUsed]" java="#repeat(T)" }

## Description

This source emits a single element repeatedly. It never completes, if you want the stream to be finite you will need to limit it by combining with another operator

See also:

* @ref:[`single`](single.md) Stream a single object once.
* @ref:[`tick`](tick.md) A periodical repetition of an arbitrary object.
* @ref:[`cycle`](cycle.md) Stream iterator in cycled manner.

## Example

This example prints the first 4 elements emitted by `Source.repeat`.

Scala
:  @@snip [snip](/stream-tests/src/test/scala/org/apache/pekko/stream/scaladsl/SourceSpec.scala) { #repeat }

Java
:  @@snip [snip](/stream-tests/src/test/java/org/apache/pekko/stream/javadsl/SourceTest.java) { #repeat }



## Reactive Streams semantics

@@@div { .callout }

**emits** the same value repeatedly when there is demand

**completes** never

@@@

