/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.datanode;

import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.server.datanode.DataNode;
import org.apache.hadoop.hdfs.server.datanode.DataStorage;
import org.apache.hadoop.hdfs.server.datanode.SimulatedFSDataset;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.FsDatasetSpi;
import org.junit.Test;

public class TestDataNodeInitStorage {
    public static final Log LOG = LogFactory.getLog(TestDataNodeInitStorage.class);

    @Test(timeout=60000L)
    public void testDataNodeInitStorage() throws Throwable {
        HdfsConfiguration conf = new HdfsConfiguration();
        SimulatedFsDatasetVerifier.setFactory((Configuration)conf);
        MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(1).build();
        cluster.waitActive();
        cluster.shutdown();
    }

    private static class SimulatedFsDatasetVerifier
    extends SimulatedFSDataset {
        public static void setFactory(Configuration conf) {
            conf.set("dfs.datanode.fsdataset.factory", Factory.class.getName());
        }

        public SimulatedFsDatasetVerifier(DataStorage storage, Configuration conf) {
            super(storage, conf);
            LOG.info((Object)("Assigned DatanodeUuid is " + storage.getDatanodeUuid()));
            assert (storage.getDatanodeUuid() != null);
            assert (storage.getDatanodeUuid().length() != 0);
        }

        static class Factory
        extends FsDatasetSpi.Factory<SimulatedFSDataset> {
            Factory() {
            }

            public SimulatedFsDatasetVerifier newInstance(DataNode datanode, DataStorage storage, Configuration conf) throws IOException {
                return new SimulatedFsDatasetVerifier(storage, conf);
            }

            public boolean isSimulated() {
                return true;
            }
        }
    }
}

