/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.serde2.lazy;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.charset.CharacterCodingException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hive.common.type.HiveDecimal;
import org.apache.hadoop.hive.serde2.io.HiveDecimalWritable;
import org.apache.hadoop.hive.serde2.lazy.ByteArrayRef;
import org.apache.hadoop.hive.serde2.lazy.LazyPrimitive;
import org.apache.hadoop.hive.serde2.lazy.objectinspector.primitive.LazyHiveDecimalObjectInspector;
import org.apache.hadoop.hive.serde2.typeinfo.DecimalTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.HiveDecimalUtils;
import org.apache.hadoop.io.Text;

public class LazyHiveDecimal
extends LazyPrimitive<LazyHiveDecimalObjectInspector, HiveDecimalWritable> {
    private static final Log LOG = LogFactory.getLog(LazyHiveDecimal.class);
    private final int precision;
    private final int scale;
    private static final byte[] nullBytes = new byte[]{0, 0, 0, 0};

    public LazyHiveDecimal(LazyHiveDecimalObjectInspector oi) {
        super(oi);
        DecimalTypeInfo typeInfo = (DecimalTypeInfo)oi.getTypeInfo();
        if (typeInfo == null) {
            throw new RuntimeException("Decimal type used without type params");
        }
        this.precision = typeInfo.precision();
        this.scale = typeInfo.scale();
        this.data = new HiveDecimalWritable();
    }

    public LazyHiveDecimal(LazyHiveDecimal copy) {
        super(copy);
        this.precision = copy.precision;
        this.scale = copy.scale;
        this.data = new HiveDecimalWritable((HiveDecimalWritable)copy.data);
    }

    @Override
    public void init(ByteArrayRef bytes, int start, int length) {
        String byteData = null;
        try {
            byteData = Text.decode((byte[])bytes.getData(), (int)start, (int)length);
        }
        catch (CharacterCodingException e) {
            this.isNull = true;
            LOG.debug((Object)"Data not in the HiveDecimal data type range so converted to null.", (Throwable)e);
            return;
        }
        HiveDecimal dec = HiveDecimal.create((String)byteData);
        dec = this.enforcePrecisionScale(dec);
        if (dec != null) {
            ((HiveDecimalWritable)this.data).set(dec);
            this.isNull = false;
        } else {
            LOG.debug((Object)("Data not in the HiveDecimal data type range so converted to null. Given data is :" + byteData));
            this.isNull = true;
        }
    }

    private HiveDecimal enforcePrecisionScale(HiveDecimal dec) {
        return HiveDecimalUtils.enforcePrecisionScale(dec, this.precision, this.scale);
    }

    @Override
    public HiveDecimalWritable getWritableObject() {
        return (HiveDecimalWritable)this.data;
    }

    public static void writeUTF8(OutputStream outputStream, HiveDecimal hiveDecimal) throws IOException {
        if (hiveDecimal == null) {
            outputStream.write(nullBytes);
        } else {
            ByteBuffer b = Text.encode((String)hiveDecimal.toString());
            outputStream.write(b.array(), 0, b.limit());
        }
    }
}

