/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.hadoop.yarn.api.records.Resource;

public class SchedulerHealth {
    long lastSchedulerRunTime;
    Map<Operation, Resource> lastSchedulerRunDetails = new ConcurrentHashMap<Operation, Resource>();
    Map<Operation, DetailedInformation> schedulerHealthDetails = new ConcurrentHashMap<Operation, DetailedInformation>();
    Map<Operation, Long> schedulerOperationCounts = new ConcurrentHashMap<Operation, Long>();
    Map<Operation, Long> schedulerOperationAggregateCounts = new ConcurrentHashMap<Operation, Long>();

    public SchedulerHealth() {
        for (Operation op : Operation.values()) {
            this.lastSchedulerRunDetails.put(op, Resource.newInstance((int)0, (int)0));
            this.schedulerOperationCounts.put(op, 0L);
            this.schedulerHealthDetails.put(op, new DetailedInformation(0L, null, null, null));
            this.schedulerOperationAggregateCounts.put(op, 0L);
        }
    }

    public void updateAllocation(long timestamp, NodeId nodeId, ContainerId containerId, String queue) {
        DetailedInformation di = new DetailedInformation(timestamp, nodeId, containerId, queue);
        this.schedulerHealthDetails.put(Operation.ALLOCATION, di);
    }

    public void updateRelease(long timestamp, NodeId nodeId, ContainerId containerId, String queue) {
        DetailedInformation di = new DetailedInformation(timestamp, nodeId, containerId, queue);
        this.schedulerHealthDetails.put(Operation.RELEASE, di);
    }

    public void updatePreemption(long timestamp, NodeId nodeId, ContainerId containerId, String queue) {
        DetailedInformation di = new DetailedInformation(timestamp, nodeId, containerId, queue);
        this.schedulerHealthDetails.put(Operation.PREEMPTION, di);
    }

    public void updateReservation(long timestamp, NodeId nodeId, ContainerId containerId, String queue) {
        DetailedInformation di = new DetailedInformation(timestamp, nodeId, containerId, queue);
        this.schedulerHealthDetails.put(Operation.RESERVATION, di);
    }

    public void updateSchedulerRunDetails(long timestamp, Resource allocated, Resource reserved) {
        this.lastSchedulerRunTime = timestamp;
        this.lastSchedulerRunDetails.put(Operation.ALLOCATION, allocated);
        this.lastSchedulerRunDetails.put(Operation.RESERVATION, reserved);
    }

    public void updateSchedulerReleaseDetails(long timestamp, Resource released) {
        this.lastSchedulerRunTime = timestamp;
        this.lastSchedulerRunDetails.put(Operation.RELEASE, released);
    }

    public void updateSchedulerReleaseCounts(long count) {
        this.updateCounts(Operation.RELEASE, count);
    }

    public void updateSchedulerAllocationCounts(long count) {
        this.updateCounts(Operation.ALLOCATION, count);
    }

    public void updateSchedulerReservationCounts(long count) {
        this.updateCounts(Operation.RESERVATION, count);
    }

    public void updateSchedulerFulfilledReservationCounts(long count) {
        this.updateCounts(Operation.FULFILLED_RESERVATION, count);
    }

    public void updateSchedulerPreemptionCounts(long count) {
        this.updateCounts(Operation.PREEMPTION, count);
    }

    private void updateCounts(Operation op, long count) {
        this.schedulerOperationCounts.put(op, count);
        Long tmp = this.schedulerOperationAggregateCounts.get((Object)op);
        this.schedulerOperationAggregateCounts.put(op, tmp + count);
    }

    public long getLastSchedulerRunTime() {
        return this.lastSchedulerRunTime;
    }

    private Resource getResourceDetails(Operation op) {
        return this.lastSchedulerRunDetails.get((Object)op);
    }

    public Resource getResourcesAllocated() {
        return this.getResourceDetails(Operation.ALLOCATION);
    }

    public Resource getResourcesReserved() {
        return this.getResourceDetails(Operation.RESERVATION);
    }

    public Resource getResourcesReleased() {
        return this.getResourceDetails(Operation.RELEASE);
    }

    private DetailedInformation getDetailedInformation(Operation op) {
        return this.schedulerHealthDetails.get((Object)op);
    }

    public DetailedInformation getLastAllocationDetails() {
        return this.getDetailedInformation(Operation.ALLOCATION);
    }

    public DetailedInformation getLastReleaseDetails() {
        return this.getDetailedInformation(Operation.RELEASE);
    }

    public DetailedInformation getLastReservationDetails() {
        return this.getDetailedInformation(Operation.RESERVATION);
    }

    public DetailedInformation getLastPreemptionDetails() {
        return this.getDetailedInformation(Operation.PREEMPTION);
    }

    private Long getOperationCount(Operation op) {
        return this.schedulerOperationCounts.get((Object)op);
    }

    public Long getAllocationCount() {
        return this.getOperationCount(Operation.ALLOCATION);
    }

    public Long getReleaseCount() {
        return this.getOperationCount(Operation.RELEASE);
    }

    public Long getReservationCount() {
        return this.getOperationCount(Operation.RESERVATION);
    }

    public Long getPreemptionCount() {
        return this.getOperationCount(Operation.PREEMPTION);
    }

    private Long getAggregateOperationCount(Operation op) {
        return this.schedulerOperationAggregateCounts.get((Object)op);
    }

    public Long getAggregateAllocationCount() {
        return this.getAggregateOperationCount(Operation.ALLOCATION);
    }

    public Long getAggregateReleaseCount() {
        return this.getAggregateOperationCount(Operation.RELEASE);
    }

    public Long getAggregateReservationCount() {
        return this.getAggregateOperationCount(Operation.RESERVATION);
    }

    public Long getAggregatePreemptionCount() {
        return this.getAggregateOperationCount(Operation.PREEMPTION);
    }

    public Long getAggregateFulFilledReservationsCount() {
        return this.getAggregateOperationCount(Operation.FULFILLED_RESERVATION);
    }

    static enum Operation {
        ALLOCATION,
        RELEASE,
        PREEMPTION,
        RESERVATION,
        FULFILLED_RESERVATION;

    }

    public static class DetailedInformation {
        long timestamp;
        NodeId nodeId;
        ContainerId containerId;
        String queue;

        public DetailedInformation(long timestamp, NodeId nodeId, ContainerId containerId, String queue) {
            this.timestamp = timestamp;
            this.nodeId = nodeId;
            this.containerId = containerId;
            this.queue = queue;
        }

        public long getTimestamp() {
            return this.timestamp;
        }

        public NodeId getNodeId() {
            return this.nodeId;
        }

        public ContainerId getContainerId() {
            return this.containerId;
        }

        public String getQueue() {
            return this.queue;
        }
    }
}

