/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.event;

import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ApplicationSubmissionContext;
import org.apache.hadoop.yarn.api.records.Priority;
import org.apache.hadoop.yarn.api.records.ReservationId;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.SchedulerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.SchedulerEventType;

public class AppAddedSchedulerEvent
extends SchedulerEvent {
    private final ApplicationId applicationId;
    private final String queue;
    private final String user;
    private final ReservationId reservationID;
    private final boolean isAppRecovering;
    private final Priority appPriority;

    public AppAddedSchedulerEvent(ApplicationId applicationId, String queue, String user) {
        this(applicationId, queue, user, false, null, Priority.newInstance((int)0));
    }

    public AppAddedSchedulerEvent(ApplicationId applicationId, String queue, String user, ReservationId reservationID, Priority appPriority) {
        this(applicationId, queue, user, false, reservationID, appPriority);
    }

    public AppAddedSchedulerEvent(String user, ApplicationSubmissionContext submissionContext, boolean isAppRecovering, Priority appPriority) {
        this(submissionContext.getApplicationId(), submissionContext.getQueue(), user, isAppRecovering, submissionContext.getReservationID(), appPriority);
    }

    public AppAddedSchedulerEvent(ApplicationId applicationId, String queue, String user, boolean isAppRecovering, ReservationId reservationID, Priority appPriority) {
        super(SchedulerEventType.APP_ADDED);
        this.applicationId = applicationId;
        this.queue = queue;
        this.user = user;
        this.reservationID = reservationID;
        this.isAppRecovering = isAppRecovering;
        this.appPriority = appPriority;
    }

    public ApplicationId getApplicationId() {
        return this.applicationId;
    }

    public String getQueue() {
        return this.queue;
    }

    public String getUser() {
        return this.user;
    }

    public boolean getIsAppRecovering() {
        return this.isAppRecovering;
    }

    public ReservationId getReservationID() {
        return this.reservationID;
    }

    public Priority getApplicatonPriority() {
        return this.appPriority;
    }
}

