/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.network.shuffle.protocol;

import io.netty.buffer.ByteBuf;
import org.apache.spark.network.protocol.Encoders;
import org.apache.spark.network.shuffle.protocol.BlockTransferMessage;
import org.apache.spark.network.shuffle.protocol.ExecutorShuffleInfo;
import org.spark_project.guava.base.Objects;

public class RegisterExecutor
extends BlockTransferMessage {
    public final String appId;
    public final String execId;
    public final ExecutorShuffleInfo executorInfo;

    public RegisterExecutor(String appId, String execId, ExecutorShuffleInfo executorInfo) {
        this.appId = appId;
        this.execId = execId;
        this.executorInfo = executorInfo;
    }

    @Override
    protected BlockTransferMessage.Type type() {
        return BlockTransferMessage.Type.REGISTER_EXECUTOR;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.appId, this.execId, this.executorInfo});
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("appId", (Object)this.appId).add("execId", (Object)this.execId).add("executorInfo", (Object)this.executorInfo).toString();
    }

    public boolean equals(Object other) {
        if (other != null && other instanceof RegisterExecutor) {
            RegisterExecutor o = (RegisterExecutor)other;
            return Objects.equal((Object)this.appId, (Object)o.appId) && Objects.equal((Object)this.execId, (Object)o.execId) && Objects.equal((Object)this.executorInfo, (Object)o.executorInfo);
        }
        return false;
    }

    public int encodedLength() {
        return Encoders.Strings.encodedLength((String)this.appId) + Encoders.Strings.encodedLength((String)this.execId) + this.executorInfo.encodedLength();
    }

    public void encode(ByteBuf buf) {
        Encoders.Strings.encode((ByteBuf)buf, (String)this.appId);
        Encoders.Strings.encode((ByteBuf)buf, (String)this.execId);
        this.executorInfo.encode(buf);
    }

    public static RegisterExecutor decode(ByteBuf buf) {
        String appId = Encoders.Strings.decode((ByteBuf)buf);
        String execId = Encoders.Strings.decode((ByteBuf)buf);
        ExecutorShuffleInfo executorShuffleInfo = ExecutorShuffleInfo.decode(buf);
        return new RegisterExecutor(appId, execId, executorShuffleInfo);
    }
}

