/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.backend.hadoop.executionengine.tez.util;

import com.google.common.base.Charsets;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.security.TokenCache;
import org.apache.hadoop.security.Credentials;
import org.apache.pig.classification.InterfaceAudience;
import org.codehaus.jackson.JsonParseException;
import org.codehaus.jackson.map.JsonMappingException;
import org.codehaus.jackson.map.ObjectMapper;

@InterfaceAudience.Private
public class SecurityHelper {
    private static Log LOG = LogFactory.getLog(SecurityHelper.class);

    private SecurityHelper() {
    }

    private static void readTokensFromFiles(Configuration conf, Credentials credentials) throws IOException {
        String tokensFileName;
        String binaryTokenFilename = conf.get("mapreduce.job.credentials.binary");
        if (binaryTokenFilename != null) {
            Credentials binary = Credentials.readTokenStorageFile((Path)new Path("file:///" + binaryTokenFilename), (Configuration)conf);
            credentials.addAll(binary);
        }
        if ((tokensFileName = conf.get("mapreduce.job.credentials.json")) != null) {
            LOG.info((Object)("loading user's secret keys from " + tokensFileName));
            String localFileName = new Path(tokensFileName).toUri().getPath();
            boolean json_error = false;
            try {
                ObjectMapper mapper = new ObjectMapper();
                Map nm = (Map)mapper.readValue(new File(localFileName), Map.class);
                for (Map.Entry ent : nm.entrySet()) {
                    credentials.addSecretKey(new Text((String)ent.getKey()), ((String)ent.getValue()).getBytes(Charsets.UTF_8));
                }
            }
            catch (JsonMappingException e) {
                json_error = true;
            }
            catch (JsonParseException e) {
                json_error = true;
            }
            if (json_error) {
                LOG.warn((Object)"couldn't parse Token Cache JSON file with user secret keys");
            }
        }
    }

    public static void populateTokenCache(Configuration conf, Credentials credentials) throws IOException {
        SecurityHelper.readTokensFromFiles(conf, credentials);
        Object[] nameNodes = conf.getStrings("mapreduce.job.hdfs-servers");
        LOG.debug((Object)("adding the following namenodes' delegation tokens:" + Arrays.toString(nameNodes)));
        if (nameNodes != null) {
            Path[] ps = new Path[nameNodes.length];
            for (int i = 0; i < nameNodes.length; ++i) {
                ps[i] = new Path((String)nameNodes[i]);
            }
            TokenCache.obtainTokensForNamenodes((Credentials)credentials, (Path[])ps, (Configuration)conf);
        }
    }
}

