/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.client.impl;

import java.security.SecurityPermission;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import org.apache.accumulo.core.client.Instance;
import org.apache.accumulo.core.client.TableNotFoundException;
import org.apache.accumulo.core.master.state.tables.TableState;
import org.apache.accumulo.core.zookeeper.ZooUtil;
import org.apache.accumulo.fate.zookeeper.ZooCache;

public class Tables {
    private static SecurityPermission TABLES_PERMISSION = new SecurityPermission("tablesPermission");

    private static ZooCache getZooCache(Instance instance) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(TABLES_PERMISSION);
        }
        return ZooCache.getInstance((String)instance.getZooKeepers(), (int)instance.getZooKeepersSessionTimeOut());
    }

    private static SortedMap<String, String> getMap(Instance instance, boolean nameAsKey) {
        ZooCache zc = Tables.getZooCache(instance);
        List tableIds = zc.getChildren(ZooUtil.getRoot(instance) + "/tables");
        TreeMap<String, String> tableMap = new TreeMap<String, String>();
        for (String tableId : tableIds) {
            byte[] tblPath = zc.get(ZooUtil.getRoot(instance) + "/tables" + "/" + tableId + "/name");
            if (tblPath == null) continue;
            if (nameAsKey) {
                tableMap.put(new String(tblPath), tableId);
                continue;
            }
            tableMap.put(tableId, new String(tblPath));
        }
        return tableMap;
    }

    public static String getTableId(Instance instance, String tableName) throws TableNotFoundException {
        String tableId = (String)Tables.getNameToIdMap(instance).get(tableName);
        if (tableId == null) {
            throw new TableNotFoundException(tableId, tableName, null);
        }
        return tableId;
    }

    public static String getTableName(Instance instance, String tableId) throws TableNotFoundException {
        String tableName = (String)Tables.getIdToNameMap(instance).get(tableId);
        if (tableName == null) {
            throw new TableNotFoundException(tableId, tableName, null);
        }
        return tableName;
    }

    public static SortedMap<String, String> getNameToIdMap(Instance instance) {
        return Tables.getMap(instance, true);
    }

    public static SortedMap<String, String> getIdToNameMap(Instance instance) {
        return Tables.getMap(instance, false);
    }

    public static boolean exists(Instance instance, String tableId) {
        ZooCache zc = Tables.getZooCache(instance);
        List tableIds = zc.getChildren(ZooUtil.getRoot(instance) + "/tables");
        return tableIds.contains(tableId);
    }

    public static void clearCache(Instance instance) {
        Tables.getZooCache(instance).clear(ZooUtil.getRoot(instance) + "/tables");
    }

    public static String getPrintableTableNameFromId(Map<String, String> tidToNameMap, String tableId) {
        String tableName = tidToNameMap.get(tableId);
        return tableName == null ? "(ID:" + tableId + ")" : tableName;
    }

    public static String getPrintableTableIdFromName(Map<String, String> nameToIdMap, String tableName) {
        String tableId = nameToIdMap.get(tableName);
        return tableId == null ? "(NAME:" + tableName + ")" : tableId;
    }

    public static TableState getTableState(Instance instance, String tableId) {
        String statePath = ZooUtil.getRoot(instance) + "/tables" + "/" + tableId + "/state";
        ZooCache zc = Tables.getZooCache(instance);
        byte[] state = zc.get(statePath);
        if (state == null) {
            return TableState.UNKNOWN;
        }
        return TableState.valueOf(new String(state));
    }
}

