/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.conf;

import java.util.Map;
import org.apache.accumulo.core.conf.AccumuloConfiguration;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.conf.PropertyType;
import org.apache.log4j.Logger;

public class ConfigSanityCheck {
    private static final Logger log = Logger.getLogger(ConfigSanityCheck.class);
    private static final String PREFIX = "BAD CONFIG ";

    public static void validate(AccumuloConfiguration acuconf) {
        for (Map.Entry<String, String> entry : acuconf) {
            String key = entry.getKey();
            String value = entry.getValue();
            Property prop = Property.getPropertyByKey(entry.getKey());
            if (prop == null && Property.isValidPropertyKey(key)) continue;
            if (prop == null) {
                log.warn((Object)("BAD CONFIG unrecognized property key (" + key + ")"));
                continue;
            }
            if (prop.getType() == PropertyType.PREFIX) {
                ConfigSanityCheck.fatal("BAD CONFIG incomplete property key (" + key + ")");
                continue;
            }
            if (prop.getType().isValidFormat(value)) continue;
            ConfigSanityCheck.fatal("BAD CONFIG improperly formatted value for key (" + key + ", type=" + (Object)((Object)prop.getType()) + ")");
        }
        ConfigSanityCheck.checkTimeDuration(acuconf, Property.INSTANCE_ZK_TIMEOUT, new CheckTimeDurationBetween(1000L, 300000L));
    }

    private static void checkTimeDuration(AccumuloConfiguration acuconf, Property prop, CheckTimeDuration chk) {
        ConfigSanityCheck.verifyPropertyTypes(PropertyType.TIMEDURATION, prop);
        if (!chk.check(acuconf.getTimeInMillis(prop))) {
            ConfigSanityCheck.fatal(PREFIX + chk.getDescription(prop));
        }
    }

    private static void verifyPropertyTypes(PropertyType type, Property ... properties) {
        for (Property prop : properties) {
            if (prop.getType() == type) continue;
            ConfigSanityCheck.fatal("Unexpected property type (" + (Object)((Object)prop.getType()) + " != " + (Object)((Object)type) + ")");
        }
    }

    private static void fatal(String msg) {
        log.fatal((Object)msg);
        throw new RuntimeException(msg);
    }

    private static class CheckTimeDurationBetween
    implements CheckTimeDuration {
        long min;
        long max;

        CheckTimeDurationBetween(long x, long y) {
            this.min = Math.min(x, y);
            this.max = Math.max(x, y);
        }

        @Override
        public boolean check(long propVal) {
            return propVal >= this.min && propVal <= this.max;
        }

        @Override
        public String getDescription(Property prop) {
            return "ensure " + this.min + " <= " + (Object)((Object)prop) + " <= " + this.max;
        }
    }

    private static interface CheckTimeDuration {
        public boolean check(long var1);

        public String getDescription(Property var1);
    }
}

