/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.data;

import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.UUID;
import java.util.WeakHashMap;
import org.apache.accumulo.core.Constants;
import org.apache.accumulo.core.data.ByteSequence;
import org.apache.accumulo.core.data.Mutation;
import org.apache.accumulo.core.data.Range;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.data.thrift.TKeyExtent;
import org.apache.accumulo.core.util.ByteBufferUtil;
import org.apache.accumulo.core.util.TextUtil;
import org.apache.hadoop.io.BinaryComparable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.WritableComparable;

public class KeyExtent
implements WritableComparable<KeyExtent> {
    private static final WeakHashMap<Text, WeakReference<Text>> tableIds = new WeakHashMap();
    private Text textTableId;
    private Text textEndRow;
    private Text textPrevEndRow;
    private int hashCode = 0;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Text dedupeTableId(Text tableId) {
        WeakHashMap<Text, WeakReference<Text>> weakHashMap = tableIds;
        synchronized (weakHashMap) {
            Text eti;
            WeakReference<Text> etir = tableIds.get(tableId);
            if (etir != null && (eti = (Text)etir.get()) != null) {
                return eti;
            }
            tableId = new Text(tableId);
            tableIds.put(tableId, new WeakReference<Text>(tableId));
            return tableId;
        }
    }

    private void check() {
        if (this.getTableId() == null) {
            throw new IllegalArgumentException("null table id not allowed");
        }
        if (this.getEndRow() == null || this.getPrevEndRow() == null) {
            return;
        }
        if (this.getPrevEndRow().compareTo((BinaryComparable)this.getEndRow()) >= 0) {
            throw new IllegalArgumentException("prevEndRow (" + this.getPrevEndRow() + ") >= endRow (" + this.getEndRow() + ")");
        }
    }

    public KeyExtent() {
        this.setTableId(new Text());
        this.setEndRow(new Text(), false, false);
        this.setPrevEndRow(new Text(), false, false);
    }

    public KeyExtent(Text table, Text endRow, Text prevEndRow) {
        this.setTableId(table);
        this.setEndRow(endRow, false, true);
        this.setPrevEndRow(prevEndRow, false, true);
        this.check();
    }

    public KeyExtent(KeyExtent extent) {
        this.textTableId = extent.textTableId;
        this.setEndRow(extent.getEndRow(), false, true);
        this.setPrevEndRow(extent.getPrevEndRow(), false, true);
        this.check();
    }

    public KeyExtent(TKeyExtent tke) {
        this.setTableId(new Text(ByteBufferUtil.toBytes(tke.table)));
        this.setEndRow(tke.endRow == null ? null : new Text(ByteBufferUtil.toBytes(tke.endRow)), false, false);
        this.setPrevEndRow(tke.prevEndRow == null ? null : new Text(ByteBufferUtil.toBytes(tke.prevEndRow)), false, false);
        this.check();
    }

    public Text getMetadataEntry() {
        return KeyExtent.getMetadataEntry(this.getTableId(), this.getEndRow());
    }

    public static Text getMetadataEntry(Text table, Text row) {
        Text entry = new Text(table);
        if (row == null) {
            entry.append(new byte[]{60}, 0, 1);
        } else {
            entry.append(new byte[]{59}, 0, 1);
            entry.append(row.getBytes(), 0, row.getLength());
        }
        return entry;
    }

    public KeyExtent(Text flattenedExtent, Value prevEndRow) {
        this.decodeMetadataRow(flattenedExtent);
        this.setPrevEndRow(KeyExtent.decodePrevEndRow(prevEndRow), false, true);
        this.check();
    }

    public KeyExtent(Text flattenedExtent, Text prevEndRow) {
        this.decodeMetadataRow(flattenedExtent);
        this.setPrevEndRow(null, false, false);
        if (prevEndRow != null) {
            this.setPrevEndRow(prevEndRow, false, true);
        }
        this.check();
    }

    public void setTableId(Text tId) {
        if (tId == null) {
            throw new IllegalArgumentException("null table name not allowed");
        }
        this.textTableId = KeyExtent.dedupeTableId(tId);
        this.hashCode = 0;
    }

    public Text getTableId() {
        return this.textTableId;
    }

    private void setEndRow(Text endRow, boolean check, boolean copy) {
        this.textEndRow = endRow != null ? (copy ? new Text(endRow) : endRow) : null;
        this.hashCode = 0;
        if (check) {
            this.check();
        }
    }

    public void setEndRow(Text endRow) {
        this.setEndRow(endRow, true, true);
    }

    public Text getEndRow() {
        return this.textEndRow;
    }

    public Text getPrevEndRow() {
        return this.textPrevEndRow;
    }

    private void setPrevEndRow(Text prevEndRow, boolean check, boolean copy) {
        this.textPrevEndRow = prevEndRow != null ? (copy ? new Text(prevEndRow) : prevEndRow) : null;
        this.hashCode = 0;
        if (check) {
            this.check();
        }
    }

    public void setPrevEndRow(Text prevEndRow) {
        this.setPrevEndRow(prevEndRow, true, true);
    }

    public void readFields(DataInput in) throws IOException {
        Text tid = new Text();
        tid.readFields(in);
        this.setTableId(tid);
        boolean hasRow = in.readBoolean();
        if (hasRow) {
            Text er = new Text();
            er.readFields(in);
            this.setEndRow(er, false, false);
        } else {
            this.setEndRow(null, false, false);
        }
        boolean hasPrevRow = in.readBoolean();
        if (hasPrevRow) {
            Text per = new Text();
            per.readFields(in);
            this.setPrevEndRow(per, false, true);
        } else {
            this.setPrevEndRow(null);
        }
        this.hashCode = 0;
        this.check();
    }

    public void write(DataOutput out) throws IOException {
        this.getTableId().write(out);
        if (this.getEndRow() != null) {
            out.writeBoolean(true);
            this.getEndRow().write(out);
        } else {
            out.writeBoolean(false);
        }
        if (this.getPrevEndRow() != null) {
            out.writeBoolean(true);
            this.getPrevEndRow().write(out);
        } else {
            out.writeBoolean(false);
        }
    }

    public Mutation getPrevRowUpdateMutation() {
        return KeyExtent.getPrevRowUpdateMutation(this);
    }

    public static Collection<KeyExtent> getKeyExtentsForRange(Text startRow, Text endRow, Set<KeyExtent> kes) {
        if (kes == null) {
            return Collections.emptyList();
        }
        if (startRow == null) {
            startRow = new Text();
        }
        if (endRow == null) {
            endRow = new Text();
        }
        ArrayList<KeyExtent> keys = new ArrayList<KeyExtent>();
        for (KeyExtent ckes : kes) {
            if (ckes.getPrevEndRow() == null) {
                if (ckes.getEndRow() == null) {
                    keys.add(ckes);
                    continue;
                }
                if (startRow.getLength() == 0) {
                    keys.add(ckes);
                    continue;
                }
                if (ckes.getEndRow().compareTo((BinaryComparable)startRow) < 0) continue;
                keys.add(ckes);
                continue;
            }
            if (ckes.getEndRow() == null) {
                if (endRow.getLength() == 0) {
                    keys.add(ckes);
                }
                if (ckes.getPrevEndRow().compareTo((BinaryComparable)endRow) >= 0) continue;
                keys.add(ckes);
                continue;
            }
            if (startRow.getLength() == 0) {
                if (endRow.getLength() == 0) {
                    keys.add(ckes);
                    continue;
                }
                if (ckes.getPrevEndRow().compareTo((BinaryComparable)endRow) >= 0) continue;
                keys.add(ckes);
                continue;
            }
            if (endRow.getLength() == 0) {
                if (ckes.getEndRow().compareTo((BinaryComparable)startRow) < 0) continue;
                keys.add(ckes);
                continue;
            }
            if (ckes.getPrevEndRow().compareTo((BinaryComparable)endRow) >= 0 || ckes.getEndRow().compareTo((BinaryComparable)startRow) < 0) continue;
            keys.add(ckes);
        }
        return keys;
    }

    public static Text decodePrevEndRow(Value ibw) {
        Text per = null;
        if (ibw.get()[0] != 0) {
            per = new Text();
            per.set(ibw.get(), 1, ibw.get().length - 1);
        }
        return per;
    }

    public static Value encodePrevEndRow(Text per) {
        if (per == null) {
            return new Value(new byte[]{0});
        }
        byte[] b = new byte[per.getLength() + 1];
        b[0] = 1;
        System.arraycopy(per.getBytes(), 0, b, 1, per.getLength());
        return new Value(b);
    }

    public static Mutation getPrevRowUpdateMutation(KeyExtent ke) {
        Mutation m = new Mutation(ke.getMetadataEntry());
        Constants.METADATA_PREV_ROW_COLUMN.put(m, KeyExtent.encodePrevEndRow(ke.getPrevEndRow()));
        return m;
    }

    public int compareTo(KeyExtent other) {
        int result = this.getTableId().compareTo((BinaryComparable)other.getTableId());
        if (result != 0) {
            return result;
        }
        if (this.getEndRow() == null) {
            if (other.getEndRow() != null) {
                return 1;
            }
        } else {
            if (other.getEndRow() == null) {
                return -1;
            }
            result = this.getEndRow().compareTo((BinaryComparable)other.getEndRow());
            if (result != 0) {
                return result;
            }
        }
        if (this.getPrevEndRow() == null) {
            if (other.getPrevEndRow() == null) {
                return 0;
            }
            return -1;
        }
        if (other.getPrevEndRow() == null) {
            return 1;
        }
        return this.getPrevEndRow().compareTo((BinaryComparable)other.getPrevEndRow());
    }

    public int hashCode() {
        if (this.hashCode != 0) {
            return this.hashCode;
        }
        int prevEndRowHash = 0;
        int endRowHash = 0;
        if (this.getEndRow() != null) {
            endRowHash = this.getEndRow().hashCode();
        }
        if (this.getPrevEndRow() != null) {
            prevEndRowHash = this.getPrevEndRow().hashCode();
        }
        this.hashCode = this.getTableId().hashCode() + endRowHash + prevEndRowHash;
        return this.hashCode;
    }

    private boolean equals(Text t1, Text t2) {
        if (t1 == null || t2 == null) {
            return t1 == t2;
        }
        return t1.equals((Object)t2);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof KeyExtent)) {
            return false;
        }
        KeyExtent oke = (KeyExtent)o;
        return this.textTableId.equals((Object)oke.textTableId) && this.equals(this.textEndRow, oke.textEndRow) && this.equals(this.textPrevEndRow, oke.textPrevEndRow);
    }

    public String toString() {
        String tableIdString = this.getTableId().toString().replaceAll(";", "\\\\;").replaceAll("\\\\", "\\\\\\\\");
        String endRowString = this.getEndRow() == null ? "<" : ";" + TextUtil.truncate(this.getEndRow()).toString().replaceAll(";", "\\\\;").replaceAll("\\\\", "\\\\\\\\");
        String prevEndRowString = this.getPrevEndRow() == null ? "<" : ";" + TextUtil.truncate(this.getPrevEndRow()).toString().replaceAll(";", "\\\\;").replaceAll("\\\\", "\\\\\\\\");
        return tableIdString + endRowString + prevEndRowString;
    }

    public UUID getUUID() {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            DataOutputStream dos = new DataOutputStream(baos);
            this.write(dos);
            dos.close();
            return UUID.nameUUIDFromBytes(baos.toByteArray());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void decodeMetadataRow(Text flattenedExtent) {
        int semiPos = -1;
        int ltPos = -1;
        for (int i = 0; i < flattenedExtent.getLength(); ++i) {
            if (flattenedExtent.getBytes()[i] == 59 && semiPos < 0) {
                semiPos = i;
            }
            if (flattenedExtent.getBytes()[i] != 60) continue;
            ltPos = i;
        }
        if (semiPos < 0 && ltPos < 0) {
            throw new IllegalArgumentException("Metadata row does not contain ; or <  " + flattenedExtent);
        }
        if (semiPos < 0) {
            if (ltPos != flattenedExtent.getLength() - 1) {
                throw new IllegalArgumentException("< must come at end of Metadata row  " + flattenedExtent);
            }
            Text tableId = new Text();
            tableId.set(flattenedExtent.getBytes(), 0, flattenedExtent.getLength() - 1);
            this.setTableId(tableId);
            this.setEndRow(null, false, false);
        } else {
            Text tableId = new Text();
            tableId.set(flattenedExtent.getBytes(), 0, semiPos);
            Text endRow = new Text();
            endRow.set(flattenedExtent.getBytes(), semiPos + 1, flattenedExtent.getLength() - (semiPos + 1));
            this.setTableId(tableId);
            this.setEndRow(endRow, false, false);
        }
    }

    public static byte[] tableOfMetadataRow(Text row) {
        KeyExtent ke = new KeyExtent();
        ke.decodeMetadataRow(row);
        return TextUtil.getBytes(ke.getTableId());
    }

    public boolean contains(final ByteSequence bsrow) {
        if (bsrow == null) {
            throw new IllegalArgumentException("Passing null to contains is ambiguous, could be in first or last extent of table");
        }
        BinaryComparable row = new BinaryComparable(){

            public int getLength() {
                return bsrow.length();
            }

            public byte[] getBytes() {
                if (bsrow.isBackedByArray() && bsrow.offset() == 0) {
                    return bsrow.getBackingArray();
                }
                return bsrow.toArray();
            }
        };
        return !(this.getPrevEndRow() != null && this.getPrevEndRow().compareTo(row) >= 0 || this.getEndRow() != null && this.getEndRow().compareTo(row) < 0);
    }

    public boolean contains(BinaryComparable row) {
        if (row == null) {
            throw new IllegalArgumentException("Passing null to contains is ambiguous, could be in first or last extent of table");
        }
        return !(this.getPrevEndRow() != null && this.getPrevEndRow().compareTo(row) >= 0 || this.getEndRow() != null && this.getEndRow().compareTo(row) < 0);
    }

    public Range toDataRange() {
        return new Range(this.getPrevEndRow(), false, this.getEndRow(), true);
    }

    public Range toMetadataRange() {
        Text metadataPrevRow = new Text(this.getTableId());
        metadataPrevRow.append(new byte[]{59}, 0, 1);
        if (this.getPrevEndRow() != null) {
            metadataPrevRow.append(this.getPrevEndRow().getBytes(), 0, this.getPrevEndRow().getLength());
        }
        Range range = new Range(metadataPrevRow, this.getPrevEndRow() == null, this.getMetadataEntry(), true);
        return range;
    }

    public static SortedSet<KeyExtent> findChildren(KeyExtent ke, SortedSet<KeyExtent> tablets) {
        TreeSet<KeyExtent> children = null;
        for (KeyExtent tabletKe : tablets) {
            if (ke.getPrevEndRow() == tabletKe.getPrevEndRow() || ke.getPrevEndRow() != null && tabletKe.getPrevEndRow() != null && tabletKe.getPrevEndRow().compareTo((BinaryComparable)ke.getPrevEndRow()) == 0) {
                children = new TreeSet<KeyExtent>();
            }
            if (children != null) {
                children.add(tabletKe);
            }
            if (ke.getEndRow() != tabletKe.getEndRow() && (ke.getEndRow() == null || tabletKe.getEndRow() == null || tabletKe.getEndRow().compareTo((BinaryComparable)ke.getEndRow()) != 0)) continue;
            return children;
        }
        return new TreeSet<KeyExtent>();
    }

    public static KeyExtent findContainingExtent(KeyExtent extent, SortedSet<KeyExtent> extents) {
        KeyExtent lookupExtent = new KeyExtent(extent);
        lookupExtent.setPrevEndRow(null);
        SortedSet<KeyExtent> tailSet = extents.tailSet(lookupExtent);
        if (tailSet.isEmpty()) {
            return null;
        }
        KeyExtent first = tailSet.first();
        if (first.getTableId().compareTo((BinaryComparable)extent.getTableId()) != 0) {
            return null;
        }
        if (first.getPrevEndRow() == null) {
            return first;
        }
        if (extent.getPrevEndRow() == null) {
            return null;
        }
        if (extent.getPrevEndRow().compareTo((BinaryComparable)first.getPrevEndRow()) >= 0) {
            return first;
        }
        return null;
    }

    private static boolean startsAfter(KeyExtent nke, KeyExtent ke) {
        int tiCmp = ke.getTableId().compareTo((BinaryComparable)nke.getTableId());
        if (tiCmp > 0) {
            return true;
        }
        return ke.getPrevEndRow() != null && nke.getEndRow() != null && ke.getPrevEndRow().compareTo((BinaryComparable)nke.getEndRow()) >= 0;
    }

    private static Text rowAfterPrevRow(KeyExtent nke) {
        Text row = new Text(nke.getPrevEndRow());
        row.append(new byte[]{0}, 0, 1);
        return row;
    }

    public static Set<KeyExtent> findOverlapping(KeyExtent nke, SortedSet<KeyExtent> extents) {
        KeyExtent ke;
        SortedSet<KeyExtent> start;
        if (nke == null || extents == null || extents.isEmpty()) {
            return Collections.emptySet();
        }
        if (nke.getPrevEndRow() != null) {
            Text row = KeyExtent.rowAfterPrevRow(nke);
            KeyExtent lookupKey = new KeyExtent(nke.getTableId(), row, null);
            start = extents.tailSet(lookupKey);
        } else {
            KeyExtent lookupKey = new KeyExtent(nke.getTableId(), new Text(), null);
            start = extents.tailSet(lookupKey);
        }
        TreeSet<KeyExtent> result = new TreeSet<KeyExtent>();
        Iterator i$ = start.iterator();
        while (i$.hasNext() && !KeyExtent.startsAfter(nke, ke = (KeyExtent)i$.next())) {
            result.add(ke);
        }
        return result;
    }

    public boolean overlaps(KeyExtent other) {
        TreeSet<KeyExtent> set = new TreeSet<KeyExtent>();
        set.add(other);
        return !KeyExtent.findOverlapping(this, set).isEmpty();
    }

    public static Set<KeyExtent> findOverlapping(KeyExtent nke, SortedMap<KeyExtent, ? extends Object> extents) {
        Map.Entry<KeyExtent, ? extends Object> entry;
        KeyExtent ke;
        SortedMap<KeyExtent, ? extends Object> start;
        if (nke == null || extents == null || extents.isEmpty()) {
            return Collections.emptySet();
        }
        if (nke.getPrevEndRow() != null) {
            Text row = KeyExtent.rowAfterPrevRow(nke);
            KeyExtent lookupKey = new KeyExtent(nke.getTableId(), row, null);
            start = extents.tailMap(lookupKey);
        } else {
            KeyExtent lookupKey = new KeyExtent(nke.getTableId(), new Text(), null);
            start = extents.tailMap(lookupKey);
        }
        TreeSet<KeyExtent> result = new TreeSet<KeyExtent>();
        Iterator<Map.Entry<KeyExtent, ? extends Object>> i$ = start.entrySet().iterator();
        while (i$.hasNext() && !KeyExtent.startsAfter(nke, ke = (entry = i$.next()).getKey())) {
            result.add(ke);
        }
        return result;
    }

    public static Text getMetadataEntry(KeyExtent extent) {
        return KeyExtent.getMetadataEntry(extent.getTableId(), extent.getEndRow());
    }

    public TKeyExtent toThrift() {
        return new TKeyExtent(TextUtil.getByteBuffer(this.textTableId), this.textEndRow == null ? null : TextUtil.getByteBuffer(this.textEndRow), this.textPrevEndRow == null ? null : TextUtil.getByteBuffer(this.textPrevEndRow));
    }

    public boolean isPreviousExtent(KeyExtent prevExtent) {
        if (prevExtent == null) {
            return this.getPrevEndRow() == null;
        }
        if (!prevExtent.getTableId().equals((Object)this.getTableId())) {
            throw new IllegalArgumentException("Cannot compare accross tables " + prevExtent + " " + this);
        }
        if (prevExtent.getEndRow() == null) {
            return false;
        }
        if (this.getPrevEndRow() == null) {
            return false;
        }
        return prevExtent.getEndRow().equals((Object)this.getPrevEndRow());
    }

    public boolean isMeta() {
        return this.getTableId().toString().equals("!0");
    }

    public boolean isRootTablet() {
        return this.compareTo(Constants.ROOT_TABLET_EXTENT) == 0;
    }
}

