/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.security.crypto;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PushbackInputStream;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.SecureRandom;
import java.util.HashMap;
import java.util.Map;
import javax.crypto.Cipher;
import javax.crypto.CipherInputStream;
import javax.crypto.CipherOutputStream;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.security.crypto.CryptoModule;
import org.apache.accumulo.core.security.crypto.CryptoModuleFactory;
import org.apache.accumulo.core.security.crypto.DefaultCryptoModuleUtils;
import org.apache.accumulo.core.security.crypto.SecretKeyEncryptionStrategy;
import org.apache.accumulo.core.security.crypto.SecretKeyEncryptionStrategyContext;
import org.apache.log4j.Logger;

@Deprecated
public class DefaultCryptoModule
implements CryptoModule {
    private static final String ENCRYPTION_HEADER_MARKER = "---Log File Encrypted (v1)---";
    private static Logger log = Logger.getLogger(DefaultCryptoModule.class);

    @Override
    public OutputStream getEncryptingOutputStream(OutputStream out, Map<String, String> cryptoOpts) throws IOException {
        log.debug((Object)"Initializing crypto output stream");
        String cipherSuite = cryptoOpts.get(Property.CRYPTO_CIPHER_SUITE.getKey());
        if (cipherSuite.equals("NullCipher")) {
            return out;
        }
        String algorithmName = cryptoOpts.get(Property.CRYPTO_CIPHER_ALGORITHM_NAME.getKey());
        String secureRNG = cryptoOpts.get(Property.CRYPTO_SECURE_RNG.getKey());
        String secureRNGProvider = cryptoOpts.get(Property.CRYPTO_SECURE_RNG_PROVIDER.getKey());
        SecureRandom secureRandom = DefaultCryptoModuleUtils.getSecureRandom(secureRNG, secureRNGProvider);
        int keyLength = Integer.parseInt(cryptoOpts.get(Property.CRYPTO_CIPHER_KEY_LENGTH.getKey()));
        byte[] randomKey = new byte[keyLength / 8];
        HashMap<CryptoModule.CryptoInitProperty, Object> cryptoInitParams = new HashMap<CryptoModule.CryptoInitProperty, Object>();
        secureRandom.nextBytes(randomKey);
        cryptoInitParams.put(CryptoModule.CryptoInitProperty.PLAINTEXT_SESSION_KEY, randomKey);
        SecretKeyEncryptionStrategy keyEncryptionStrategy = CryptoModuleFactory.getSecretKeyEncryptionStrategy(cryptoOpts.get(Property.CRYPTO_SECRET_KEY_ENCRYPTION_STRATEGY_CLASS.getKey()));
        SecretKeyEncryptionStrategyContext keyEncryptionStrategyContext = keyEncryptionStrategy.getNewContext();
        keyEncryptionStrategyContext.setPlaintextSecretKey(randomKey);
        keyEncryptionStrategyContext.setContext(cryptoOpts);
        keyEncryptionStrategyContext = keyEncryptionStrategy.encryptSecretKey(keyEncryptionStrategyContext);
        byte[] encryptedRandomKey = keyEncryptionStrategyContext.getEncryptedSecretKey();
        String opaqueId = keyEncryptionStrategyContext.getOpaqueKeyEncryptionKeyID();
        OutputStream cipherOutputStream = this.getEncryptingOutputStream(out, cryptoOpts, cryptoInitParams);
        byte[] initVector = (byte[])cryptoInitParams.get((Object)CryptoModule.CryptoInitProperty.INITIALIZATION_VECTOR);
        DataOutputStream dataOut = new DataOutputStream(out);
        dataOut.writeUTF(ENCRYPTION_HEADER_MARKER);
        dataOut.writeUTF(cipherSuite);
        dataOut.writeUTF(algorithmName);
        dataOut.writeInt(initVector.length);
        dataOut.write(initVector);
        dataOut.writeUTF(opaqueId);
        dataOut.writeInt(encryptedRandomKey.length);
        dataOut.write(encryptedRandomKey);
        return cipherOutputStream;
    }

    @Override
    public InputStream getDecryptingInputStream(InputStream in, Map<String, String> cryptoOpts) throws IOException {
        DataInputStream dataIn = new DataInputStream(in);
        String marker = dataIn.readUTF();
        log.debug((Object)"Read encryption header");
        if (marker.equals(ENCRYPTION_HEADER_MARKER)) {
            String cipherSuiteFromFile = dataIn.readUTF();
            String algorithmNameFromFile = dataIn.readUTF();
            int initVectorLength = dataIn.readInt();
            byte[] initVector = new byte[initVectorLength];
            dataIn.read(initVector, 0, initVectorLength);
            String opaqueId = dataIn.readUTF();
            int encryptedSecretKeyLength = dataIn.readInt();
            byte[] encryptedSecretKey = new byte[encryptedSecretKeyLength];
            dataIn.read(encryptedSecretKey);
            SecretKeyEncryptionStrategy keyEncryptionStrategy = CryptoModuleFactory.getSecretKeyEncryptionStrategy(cryptoOpts.get(Property.CRYPTO_SECRET_KEY_ENCRYPTION_STRATEGY_CLASS.getKey()));
            SecretKeyEncryptionStrategyContext keyEncryptionStrategyContext = keyEncryptionStrategy.getNewContext();
            keyEncryptionStrategyContext.setOpaqueKeyEncryptionKeyID(opaqueId);
            keyEncryptionStrategyContext.setContext(cryptoOpts);
            keyEncryptionStrategyContext.setEncryptedSecretKey(encryptedSecretKey);
            keyEncryptionStrategyContext = keyEncryptionStrategy.decryptSecretKey(keyEncryptionStrategyContext);
            byte[] secretKey = keyEncryptionStrategyContext.getPlaintextSecretKey();
            HashMap<CryptoModule.CryptoInitProperty, Object> cryptoInitParams = new HashMap<CryptoModule.CryptoInitProperty, Object>();
            cryptoInitParams.put(CryptoModule.CryptoInitProperty.CIPHER_SUITE, cipherSuiteFromFile);
            cryptoInitParams.put(CryptoModule.CryptoInitProperty.ALGORITHM_NAME, algorithmNameFromFile);
            cryptoInitParams.put(CryptoModule.CryptoInitProperty.PLAINTEXT_SESSION_KEY, secretKey);
            cryptoInitParams.put(CryptoModule.CryptoInitProperty.INITIALIZATION_VECTOR, initVector);
            InputStream cipherInputStream = this.getDecryptingInputStream(dataIn, cryptoOpts, cryptoInitParams);
            return cipherInputStream;
        }
        ByteArrayOutputStream tempByteOut = new ByteArrayOutputStream();
        DataOutputStream tempOut = new DataOutputStream(tempByteOut);
        tempOut.writeUTF(marker);
        byte[] bytesToPutBack = tempByteOut.toByteArray();
        PushbackInputStream pushbackStream = new PushbackInputStream(in, bytesToPutBack.length);
        pushbackStream.unread(bytesToPutBack);
        return pushbackStream;
    }

    @Override
    public OutputStream getEncryptingOutputStream(OutputStream out, Map<String, String> conf, Map<CryptoModule.CryptoInitProperty, Object> cryptoInitParams) {
        log.debug((Object)"Initializing crypto output stream");
        String cipherSuite = conf.get(Property.CRYPTO_CIPHER_SUITE.getKey());
        if (cipherSuite.equals("NullCipher")) {
            return out;
        }
        String algorithmName = conf.get(Property.CRYPTO_CIPHER_ALGORITHM_NAME.getKey());
        String secureRNG = conf.get(Property.CRYPTO_SECURE_RNG.getKey());
        String secureRNGProvider = conf.get(Property.CRYPTO_SECURE_RNG_PROVIDER.getKey());
        int keyLength = Integer.parseInt(conf.get(Property.CRYPTO_CIPHER_KEY_LENGTH.getKey()));
        String keyStrategyName = conf.get(Property.CRYPTO_SECRET_KEY_ENCRYPTION_STRATEGY_CLASS.getKey());
        log.debug((Object)String.format("Using cipher suite \"%s\" (algorithm \"%s\") with key length %d with RNG \"%s\" and RNG provider \"%s\" and key encryption strategy %s", cipherSuite, algorithmName, keyLength, secureRNG, secureRNGProvider, keyStrategyName));
        SecureRandom secureRandom = DefaultCryptoModuleUtils.getSecureRandom(secureRNG, secureRNGProvider);
        Cipher cipher = DefaultCryptoModuleUtils.getCipher(cipherSuite);
        byte[] randomKey = (byte[])cryptoInitParams.get((Object)CryptoModule.CryptoInitProperty.PLAINTEXT_SESSION_KEY);
        byte[] initVector = (byte[])cryptoInitParams.get((Object)CryptoModule.CryptoInitProperty.INITIALIZATION_VECTOR);
        if (initVector != null) {
            try {
                cipher.init(1, (Key)new SecretKeySpec(randomKey, algorithmName), new IvParameterSpec(initVector));
            }
            catch (InvalidKeyException e) {
                log.error((Object)"Accumulo encountered an unknown error in generating the secret key object (SecretKeySpec) for an encrypted stream");
                throw new RuntimeException(e);
            }
            catch (InvalidAlgorithmParameterException e) {
                log.error((Object)"Accumulo encountered an unknown error in generating the secret key object (SecretKeySpec) for an encrypted stream");
                throw new RuntimeException(e);
            }
        }
        try {
            cipher.init(1, (Key)new SecretKeySpec(randomKey, algorithmName), secureRandom);
        }
        catch (InvalidKeyException e) {
            log.error((Object)"Accumulo encountered an unknown error in generating the secret key object (SecretKeySpec) for the write-ahead log");
            throw new RuntimeException(e);
        }
        initVector = cipher.getIV();
        cryptoInitParams.put(CryptoModule.CryptoInitProperty.INITIALIZATION_VECTOR, initVector);
        CipherOutputStream cipherOutputStream = new CipherOutputStream(out, cipher);
        BufferedOutputStream bufferedCipherOutputStream = new BufferedOutputStream(cipherOutputStream);
        return bufferedCipherOutputStream;
    }

    @Override
    public InputStream getDecryptingInputStream(InputStream in, Map<String, String> cryptoOpts, Map<CryptoModule.CryptoInitProperty, Object> cryptoInitParams) throws IOException {
        String cipherSuite = cryptoOpts.get(Property.CRYPTO_CIPHER_SUITE.getKey());
        String algorithmName = cryptoOpts.get(Property.CRYPTO_CIPHER_ALGORITHM_NAME.getKey());
        String cipherSuiteFromInitParams = (String)cryptoInitParams.get((Object)CryptoModule.CryptoInitProperty.CIPHER_SUITE);
        String algorithmNameFromInitParams = (String)cryptoInitParams.get((Object)CryptoModule.CryptoInitProperty.ALGORITHM_NAME);
        byte[] initVector = (byte[])cryptoInitParams.get((Object)CryptoModule.CryptoInitProperty.INITIALIZATION_VECTOR);
        byte[] secretKey = (byte[])cryptoInitParams.get((Object)CryptoModule.CryptoInitProperty.PLAINTEXT_SESSION_KEY);
        if (initVector == null || secretKey == null || cipherSuiteFromInitParams == null || algorithmNameFromInitParams == null) {
            log.error((Object)"Called getDecryptingInputStream() without proper crypto init params.  Need initVector, plaintext key, cipher suite and algorithm name");
            throw new RuntimeException("Called getDecryptingInputStream() without initialization vector and/or plaintext session key");
        }
        if (!cipherSuiteFromInitParams.equals(cipherSuite) || !algorithmNameFromInitParams.equals(algorithmName)) {
            log.warn((Object)String.format("Configured cipher suite and algorithm (\"%s\" and \"%s\") is different from cipher suite found in log file (\"%s\" and \"%s\")", cipherSuite, algorithmName, cipherSuiteFromInitParams, algorithmNameFromInitParams));
        }
        Cipher cipher = DefaultCryptoModuleUtils.getCipher(cipherSuiteFromInitParams);
        try {
            cipher.init(2, (Key)new SecretKeySpec(secretKey, algorithmNameFromInitParams), new IvParameterSpec(initVector));
        }
        catch (InvalidKeyException e) {
            log.error((Object)"Error when trying to initialize cipher with secret key");
            throw new RuntimeException(e);
        }
        catch (InvalidAlgorithmParameterException e) {
            log.error((Object)"Error when trying to initialize cipher with initialization vector");
            throw new RuntimeException(e);
        }
        BufferedInputStream bufferedDecryptingInputStream = new BufferedInputStream(new CipherInputStream(in, cipher));
        return bufferedDecryptingInputStream;
    }
}

