/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.util.shell.commands;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.accumulo.core.client.admin.ActiveScan;
import org.apache.accumulo.core.client.admin.InstanceOperations;
import org.apache.accumulo.core.client.admin.ScanType;
import org.apache.accumulo.core.util.Duration;

class ActiveScanIterator
implements Iterator<String> {
    private InstanceOperations instanceOps;
    private Iterator<String> tsIter;
    private Iterator<String> scansIter;

    private void readNext() {
        ArrayList<String> scans = new ArrayList<String>();
        while (this.tsIter.hasNext()) {
            String tserver = this.tsIter.next();
            try {
                List<ActiveScan> asl = this.instanceOps.getActiveScans(tserver);
                for (ActiveScan as : asl) {
                    scans.add(String.format("%21s |%21s |%9s |%9s |%7s |%6s |%8s |%8s |%10s |%20s |%10s |%10s | %s", new Object[]{tserver, as.getClient(), Duration.format(as.getAge(), "", "-"), Duration.format(as.getLastContactTime(), "", "-"), as.getState(), as.getType(), as.getUser(), as.getTable(), as.getColumns(), as.getAuthorizations(), as.getType() == ScanType.SINGLE ? as.getExtent() : "N/A", as.getSsiList(), as.getSsio()}));
                }
            }
            catch (Exception e) {
                scans.add(tserver + " ERROR " + e.getMessage());
            }
            if (scans.size() <= 0) continue;
            break;
        }
        this.scansIter = scans.iterator();
    }

    ActiveScanIterator(List<String> tservers, InstanceOperations instanceOps) {
        this.instanceOps = instanceOps;
        this.tsIter = tservers.iterator();
        String header = String.format(" %-21s| %-21s| %-9s| %-9s| %-7s| %-6s| %-8s| %-8s| %-10s| %-20s| %-10s| %-10s | %s", "TABLET SERVER", "CLIENT", "AGE", "LAST", "STATE", "TYPE", "USER", "TABLE", "COLUMNS", "AUTHORIZATIONS", "TABLET", "ITERATORS", "ITERATOR OPTIONS");
        this.scansIter = Collections.singletonList(header).iterator();
    }

    @Override
    public boolean hasNext() {
        return this.scansIter.hasNext();
    }

    @Override
    public String next() {
        String next = this.scansIter.next();
        if (!this.scansIter.hasNext()) {
            this.readNext();
        }
        return next;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

