/*
 * Decompiled with CFR 0.152.
 */
package sdsu.algorithms.data;

import sdsu.algorithms.data.DiscreteProbability;
import sdsu.algorithms.data.OutOfBoundsException;

public class Poisson
extends DiscreteProbability {
    protected double mu;

    public Poisson(double d) throws OutOfBoundsException {
        if (d <= 0.0) {
            throw new OutOfBoundsException("averageEvents must be greater than 0.0, your value was " + d);
        }
        this.mu = d;
    }

    public double density(double d) {
        int n = (int)d;
        if (d <= 0.0) {
            return 0.0;
        }
        double d2 = 0.0;
        try {
            d2 = Math.pow(this.mu, n) * Math.exp(-this.mu) / (double)this.factorial(n);
        }
        catch (ArithmeticException arithmeticException) {}
        return d2;
    }

    private long factorial(long l) {
        long l2 = 1L;
        long l3 = 2L;
        while (l3 <= l) {
            l2 *= l3;
            ++l3;
        }
        return l2;
    }

    public double mean() {
        return this.mu;
    }

    public double nextElement() {
        double d = Math.exp(-this.mu);
        int n = 0;
        double d2 = 1.0;
        while (d2 >= d) {
            d2 *= this.randomNumber.nextDouble();
            ++n;
        }
        return n;
    }

    public double variance() {
        return this.mu;
    }
}

