/*
 * Decompiled with CFR 0.152.
 */
package sdsu.rmi.registry;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.rmi.AccessException;
import java.rmi.AlreadyBoundException;
import java.rmi.NotBoundException;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import sdsu.rmi.registry.RemoteRegistrar;

public class Registrar
implements Registry {
    Registry rmiRegistry;
    RemoteRegistrar uniRegistry;

    public Registrar() throws RemoteException {
        this(1099);
    }

    public Registrar(int n) throws RemoteException {
        this.rmiRegistry = LocateRegistry.getRegistry(n);
    }

    public Registrar(String string) throws RemoteException {
        this(string, 1099);
    }

    public Registrar(String string, int n) throws RemoteException {
        this.rmiRegistry = LocateRegistry.getRegistry(string, n);
    }

    public void bind(String string, Remote remote) throws RemoteException, AlreadyBoundException {
        try {
            RemoteRegistrar remoteRegistrar = (RemoteRegistrar)this.rmiRegistry.lookup("RemoteRegistrar");
            remoteRegistrar.bind(string, remote);
        }
        catch (NotBoundException notBoundException) {
            String string2 = "UniVMRegistry not installed " + notBoundException.toString();
            throw new RemoteException(string2);
        }
    }

    public String[] list() throws RemoteException {
        return this.rmiRegistry.list();
    }

    public Remote lookup(String string) throws RemoteException, NotBoundException, AccessException {
        return this.rmiRegistry.lookup(string);
    }

    public void rebind(String string, String string2) throws RemoteException {
        try {
            RemoteRegistrar remoteRegistrar = (RemoteRegistrar)this.rmiRegistry.lookup("RemoteRegistrar");
            remoteRegistrar.rebind(string, string2);
        }
        catch (NotBoundException notBoundException) {
            String string3 = "UniVMRegistry not installed " + notBoundException.toString();
            throw new RemoteException(string3);
        }
    }

    public void rebind(String string, Remote remote) throws RemoteException {
        try {
            RemoteRegistrar remoteRegistrar = (RemoteRegistrar)this.rmiRegistry.lookup("RemoteRegistrar");
            remoteRegistrar.rebind(string, remote);
        }
        catch (NotBoundException notBoundException) {
            String string2 = "UniVMRegistry not installed " + notBoundException.toString();
            throw new RemoteException(string2);
        }
    }

    public void unbind(String string) throws RemoteException, NotBoundException, AccessException {
        this.rmiRegistry.unbind(string);
    }

    public static String verboseRebind(int n, String string, String string2) throws RemoteException {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        Registrar registrar = new Registrar(n);
        registrar.rebind(string, string2);
        String[] stringArray = registrar.list();
        printWriter.println("The registry now contains object bound to:");
        int n2 = 0;
        while (n2 < stringArray.length) {
            printWriter.println(stringArray[n2]);
            ++n2;
        }
        return stringWriter.toString();
    }
}

