/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.expressions;

import org.apache.hadoop.hive.ql.exec.vector.DoubleColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.LongColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.VectorExpressionDescriptor;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.exec.vector.expressions.CuckooSetDouble;
import org.apache.hadoop.hive.ql.exec.vector.expressions.IDoubleInExpr;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorExpression;

public class DoubleColumnInList
extends VectorExpression
implements IDoubleInExpr {
    private static final long serialVersionUID = 1L;
    private int colNum;
    private int outputColumn;
    private double[] inListValues;
    private transient CuckooSetDouble inSet;

    public DoubleColumnInList(int colNum, int outputColumn) {
        this.colNum = colNum;
        this.outputColumn = outputColumn;
    }

    public DoubleColumnInList() {
        this.inSet = null;
    }

    @Override
    public void evaluate(VectorizedRowBatch batch) {
        if (this.childExpressions != null) {
            super.evaluateChildren(batch);
        }
        if (this.inSet == null) {
            this.inSet = new CuckooSetDouble(this.inListValues.length);
            this.inSet.load(this.inListValues);
        }
        DoubleColumnVector inputColVector = (DoubleColumnVector)batch.cols[this.colNum];
        LongColumnVector outputColVector = (LongColumnVector)batch.cols[this.outputColumn];
        int[] sel = batch.selected;
        boolean[] nullPos = inputColVector.isNull;
        boolean[] outNulls = outputColVector.isNull;
        int n = batch.size;
        double[] vector = inputColVector.vector;
        long[] outputVector = outputColVector.vector;
        if (n == 0) {
            return;
        }
        outputColVector.isRepeating = false;
        outputColVector.noNulls = inputColVector.noNulls;
        if (inputColVector.noNulls) {
            if (inputColVector.isRepeating) {
                outputVector[0] = this.inSet.lookup(vector[0]) ? 1L : 0L;
                outputColVector.isRepeating = true;
            } else if (batch.selectedInUse) {
                for (int j = 0; j != n; ++j) {
                    int i = sel[j];
                    outputVector[i] = this.inSet.lookup(vector[i]) ? 1L : 0L;
                }
            } else {
                for (int i = 0; i != n; ++i) {
                    outputVector[i] = this.inSet.lookup(vector[i]) ? 1L : 0L;
                }
            }
        } else if (inputColVector.isRepeating) {
            if (!nullPos[0]) {
                outputVector[0] = this.inSet.lookup(vector[0]) ? 1L : 0L;
                outNulls[0] = false;
            } else {
                outNulls[0] = true;
            }
            outputColVector.isRepeating = true;
        } else if (batch.selectedInUse) {
            for (int j = 0; j != n; ++j) {
                int i = sel[j];
                outNulls[i] = nullPos[i];
                if (nullPos[i]) continue;
                outputVector[i] = this.inSet.lookup(vector[i]) ? 1L : 0L;
            }
        } else {
            System.arraycopy(nullPos, 0, outNulls, 0, n);
            for (int i = 0; i != n; ++i) {
                if (nullPos[i]) continue;
                outputVector[i] = this.inSet.lookup(vector[i]) ? 1L : 0L;
            }
        }
    }

    @Override
    public int getOutputColumn() {
        return this.outputColumn;
    }

    @Override
    public String getOutputType() {
        return "boolean";
    }

    public int getColNum() {
        return this.colNum;
    }

    public void setColNum(int colNum) {
        this.colNum = colNum;
    }

    public void setOutputColumn(int outputColumn) {
        this.outputColumn = outputColumn;
    }

    public double[] getInListValues() {
        return this.inListValues;
    }

    @Override
    public void setInListValues(double[] a) {
        this.inListValues = a;
    }

    @Override
    public VectorExpressionDescriptor.Descriptor getDescriptor() {
        return null;
    }
}

