/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.parse;

import java.util.HashMap;
import org.antlr.runtime.tree.Tree;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.parse.ASTNode;
import org.apache.hadoop.hive.ql.parse.BaseSemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.CalcitePlanner;
import org.apache.hadoop.hive.ql.parse.ColumnStatsSemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.DDLSemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.ExplainSQRewriteSemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.ExplainSemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.ExportSemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.FunctionSemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.ImportSemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.LoadSemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.MacroSemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.SemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.parse.UpdateDeleteSemanticAnalyzer;
import org.apache.hadoop.hive.ql.plan.HiveOperation;
import org.apache.hadoop.hive.ql.session.SessionState;

public final class SemanticAnalyzerFactory {
    static HashMap<Integer, HiveOperation> commandType = new HashMap();
    static HashMap<Integer, HiveOperation[]> tablePartitionCommandType = new HashMap();

    public static BaseSemanticAnalyzer get(HiveConf conf, ASTNode tree) throws SemanticException {
        if (tree.getToken() == null) {
            throw new RuntimeException("Empty Syntax Tree");
        }
        SemanticAnalyzerFactory.setSessionCommandType(commandType.get(tree.getType()));
        switch (tree.getType()) {
            case 695: {
                return new ExplainSemanticAnalyzer(conf);
            }
            case 696: {
                return new ExplainSQRewriteSemanticAnalyzer(conf);
            }
            case 754: {
                return new LoadSemanticAnalyzer(conf);
            }
            case 698: {
                return new ExportSemanticAnalyzer(conf);
            }
            case 725: {
                return new ImportSemanticAnalyzer(conf);
            }
            case 611: {
                Tree child = tree.getChild(1);
                switch (child.getType()) {
                    case 612: 
                    case 613: 
                    case 614: 
                    case 619: 
                    case 620: 
                    case 621: 
                    case 625: 
                    case 626: 
                    case 628: 
                    case 629: 
                    case 631: 
                    case 634: 
                    case 636: 
                    case 637: {
                        SemanticAnalyzerFactory.setSessionCommandType(commandType.get(child.getType()));
                        return new DDLSemanticAnalyzer(conf);
                    }
                }
                HiveOperation commandType = tablePartitionCommandType.get(child.getType())[tree.getChildCount() > 2 ? 1 : 0];
                SemanticAnalyzerFactory.setSessionCommandType(commandType);
                return new DDLSemanticAnalyzer(conf);
            }
            case 639: {
                Tree child = tree.getChild(1);
                switch (child.getType()) {
                    case 640: 
                    case 641: 
                    case 642: 
                    case 643: 
                    case 644: {
                        SemanticAnalyzerFactory.setSessionCommandType(commandType.get(child.getType()));
                        return new DDLSemanticAnalyzer(conf);
                    }
                }
                assert (child.getType() == 809);
                SemanticAnalyzerFactory.setSessionCommandType(HiveOperation.ALTERVIEW_AS);
                return new SemanticAnalyzer(conf);
            }
            case 607: 
            case 608: 
            case 609: 
            case 610: 
            case 617: 
            case 657: 
            case 659: 
            case 662: 
            case 679: 
            case 680: 
            case 681: 
            case 687: 
            case 689: 
            case 691: 
            case 692: 
            case 693: 
            case 708: 
            case 710: 
            case 755: 
            case 756: 
            case 760: 
            case 819: 
            case 820: 
            case 833: 
            case 834: 
            case 835: 
            case 836: 
            case 837: 
            case 838: 
            case 839: 
            case 840: 
            case 841: 
            case 842: 
            case 843: 
            case 844: 
            case 845: 
            case 846: 
            case 847: 
            case 848: 
            case 849: 
            case 850: 
            case 851: 
            case 868: 
            case 910: 
            case 915: 
            case 916: {
                return new DDLSemanticAnalyzer(conf);
            }
            case 658: 
            case 688: 
            case 813: {
                return new FunctionSemanticAnalyzer(conf);
            }
            case 645: {
                return new ColumnStatsSemanticAnalyzer(conf);
            }
            case 661: 
            case 690: {
                return new MacroSemanticAnalyzer(conf);
            }
            case 678: 
            case 917: {
                return new UpdateDeleteSemanticAnalyzer(conf);
            }
        }
        SemanticAnalyzer semAnalyzer = HiveConf.getBoolVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_CBO_ENABLED) ? new CalcitePlanner(conf) : new SemanticAnalyzer(conf);
        return semAnalyzer;
    }

    private static void setSessionCommandType(HiveOperation commandType) {
        if (SessionState.get() != null) {
            SessionState.get().setCommandType(commandType);
        }
    }

    private SemanticAnalyzerFactory() {
    }

    static {
        commandType.put(695, HiveOperation.EXPLAIN);
        commandType.put(754, HiveOperation.LOAD);
        commandType.put(698, HiveOperation.EXPORT);
        commandType.put(725, HiveOperation.IMPORT);
        commandType.put(657, HiveOperation.CREATEDATABASE);
        commandType.put(687, HiveOperation.DROPDATABASE);
        commandType.put(868, HiveOperation.SWITCHDATABASE);
        commandType.put(663, HiveOperation.CREATETABLE);
        commandType.put(910, HiveOperation.TRUNCATETABLE);
        commandType.put(692, HiveOperation.DROPTABLE);
        commandType.put(681, HiveOperation.DESCTABLE);
        commandType.put(680, HiveOperation.DESCFUNCTION);
        commandType.put(760, HiveOperation.MSCK);
        commandType.put(612, HiveOperation.ALTERTABLE_ADDCOLS);
        commandType.put(631, HiveOperation.ALTERTABLE_REPLACECOLS);
        commandType.put(629, HiveOperation.ALTERTABLE_RENAMECOL);
        commandType.put(628, HiveOperation.ALTERTABLE_RENAME);
        commandType.put(619, HiveOperation.ALTERTABLE_DROPPARTS);
        commandType.put(613, HiveOperation.ALTERTABLE_ADDPARTS);
        commandType.put(636, HiveOperation.ALTERTABLE_TOUCH);
        commandType.put(614, HiveOperation.ALTERTABLE_ARCHIVE);
        commandType.put(637, HiveOperation.ALTERTABLE_UNARCHIVE);
        commandType.put(626, HiveOperation.ALTERTABLE_PROPERTIES);
        commandType.put(620, HiveOperation.ALTERTABLE_PROPERTIES);
        commandType.put(835, HiveOperation.SHOWDATABASES);
        commandType.put(841, HiveOperation.SHOWTABLES);
        commandType.put(833, HiveOperation.SHOWCOLUMNS);
        commandType.put(849, HiveOperation.SHOW_TABLESTATUS);
        commandType.put(850, HiveOperation.SHOW_TBLPROPERTIES);
        commandType.put(843, HiveOperation.SHOW_CREATETABLE);
        commandType.put(837, HiveOperation.SHOWFUNCTIONS);
        commandType.put(838, HiveOperation.SHOWINDEXES);
        commandType.put(840, HiveOperation.SHOWPARTITIONS);
        commandType.put(839, HiveOperation.SHOWLOCKS);
        commandType.put(836, HiveOperation.SHOWLOCKS);
        commandType.put(834, HiveOperation.SHOWCONF);
        commandType.put(658, HiveOperation.CREATEFUNCTION);
        commandType.put(688, HiveOperation.DROPFUNCTION);
        commandType.put(661, HiveOperation.CREATEMACRO);
        commandType.put(690, HiveOperation.DROPMACRO);
        commandType.put(664, HiveOperation.CREATEVIEW);
        commandType.put(693, HiveOperation.DROPVIEW);
        commandType.put(659, HiveOperation.CREATEINDEX);
        commandType.put(689, HiveOperation.DROPINDEX);
        commandType.put(610, HiveOperation.ALTERINDEX_REBUILD);
        commandType.put(609, HiveOperation.ALTERINDEX_PROPS);
        commandType.put(643, HiveOperation.ALTERVIEW_PROPERTIES);
        commandType.put(642, HiveOperation.ALTERVIEW_PROPERTIES);
        commandType.put(640, HiveOperation.ALTERTABLE_ADDPARTS);
        commandType.put(641, HiveOperation.ALTERTABLE_DROPPARTS);
        commandType.put(644, HiveOperation.ALTERVIEW_RENAME);
        commandType.put(639, HiveOperation.ALTERVIEW_AS);
        commandType.put(809, HiveOperation.QUERY);
        commandType.put(756, HiveOperation.LOCKTABLE);
        commandType.put(916, HiveOperation.UNLOCKTABLE);
        commandType.put(755, HiveOperation.LOCKDB);
        commandType.put(915, HiveOperation.UNLOCKDB);
        commandType.put(662, HiveOperation.CREATEROLE);
        commandType.put(691, HiveOperation.DROPROLE);
        commandType.put(708, HiveOperation.GRANT_PRIVILEGE);
        commandType.put(819, HiveOperation.REVOKE_PRIVILEGE);
        commandType.put(844, HiveOperation.SHOW_GRANT);
        commandType.put(710, HiveOperation.GRANT_ROLE);
        commandType.put(820, HiveOperation.REVOKE_ROLE);
        commandType.put(845, HiveOperation.SHOW_ROLES);
        commandType.put(848, HiveOperation.SHOW_ROLES);
        commandType.put(847, HiveOperation.SHOW_ROLE_PRINCIPALS);
        commandType.put(846, HiveOperation.SHOW_ROLE_GRANT);
        commandType.put(608, HiveOperation.ALTERDATABASE);
        commandType.put(607, HiveOperation.ALTERDATABASE_OWNER);
        commandType.put(679, HiveOperation.DESCDATABASE);
        commandType.put(634, HiveOperation.ALTERTABLE_SKEWED);
        commandType.put(645, HiveOperation.ANALYZE_TABLE);
        commandType.put(625, HiveOperation.ALTERTABLE_PARTCOLTYPE);
        commandType.put(842, HiveOperation.SHOW_COMPACTIONS);
        commandType.put(851, HiveOperation.SHOW_TRANSACTIONS);
        tablePartitionCommandType.put(627, new HiveOperation[]{HiveOperation.ALTERTABLE_PROTECTMODE, HiveOperation.ALTERPARTITION_PROTECTMODE});
        tablePartitionCommandType.put(622, new HiveOperation[]{HiveOperation.ALTERTABLE_FILEFORMAT, HiveOperation.ALTERPARTITION_FILEFORMAT});
        tablePartitionCommandType.put(623, new HiveOperation[]{HiveOperation.ALTERTABLE_LOCATION, HiveOperation.ALTERPARTITION_LOCATION});
        tablePartitionCommandType.put(624, new HiveOperation[]{HiveOperation.ALTERTABLE_MERGEFILES, HiveOperation.ALTERPARTITION_MERGEFILES});
        tablePartitionCommandType.put(633, new HiveOperation[]{HiveOperation.ALTERTABLE_SERIALIZER, HiveOperation.ALTERPARTITION_SERIALIZER});
        tablePartitionCommandType.put(632, new HiveOperation[]{HiveOperation.ALTERTABLE_SERDEPROPERTIES, HiveOperation.ALTERPARTITION_SERDEPROPERTIES});
        tablePartitionCommandType.put(630, new HiveOperation[]{null, HiveOperation.ALTERTABLE_RENAMEPART});
        tablePartitionCommandType.put(618, new HiveOperation[]{HiveOperation.ALTERTABLE_COMPACT, HiveOperation.ALTERTABLE_COMPACT});
        tablePartitionCommandType.put(635, new HiveOperation[]{HiveOperation.ALTERTBLPART_SKEWED_LOCATION, HiveOperation.ALTERTBLPART_SKEWED_LOCATION});
        tablePartitionCommandType.put(615, new HiveOperation[]{HiveOperation.ALTERTABLE_BUCKETNUM, HiveOperation.ALTERPARTITION_BUCKETNUM});
        tablePartitionCommandType.put(617, new HiveOperation[]{HiveOperation.ALTERTABLE_CLUSTER_SORT, HiveOperation.ALTERTABLE_CLUSTER_SORT});
        tablePartitionCommandType.put(638, new HiveOperation[]{HiveOperation.ALTERTABLE_UPDATETABLESTATS, HiveOperation.ALTERTABLE_UPDATEPARTSTATS});
    }
}

