/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapreduce.Counter;
import org.apache.pig.ErrorHandler;
import org.apache.pig.impl.util.UDFContext;
import org.apache.pig.tools.pigstats.PigStatusReporter;

public class CounterBasedErrorHandler
implements ErrorHandler {
    public static final String ERROR_HANDLER_COUNTER_GROUP = "error_Handler";
    public static final String ERROR_COUNT = "bad_record_count";
    public static final String RECORD_COUNT = "record__count";
    private final long minErrors;
    private final float errorThreshold;

    public CounterBasedErrorHandler() {
        Configuration conf = UDFContext.getUDFContext().getJobConf();
        this.minErrors = conf.getLong("pig.error-handling.min.error.records", 0L);
        this.errorThreshold = conf.getFloat("pig.error-handling.error.threshold", 0.0f);
    }

    @Override
    public void onSuccess(String uniqueSignature) {
        this.incAndGetCounter(uniqueSignature, RECORD_COUNT);
    }

    @Override
    public void onError(String uniqueSignature, Exception e) {
        long numRecords;
        long numErrors = this.incAndGetCounter(uniqueSignature, ERROR_COUNT);
        boolean exceedThreshold = this.hasErrorExceededThreshold(numErrors, numRecords = this.incAndGetCounter(uniqueSignature, RECORD_COUNT));
        if (exceedThreshold) {
            throw new RuntimeException("Exceeded the error rate while processing records. The latest error seen  ", e);
        }
    }

    private boolean hasErrorExceededThreshold(long numErrors, long numRecords) {
        if (numErrors > 0L && this.errorThreshold <= 0.0f) {
            return true;
        }
        double errRate = (double)numErrors / (double)numRecords;
        return numErrors >= this.minErrors && errRate > (double)this.errorThreshold;
    }

    public long getRecordCount(String signature) {
        Counter counter = this.getCounter(signature, RECORD_COUNT);
        return counter.getValue();
    }

    private long incAndGetCounter(String signature, String counterName) {
        Counter counter = this.getCounter(signature, counterName);
        counter.increment(1L);
        return counter.getValue();
    }

    private Counter getCounter(String signature, String counterName) {
        PigStatusReporter reporter = PigStatusReporter.getInstance();
        Counter counter = reporter.getCounter(ERROR_HANDLER_COUNTER_GROUP, this.getCounterNameForStore(counterName, signature));
        return counter;
    }

    private String getCounterNameForStore(String counterNamePrefix, String signature) {
        StringBuilder counterName = new StringBuilder().append(counterNamePrefix).append("_").append(signature);
        return counterName.toString();
    }
}

