/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.backend.hadoop.executionengine.spark;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.mapred.JobConf;

public class KryoSerializer {
    private static final Log LOG = LogFactory.getLog(KryoSerializer.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] serializeJobConf(JobConf jobConf) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            jobConf.write((DataOutput)new DataOutputStream(out));
        }
        catch (IOException e) {
            LOG.error((Object)"Error serializing job configuration", (Throwable)e);
            byte[] byArray = null;
            return byArray;
        }
        finally {
            try {
                out.close();
            }
            catch (IOException e) {
                LOG.error((Object)"Error closing output stream", (Throwable)e);
            }
        }
        return out.toByteArray();
    }

    public static JobConf deserializeJobConf(byte[] buffer) {
        JobConf conf = new JobConf();
        try {
            conf.readFields((DataInput)new DataInputStream(new ByteArrayInputStream(buffer)));
        }
        catch (IOException e) {
            LOG.error((Object)"Error de-serializing job configuration");
            return null;
        }
        return conf;
    }
}

