/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.newplan.logical.rules;

import java.util.Iterator;
import org.apache.pig.impl.logicalLayer.FrontendException;
import org.apache.pig.newplan.Operator;
import org.apache.pig.newplan.logical.expression.LogicalExpressionPlan;
import org.apache.pig.newplan.logical.expression.UserFuncExpression;
import org.apache.pig.newplan.logical.relational.LOForEach;
import org.apache.pig.newplan.logical.relational.LOGenerate;
import org.apache.pig.newplan.logical.relational.LogicalPlan;

public class OptimizerUtils {
    public static LOGenerate findGenerate(LOForEach foreach) {
        LogicalPlan inner = foreach.getInnerPlan();
        return (LOGenerate)inner.getSinks().get(0);
    }

    public static boolean hasFlatten(LOGenerate gen) {
        boolean hasFlatten = false;
        boolean[] flattenFlags = gen.getFlattenFlags();
        if (flattenFlags != null) {
            for (boolean flatten : flattenFlags) {
                if (!flatten) continue;
                hasFlatten = true;
                break;
            }
        }
        return hasFlatten;
    }

    public static boolean hasFlatten(LOForEach foreach) {
        LOGenerate gen = OptimizerUtils.findGenerate(foreach);
        return OptimizerUtils.hasFlatten(gen);
    }

    public static boolean planHasNonDeterministicUdf(LogicalExpressionPlan filterPlan) throws FrontendException {
        Iterator<Operator> it = filterPlan.getOperators();
        while (it.hasNext()) {
            Operator op = it.next();
            if (!(op instanceof UserFuncExpression) || ((UserFuncExpression)op).isDeterministic()) continue;
            return true;
        }
        return false;
    }
}

