/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapred.LocalJobRunner;
import org.apache.hadoop.mapred.ResourceMgrDelegate;
import org.apache.hadoop.mapred.YARNRunner;
import org.apache.hadoop.mapreduce.Cluster;
import org.apache.hadoop.mapreduce.protocol.ClientProtocol;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.yarn.api.ApplicationClientProtocol;
import org.apache.hadoop.yarn.api.protocolrecords.GetDelegationTokenRequest;
import org.apache.hadoop.yarn.api.protocolrecords.GetDelegationTokenResponse;
import org.apache.hadoop.yarn.client.api.YarnClient;
import org.apache.hadoop.yarn.client.api.impl.YarnClientImpl;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.factories.RecordFactory;
import org.apache.hadoop.yarn.factory.providers.RecordFactoryProvider;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;

public class TestYarnClientProtocolProvider {
    private static final RecordFactory recordFactory = RecordFactoryProvider.getRecordFactory(null);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testClusterWithYarnClientProtocolProvider() throws Exception {
        Configuration conf = new Configuration(false);
        Cluster cluster = null;
        try {
            cluster = new Cluster(conf);
        }
        catch (Exception e) {
            throw new Exception("Failed to initialize a local runner w/o a cluster framework key", e);
        }
        try {
            Assert.assertTrue((String)"client is not a LocalJobRunner", (boolean)(cluster.getClient() instanceof LocalJobRunner));
        }
        finally {
            if (cluster != null) {
                cluster.close();
            }
        }
        try {
            conf = new Configuration();
            conf.set("mapreduce.framework.name", "yarn");
            cluster = new Cluster(conf);
            ClientProtocol client = cluster.getClient();
            Assert.assertTrue((String)"client is a YARNRunner", (boolean)(client instanceof YARNRunner));
        }
        catch (IOException iOException) {
        }
        finally {
            if (cluster != null) {
                cluster.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testClusterGetDelegationToken() throws Exception {
        Configuration conf = new Configuration(false);
        try (Cluster cluster = null;){
            conf = new Configuration();
            conf.set("mapreduce.framework.name", "yarn");
            cluster = new Cluster(conf);
            YARNRunner yrunner = (YARNRunner)cluster.getClient();
            GetDelegationTokenResponse getDTResponse = (GetDelegationTokenResponse)recordFactory.newRecordInstance(GetDelegationTokenResponse.class);
            org.apache.hadoop.yarn.api.records.Token rmDTToken = (org.apache.hadoop.yarn.api.records.Token)recordFactory.newRecordInstance(org.apache.hadoop.yarn.api.records.Token.class);
            rmDTToken.setIdentifier(ByteBuffer.wrap(new byte[2]));
            rmDTToken.setKind("Testclusterkind");
            rmDTToken.setPassword(ByteBuffer.wrap("testcluster".getBytes()));
            rmDTToken.setService("0.0.0.0:8032");
            getDTResponse.setRMDelegationToken(rmDTToken);
            final ApplicationClientProtocol cRMProtocol = (ApplicationClientProtocol)Mockito.mock(ApplicationClientProtocol.class);
            Mockito.when((Object)cRMProtocol.getDelegationToken((GetDelegationTokenRequest)Matchers.any(GetDelegationTokenRequest.class))).thenReturn((Object)getDTResponse);
            ResourceMgrDelegate rmgrDelegate = new ResourceMgrDelegate(new YarnConfiguration(conf)){

                protected void serviceStart() throws Exception {
                    Assert.assertTrue((boolean)(this.client instanceof YarnClientImpl));
                    this.client = (YarnClient)Mockito.spy((Object)this.client);
                    ((YarnClient)Mockito.doNothing().when((Object)this.client)).close();
                    ((YarnClientImpl)this.client).setRMClient(cRMProtocol);
                }
            };
            yrunner.setResourceMgrDelegate(rmgrDelegate);
            Token t = cluster.getDelegationToken(new Text(" "));
            Assert.assertTrue((String)("Token kind is instead " + t.getKind().toString()), (boolean)"Testclusterkind".equals(t.getKind().toString()));
        }
    }
}

